/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.impl.scd;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;

public class Iterators {
    private static final Iterator EMPTY = Collections.EMPTY_LIST.iterator();

    public static <T> Iterator<T> empty() {
        return EMPTY;
    }

    public static <T> Iterator<T> singleton(T value) {
        return new Singleton<T>(value);
    }

    public static final class Array<T>
    extends ReadOnly<T> {
        private final T[] items;
        private int index = 0;

        public Array(T[] items) {
            this.items = items;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.items.length;
        }

        @Override
        public T next() {
            return this.items[this.index++];
        }
    }

    public static final class Union<T>
    extends ReadOnly<T> {
        private final Iterator<? extends T> first;
        private final Iterator<? extends T> second;

        public Union(Iterator<? extends T> first, Iterator<? extends T> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public boolean hasNext() {
            return this.first.hasNext() || this.second.hasNext();
        }

        @Override
        public T next() {
            if (this.first.hasNext()) {
                return this.first.next();
            }
            return this.second.next();
        }
    }

    static final class Unique<T>
    extends Filter<T> {
        private Set<T> values = new LinkedHashSet<T>();

        public Unique(Iterator<? extends T> core) {
            super(core);
        }

        @Override
        protected boolean matches(T value) {
            return this.values.add(value);
        }
    }

    public static abstract class Filter<T>
    extends ReadOnly<T> {
        private final Iterator<? extends T> core;
        private T next;

        protected Filter(Iterator<? extends T> core) {
            this.core = core;
        }

        protected abstract boolean matches(T var1);

        @Override
        public boolean hasNext() {
            while (this.core.hasNext() && this.next == null) {
                this.next = this.core.next();
                if (this.matches(this.next)) continue;
                this.next = null;
            }
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            T r = this.next;
            this.next = null;
            return r;
        }
    }

    public static abstract class Map<T, U>
    extends ReadOnly<T> {
        private final Iterator<? extends U> core;
        private Iterator<? extends T> current;

        protected Map(Iterator<? extends U> core) {
            this.core = core;
        }

        @Override
        public boolean hasNext() {
            while (this.current == null || !this.current.hasNext()) {
                if (!this.core.hasNext()) {
                    return false;
                }
                this.current = this.apply(this.core.next());
            }
            return true;
        }

        @Override
        public T next() {
            return this.current.next();
        }

        protected abstract Iterator<? extends T> apply(U var1);
    }

    public static abstract class Adapter<T, U>
    extends ReadOnly<T> {
        private final Iterator<? extends U> core;

        public Adapter(Iterator<? extends U> core) {
            this.core = core;
        }

        @Override
        public boolean hasNext() {
            return this.core.hasNext();
        }

        @Override
        public T next() {
            return this.filter(this.core.next());
        }

        protected abstract T filter(U var1);
    }

    static final class Singleton<T>
    extends ReadOnly<T> {
        private T next;

        Singleton(T next) {
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            T r = this.next;
            this.next = null;
            return r;
        }
    }

    static abstract class ReadOnly<T>
    implements Iterator<T> {
        ReadOnly() {
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

