/*
 * Decompiled with CFR 0.152.
 */
package de.slub.urn;

import de.slub.urn.RFC;
import de.slub.urn.RFCSupport;
import de.slub.urn.URNSyntaxError;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

public abstract class NamespaceSpecificString
implements RFCSupport {
    private final String encoded;
    private final String raw;

    public NamespaceSpecificString(String nss, Encoding encoding) throws URNSyntaxError {
        if (nss == null || nss.isEmpty()) {
            throw new IllegalArgumentException("Namespace Specific String part cannot be null or empty");
        }
        if (encoding == Encoding.URL_ENCODED) {
            if (!this.isValidURLEncodedNamespaceSpecificString(nss)) {
                throw URNSyntaxError.syntaxError(this.supportedRFC(), String.format("Not allowed characters in Namespace Specific String '%s'", nss));
            }
            this.encoded = NamespaceSpecificString.lowerCaseOctetPairs(nss);
            this.raw = this.decode(this.encoded);
        } else {
            this.encoded = this.encode(nss);
            this.raw = nss;
        }
    }

    protected abstract boolean isValidURLEncodedNamespaceSpecificString(String var1);

    private static String lowerCaseOctetPairs(String s2) {
        StringBuilder sb = new StringBuilder(s2.length());
        try (StringReader sr = new StringReader(s2);){
            int i;
            while ((i = sr.read()) != -1) {
                char c = (char)i;
                if (c == '%') {
                    sb.append('%').append(Character.toLowerCase((char)sr.read())).append(Character.toLowerCase((char)sr.read()));
                    continue;
                }
                sb.append(c);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return sb.toString();
    }

    private String decode(String s2) {
        try {
            return URLDecoder.decode(s2, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            throw new IllegalStateException("Error decoding Namespace Specific String part", e);
        }
    }

    private String encode(String s2) throws URNSyntaxError {
        StringBuilder sb = new StringBuilder();
        for (char c : s2.toCharArray()) {
            if (c == '\u0000') {
                throw URNSyntaxError.syntaxError(this.supportedRFC(), "Illegal character `0` found");
            }
            if (this.isReservedCharacter(c)) {
                this.appendEncoded(sb, c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean isReservedCharacter(char c) {
        return c > '\u0080' || c >= '\u0001' && c <= ' ' || c >= '\u007f' && c <= '\u00ff' || c == '%' || c == '/' || c == '?' || c == '#' || c == '<' || c == '\"' || c == '&' || c == '\\' || c == '>' || c == '[' || c == ']' || c == '^' || c == '`' || c == '{' || c == '|' || c == '}' || c == '~';
    }

    private void appendEncoded(StringBuilder sb, char c) {
        for (byte b : String.valueOf(c).getBytes(StandardCharsets.UTF_8)) {
            sb.append('%');
            sb.append(Character.toLowerCase(Character.forDigit(b >> 4 & 0xF, 16)));
            sb.append(Character.toLowerCase(Character.forDigit(b & 0xF, 16)));
        }
    }

    public NamespaceSpecificString(NamespaceSpecificString instanceForCopying) {
        this.encoded = instanceForCopying.encoded;
        this.raw = instanceForCopying.raw;
    }

    public String unencoded() {
        return this.raw;
    }

    public int hashCode() {
        return this.encoded.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof NamespaceSpecificString && this.encoded.equals(((NamespaceSpecificString)obj).encoded);
    }

    public String toString() {
        return this.encoded;
    }

    @Override
    public boolean supports(RFC rfc) {
        return this.supportedRFC().equals((Object)rfc);
    }

    public static enum Encoding {
        URL_ENCODED,
        NOT_ENCODED;

    }
}

