/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.pgv;

import io.envoyproxy.pgv.ValidationException;
import java.util.HashSet;
import java.util.List;

public final class RepeatedValidation {
    private RepeatedValidation() {
    }

    public static <T> void minItems(String field, List<T> values2, int expected) throws ValidationException {
        if (values2.size() < expected) {
            throw new ValidationException(field, values2, "must have at least " + expected + " items");
        }
    }

    public static <T> void maxItems(String field, List<T> values2, int expected) throws ValidationException {
        if (values2.size() > expected) {
            throw new ValidationException(field, values2, "must have at most " + expected + " items");
        }
    }

    public static <T> void unique(String field, List<T> values2) throws ValidationException {
        HashSet<T> seen = new HashSet<T>();
        for (T value : values2) {
            if (seen.add(value)) continue;
            throw new ValidationException(field, values2, "must have all unique values");
        }
    }

    public static <T> void forEach(List<T> values2, ValidationConsumer<T> consumer) throws ValidationException {
        for (T value : values2) {
            consumer.accept(value);
        }
    }

    @FunctionalInterface
    public static interface ValidationConsumer<T> {
        public void accept(T var1) throws ValidationException;
    }
}

