/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import java.util.LinkedHashSet;
import java.util.Set;

public final class IdentifierSet {
    private final ImmutableSet<String> includes;
    private final ImmutableSet<String> excludes;
    private final Set<String> usedIncludes = new LinkedHashSet<String>();
    private final Set<String> usedExcludes = new LinkedHashSet<String>();

    private IdentifierSet(Builder builder) {
        this.includes = builder.includes.build();
        this.excludes = builder.excludes.build();
    }

    public boolean isEmpty() {
        return this.includes.isEmpty() && this.excludes.isEmpty();
    }

    public boolean includes(ProtoType type) {
        return this.includes(type.toString());
    }

    public boolean includes(ProtoMember protoMember) {
        return this.includes(protoMember.toString());
    }

    private boolean includes(String identifier) {
        if (this.includes.isEmpty()) {
            return !this.exclude(identifier);
        }
        String includeMatch = null;
        String excludeMatch = null;
        String rule = identifier;
        while (rule != null) {
            if (this.excludes.contains(rule)) {
                excludeMatch = rule;
            }
            if (this.includes.contains(rule)) {
                includeMatch = rule;
            }
            rule = IdentifierSet.enclosing(rule);
        }
        if (excludeMatch != null) {
            this.usedExcludes.add(excludeMatch);
            return false;
        }
        if (includeMatch != null) {
            this.usedIncludes.add(includeMatch);
            return true;
        }
        return false;
    }

    public boolean excludes(ProtoType type) {
        return this.exclude(type.toString());
    }

    public boolean excludes(ProtoMember protoMember) {
        return this.exclude(protoMember.toString());
    }

    private boolean exclude(String identifier) {
        String excludeMatch = null;
        String rule = identifier;
        while (rule != null) {
            if (this.excludes.contains(rule)) {
                excludeMatch = rule;
            }
            rule = IdentifierSet.enclosing(rule);
        }
        if (excludeMatch != null) {
            this.usedExcludes.add(excludeMatch);
            return true;
        }
        return false;
    }

    static String enclosing(String identifier) {
        int hash = identifier.lastIndexOf(35);
        if (hash != -1) {
            return identifier.substring(0, hash);
        }
        int from = identifier.endsWith(".*") ? identifier.length() - 3 : identifier.length() - 1;
        int dot = identifier.lastIndexOf(46, from);
        if (dot != -1) {
            return identifier.substring(0, dot) + ".*";
        }
        return !identifier.equals("*") ? "*" : null;
    }

    public Set<String> unusedIncludes() {
        return Sets.difference(this.includes, this.usedIncludes);
    }

    public Set<String> unusedExcludes() {
        return Sets.difference(this.excludes, this.usedExcludes);
    }

    public Set<String> includes() {
        return this.includes;
    }

    public Set<String> excludes() {
        return this.excludes;
    }

    public static final class Builder {
        final ImmutableSet.Builder<String> includes = ImmutableSet.builder();
        final ImmutableSet.Builder<String> excludes = ImmutableSet.builder();

        public Builder include(String identifier) {
            if (identifier == null) {
                throw new NullPointerException("identifier == null");
            }
            this.includes.add((Object)identifier);
            return this;
        }

        public Builder include(Iterable<String> identifiers) {
            if (identifiers == null) {
                throw new NullPointerException("identifiers == null");
            }
            this.includes.addAll((Iterable)identifiers);
            return this;
        }

        public Builder exclude(String identifier) {
            if (identifier == null) {
                throw new NullPointerException("identifier == null");
            }
            this.excludes.add((Object)identifier);
            return this;
        }

        public Builder exclude(Iterable<String> identifiers) {
            if (identifiers == null) {
                throw new NullPointerException("identifiers == null");
            }
            this.excludes.addAll((Iterable)identifiers);
            return this;
        }

        public IdentifierSet build() {
            return new IdentifierSet(this);
        }
    }
}

