/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.internal;

import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.internal.ImmutableList;
import com.squareup.wire.internal.MutableOnWriteList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Internal {
    private Internal() {
    }

    public static <T> List<T> newMutableList() {
        return new MutableOnWriteList(Collections.emptyList());
    }

    public static <K, V> Map<K, V> newMutableMap() {
        return new LinkedHashMap();
    }

    public static <T> List<T> copyOf(String name, List<T> list) {
        if (list == null) {
            throw new NullPointerException(name + " == null");
        }
        if (list == Collections.emptyList() || list instanceof ImmutableList) {
            return new MutableOnWriteList<T>(list);
        }
        return new ArrayList<T>(list);
    }

    public static <K, V> Map<K, V> copyOf(String name, Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException(name + " == null");
        }
        return new LinkedHashMap<K, V>(map);
    }

    public static <T> List<T> immutableCopyOf(String name, List<T> list) {
        if (list == null) {
            throw new NullPointerException(name + " == null");
        }
        if (list instanceof MutableOnWriteList) {
            list = ((MutableOnWriteList)list).mutableList;
        }
        if (list == Collections.emptyList() || list instanceof ImmutableList) {
            return list;
        }
        ImmutableList<T> result = new ImmutableList<T>(list);
        if (result.contains(null)) {
            throw new IllegalArgumentException(name + ".contains(null)");
        }
        return result;
    }

    public static <K, V> Map<K, V> immutableCopyOf(String name, Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException(name + " == null");
        }
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>(map);
        if (result.containsKey(null)) {
            throw new IllegalArgumentException(name + ".containsKey(null)");
        }
        if (result.containsValue(null)) {
            throw new IllegalArgumentException(name + ".containsValue(null)");
        }
        return Collections.unmodifiableMap(result);
    }

    public static <T> void redactElements(List<T> list, ProtoAdapter<T> adapter) {
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            list.set(i, adapter.redact(list.get(i)));
        }
    }

    public static <T> void redactElements(Map<?, T> map, ProtoAdapter<T> adapter) {
        for (Map.Entry<?, T> entry : map.entrySet()) {
            entry.setValue(adapter.redact(entry.getValue()));
        }
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static IllegalStateException missingRequiredFields(Object ... args2) {
        StringBuilder sb = new StringBuilder();
        String plural = "";
        int size = args2.length;
        for (int i = 0; i < size; i += 2) {
            if (args2[i] != null) continue;
            if (sb.length() > 0) {
                plural = "s";
            }
            sb.append("\n  ");
            sb.append(args2[i + 1]);
        }
        throw new IllegalStateException("Required field" + plural + " not set:" + sb);
    }

    public static void checkElementsNotNull(List<?> list) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object element = list.get(i);
            if (element != null) continue;
            throw new NullPointerException("Element at index " + i + " is null");
        }
    }

    public static void checkElementsNotNull(Map<?, ?> map) {
        if (map == null) {
            throw new NullPointerException("map == null");
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("map.containsKey(null)");
            }
            if (entry.getValue() != null) continue;
            throw new NullPointerException("Value for key " + entry.getKey() + " is null");
        }
    }

    public static int countNonNull(Object a, Object b) {
        return (a != null ? 1 : 0) + (b != null ? 1 : 0);
    }

    public static int countNonNull(Object a, Object b, Object c) {
        return (a != null ? 1 : 0) + (b != null ? 1 : 0) + (c != null ? 1 : 0);
    }

    public static int countNonNull(Object a, Object b, Object c, Object d, Object ... rest) {
        int result = 0;
        if (a != null) {
            ++result;
        }
        if (b != null) {
            ++result;
        }
        if (c != null) {
            ++result;
        }
        if (d != null) {
            ++result;
        }
        for (Object o : rest) {
            if (o == null) continue;
            ++result;
        }
        return result;
    }
}

