/*
 * Decompiled with CFR 0.152.
 */
package de.slub.urn;

import de.slub.urn.NamespaceIdentifier;
import de.slub.urn.NamespaceSpecificString;
import de.slub.urn.RFC;
import de.slub.urn.RFC2141Parser;
import de.slub.urn.RFC8141Parser;
import de.slub.urn.RFCSupport;
import de.slub.urn.URNParser;
import de.slub.urn.URN_2141;
import de.slub.urn.URN_8141;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public abstract class URN
implements RFCSupport {
    public static final String SCHEME = "urn";

    public static URNParser<URN_2141> rfc2141() {
        return new RFC2141Parser();
    }

    public static URNParser<URN_8141> rfc8141() {
        return new RFC8141Parser();
    }

    public abstract NamespaceIdentifier namespaceIdentifier();

    public abstract NamespaceSpecificString namespaceSpecificString();

    public URI toURI() throws URISyntaxException {
        return new URI(this.toString());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.namespaceIdentifier(), this.namespaceSpecificString(), this.supportedRFC()});
    }

    public boolean equals(Object obj) {
        return obj instanceof URN && this.namespaceIdentifier().equals(((URN)obj).namespaceIdentifier()) && this.namespaceSpecificString().equals(((URN)obj).namespaceSpecificString()) && this.supportedRFC().equals((Object)((URN)obj).supportedRFC());
    }

    @Override
    public boolean supports(RFC rfc) {
        return this.supportedRFC().equals((Object)rfc);
    }
}

