/*
 * Decompiled with CFR 0.152.
 */
package de.slub.urn;

import de.slub.urn.RFC;

public class URNSyntaxError
extends Exception {
    private ErrorTypes error;
    private RFC violatedRfc;

    public URNSyntaxError(String msg, ErrorTypes error, RFC violatedRfc) {
        super(msg);
        this.error = error;
        this.violatedRfc = violatedRfc;
    }

    public URNSyntaxError(String msg) {
        super(msg);
    }

    public URNSyntaxError(String msg, Throwable t2) {
        super(msg, t2);
    }

    public static URNSyntaxError reservedIdentifier(RFC rfc, String nid) {
        return new URNSyntaxError(String.format("Namespace identifier can not be '%s'", nid), ErrorTypes.RESERVED, rfc);
    }

    public static URNSyntaxError syntaxError(RFC rfc, String msg) {
        return new URNSyntaxError(msg, ErrorTypes.SYNTAX_ERROR, rfc);
    }

    public static URNSyntaxError lengthError(RFC rfc, String nid) {
        return new URNSyntaxError(String.format("Namespace Identifier '%s' is too long. Only 32 characters are allowed.", nid), ErrorTypes.LENGTH_ERROR, rfc);
    }

    public ErrorTypes getError() {
        return this.error;
    }

    public RFC getViolatedRfc() {
        return this.violatedRfc;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s [Error %3d]\n\nThis is probably a violation of %s", this.getMessage(), this.error.getCode(), this.violatedRfc.name()));
        if (!this.error.getViolatedRfcSection().isEmpty()) {
            sb.append(", section ").append(this.error.getViolatedRfcSection());
        }
        sb.append("\nSee ").append(this.violatedRfc.url());
        return sb.toString();
    }

    public static enum ErrorTypes {
        RESERVED(10, "2.1"),
        SYNTAX_ERROR(15, ""),
        LENGTH_ERROR(20, "2");

        private final int code;
        private final String violatedRfcSection;

        private ErrorTypes(int code, String violatedRfcSection) {
            this.code = code;
            this.violatedRfcSection = violatedRfcSection;
        }

        public int getCode() {
            return this.code;
        }

        public String getViolatedRfcSection() {
            return this.violatedRfcSection;
        }
    }
}

