/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.generateproto;

import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.SchemaException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import no.entur.schema2proto.InvalidConfigurationException;
import no.entur.schema2proto.generateproto.ConversionException;
import no.entur.schema2proto.generateproto.FieldPath;
import no.entur.schema2proto.generateproto.InvalidXSDException;
import no.entur.schema2proto.generateproto.LocalType;
import no.entur.schema2proto.generateproto.ProtoSerializer;
import no.entur.schema2proto.generateproto.Schema2ProtoConfigFile;
import no.entur.schema2proto.generateproto.Schema2ProtoConfiguration;
import no.entur.schema2proto.generateproto.SchemaParser;
import no.entur.schema2proto.generateproto.TypeAndNameMapper;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class Schema2Proto {
    private static final String OPTION_OUTPUT_DIRECTORY = "outputDirectory";
    private static final String OPTION_OUTPUT_FILENAME = "outputFilename";
    private static final String OPTION_PACKAGE = "defaultProtoPackage";
    private static final String OPTION_FORCE_PACKAGE = "forceProtoPackage";
    private static final String OPTION_INCLUDE_FIELD_DOCS = "includeFieldDocs";
    private static final String OPTION_INCLUDE_MESSAGE_DOCS = "includeMessageDocs";
    private static final String OPTION_INCLUDE_SOURCE_LOCATION_IN_DOC = "includeSourceLocationInDoc";
    private static final String OPTION_INHERITANCE_TO_COMPOSITION = "inheritanceToComposition";
    private static final String OPTION_OPTIONS = "options";
    private static final String OPTION_CUSTOM_IMPORTS = "customImports";
    private static final String OPTION_CUSTOM_IMPORT_LOCATIONS = "customImportLocations";
    private static final String OPTION_CUSTOM_NAME_MAPPINGS = "customNameMappings";
    private static final String OPTION_CUSTOM_TYPE_MAPPINGS = "customTypeMappings";
    private static final String OPTION_CUSTOM_TYPE_REPLACINGS = "customTypeReplacements";
    private static final String OPTION_IGNORE_OUTPUT_FIELDS = "ignoreOutputFields";
    private static final String OPTION_CONFIG_FILE = "configFile";
    private static final String OPTION_INCLUDE_VALIDATION_RULES = "includeValidationRules";
    private static final String OPTION_INCLUDE_SKIP_EMPTY_TYPE_INHERITANCE = "skipEmptyTypeInheritance";
    private static final String OPTION_INCLUDE_XSD_OPTIONS = "includeXsdOptions";
    private static final String OPTION_PROTOLOCK_FILENAME = "protoLockFile";
    private static final String OPTION_FAIL_IF_REMOVED_FIELDS = "failIfRemovedFields";
    private static final String OPTION_DERIVATION_BY_SUBSUMPTION = "derivationBySubsumption";
    private static final String OPTION_INCLUDE_GO_PACKAGE_OPTIONS = "includeGoPackageOptions";
    private static final String OPTION_GO_PACKAGE_SOURCE_PREFIX = "goPackageSourcePrefix";
    private static final Logger LOGGER = LoggerFactory.getLogger(Schema2Proto.class);
    public static final String TRUE_FALSE = "true|false";

    public Schema2Proto(String[] args2) throws IOException {
        Options commandLineOptions = Schema2Proto.createCommandLineOptions();
        if (args2.length < 2) {
            Schema2Proto.printUsage(commandLineOptions);
        } else {
            try {
                DefaultParser parser = new DefaultParser();
                CommandLine cmd = parser.parse(commandLineOptions, args2);
                Schema2ProtoConfiguration configuration = Schema2Proto.getConfiguration(cmd);
                Schema2Proto.parseAndSerialize(configuration);
            }
            catch (InvalidConfigurationException | ParseException e) {
                Schema2Proto.printUsage(commandLineOptions);
                throw new ConversionException("Error parsing command line options", e);
            }
            catch (SchemaException e) {
                throw new ConversionException("Generated proto files did not link", e);
            }
        }
    }

    public static void parseAndSerialize(Schema2ProtoConfiguration configuration) throws IOException, InvalidConfigurationException {
        try {
            SchemaParser xp = new SchemaParser(configuration);
            LOGGER.info("Starting to parse {}", (Object)configuration.xsdFile);
            Map<String, ProtoFile> packageToFiles = xp.parse();
            List<LocalType> localTypes = xp.getLocalTypes();
            TypeAndNameMapper pbm = new TypeAndNameMapper(configuration);
            ProtoSerializer serializer = new ProtoSerializer(configuration, pbm);
            serializer.serialize(packageToFiles, localTypes);
            LOGGER.info("Done");
        }
        catch (InvalidXSDException e) {
            throw new ConversionException("Error converting xsdFile to proto", e);
        }
        catch (SAXException e) {
            throw new ConversionException("Error parsing provided xsd. Correct xsd and retry", e);
        }
    }

    public static void main(String[] args2) {
        try {
            new Schema2Proto(args2);
        }
        catch (Exception e) {
            LOGGER.error("Error processing proto files: {}", (Object)e.getMessage(), (Object)e);
            System.exit(1);
        }
    }

    private static Options createCommandLineOptions() {
        Options commandLineOptions = new Options();
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_CONFIG_FILE).desc("name of configfile specifying these parameters (instead of supplying them on the command line)").required(false).hasArg().argName(OPTION_OUTPUT_FILENAME).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_PACKAGE).hasArg().argName("NAME").desc("default proto package of the output file if no xsd target defaultProtoPackage is specified").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_FORCE_PACKAGE).hasArg().argName("NAME").desc("force all types in this package").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_OUTPUT_FILENAME).hasArg().argName("FILENAME").desc("name of output file").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_OUTPUT_DIRECTORY).hasArg().argName("DIRECTORYNAME").desc("path to output folder").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_CUSTOM_TYPE_MAPPINGS).hasArg().argName("a:b,x:y").desc("represent schema types as specific output types").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_CUSTOM_NAME_MAPPINGS).hasArg().argName("cake:kake,...").desc("translate message and field names").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_OPTIONS).hasArg().argName("option1name:option1value,...").desc("add custom options to each protofile, ie java_multiple_files:true").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_CUSTOM_IMPORTS).hasArg().argName("filename1,filename2,...").desc("add additional imports").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_CUSTOM_IMPORT_LOCATIONS).hasArg().argName("folder1,folder2,...").desc("root folder for additional imports").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_IGNORE_OUTPUT_FIELDS).hasArg().argName("packageName1/messageName1/fieldName1, packageName2/...").desc("output field names to ignore").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_INCLUDE_MESSAGE_DOCS).hasArg().argName(TRUE_FALSE).desc("include documentation of messages in output, defaults to true").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_INCLUDE_FIELD_DOCS).hasArg().argName(TRUE_FALSE).desc("include documentation for fields in output, defaults to true").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_INCLUDE_SOURCE_LOCATION_IN_DOC).hasArg().argName(TRUE_FALSE).desc("include xsd source location relative to source xsd file in docs, defaults to false").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_INHERITANCE_TO_COMPOSITION).hasArg().argName(TRUE_FALSE).desc("define each xsd extension base level as a message field instead of copying all inherited fields").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_INCLUDE_VALIDATION_RULES).hasArg().argName(TRUE_FALSE).desc("generate bufbuild/protoc-gen-validate validation rules from xsd rules").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_INCLUDE_SKIP_EMPTY_TYPE_INHERITANCE).hasArg().argName(TRUE_FALSE).desc("skip types just redefining other types with a different name").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_INCLUDE_XSD_OPTIONS).hasArg().argName(TRUE_FALSE).desc("include message options describing the xsd type hierarchy").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_FAIL_IF_REMOVED_FIELDS).hasArg().argName(TRUE_FALSE).desc("when using backwards compatibility check via proto.lock file, fail if proto fields are removed").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_PROTOLOCK_FILENAME).hasArg().argName("FILENAME").desc("Full path to proto.lock file").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_DERIVATION_BY_SUBSUMPTION).hasArg().argName(TRUE_FALSE).desc("enable derivation by subsumption https://cs.au.dk/~amoeller/XML/schemas/xmlschema-inheritance.html").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_INCLUDE_GO_PACKAGE_OPTIONS).hasArg().argName(TRUE_FALSE).desc("Include 'go_package' options in all files").required(false).build());
        commandLineOptions.addOption(Option.builder().longOpt(OPTION_GO_PACKAGE_SOURCE_PREFIX).hasArg().argName("google.golang.org/protobuf/types/known/").desc("Source path to set as prefix for go_package options").required(false).build());
        return commandLineOptions;
    }

    private static void printUsage(Options commandLineOptions) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(140);
        formatter.setSyntaxPrefix("java ");
        formatter.printHelp("Schema2Proto [OPTIONS] XSDFILE", "Generate proto files from xsd file. Either --configFile or --outputDirectory must be specified.", commandLineOptions, null);
    }

    private static Schema2ProtoConfiguration getConfiguration(CommandLine cmd) throws InvalidConfigurationException {
        if (cmd.hasOption(OPTION_CONFIG_FILE)) {
            return Schema2Proto.parseConfigFile(cmd);
        }
        return Schema2Proto.parseCommandLineOptions(cmd);
    }

    private static Schema2ProtoConfiguration parseConfigFile(CommandLine cmd) throws InvalidConfigurationException {
        Schema2ProtoConfiguration schema2ProtoConfiguration;
        block11: {
            Schema2ProtoConfiguration configuration = new Schema2ProtoConfiguration();
            String[] args2 = cmd.getArgs();
            if (args2.length != 1) {
                throw new InvalidConfigurationException("Missing xsd file argument");
            }
            File xsdFile = new File(args2[0]);
            if (!xsdFile.exists()) {
                throw new InvalidConfigurationException(String.format("XSD file %s not found", xsdFile.getAbsolutePath()));
            }
            configuration.xsdFile = new File(args2[0]);
            String configFileOption = cmd.getOptionValue(OPTION_CONFIG_FILE);
            InputStream in = Files.newInputStream(Paths.get(configFileOption, new String[0]), new OpenOption[0]);
            try {
                LOGGER.info("Using configFile {}", (Object)configFileOption);
                Schema2Proto.parseConfigurationFileIntoConfiguration(configuration, in);
                schema2ProtoConfiguration = configuration;
                if (in == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvalidConfigurationException("Error reading config file", e);
                }
                catch (YAMLException e) {
                    throw new InvalidConfigurationException("Error parsing config file", e);
                }
            }
            in.close();
        }
        return schema2ProtoConfiguration;
    }

    public static void parseConfigurationFileIntoConfiguration(Schema2ProtoConfiguration configuration, InputStream in) throws InvalidConfigurationException {
        Yaml yaml = new Yaml();
        Schema2ProtoConfigFile configFile = yaml.loadAs(in, Schema2ProtoConfigFile.class);
        if (configFile.outputDirectory == null) {
            throw new InvalidConfigurationException(OPTION_OUTPUT_DIRECTORY);
        }
        configuration.outputDirectory = new File(configFile.outputDirectory);
        configuration.outputFilename = configFile.outputFilename;
        TreeMap<Pattern, String> customTypeMappings = new TreeMap<Pattern, String>(Comparator.comparing(Pattern::pattern));
        if (configFile.customTypeMappings != null) {
            customTypeMappings.putAll(Schema2Proto.parseRegexpKeyValue(configFile.customTypeMappings));
        }
        TreeMap<Pattern, String> customTypeReplacements = new TreeMap<Pattern, String>(Comparator.comparing(Pattern::pattern));
        if (configFile.customTypeReplacements != null) {
            customTypeReplacements.putAll(Schema2Proto.parseRegexpKeyValue(configFile.customTypeReplacements));
        }
        TreeMap<Pattern, String> customNameMappings = new TreeMap<Pattern, String>(Comparator.comparing(Pattern::pattern));
        if (configFile.customNameMappings != null) {
            customNameMappings.putAll(Schema2Proto.parseRegexpKeyValue(configFile.customNameMappings));
        }
        configuration.customTypeMappings.putAll(customTypeMappings);
        configuration.customTypeReplacements.putAll(customTypeReplacements);
        configuration.customNameMappings.putAll(customNameMappings);
        configuration.defaultProtoPackage = configFile.defaultProtoPackage;
        configuration.forceProtoPackage = configFile.forceProtoPackage;
        configuration.includeMessageDocs = configFile.includeMessageDocs;
        configuration.includeFieldDocs = configFile.includeFieldDocs;
        configuration.includeSourceLocationInDoc = configFile.includeSourceLocationInDoc;
        configuration.inheritanceToComposition = configFile.inheritanceToComposition;
        configuration.includeValidationRules = configFile.includeValidationRules;
        configuration.skipEmptyTypeInheritance = configFile.skipEmptyTypeInheritance;
        configuration.includeXsdOptions = configFile.includeXsdOptions;
        configuration.derivationBySubsumption = configFile.derivationBySubsumption;
        configuration.includeGoPackageOptions = configFile.includeGoPackageOptions;
        configuration.goPackageSourcePrefix = configFile.goPackageSourcePrefix;
        Map<String, Object> options = configFile.options;
        if (configFile.options != null) {
            configuration.options.putAll(options);
        }
        if (configFile.customImports != null) {
            configuration.customImports.addAll(configFile.customImports);
        }
        if (configFile.customImportLocations != null) {
            configuration.customImportLocations.addAll(configFile.customImportLocations);
        }
        if (configFile.ignoreOutputFields != null) {
            for (String ignoreOutputField : configFile.ignoreOutputFields) {
                String[] split = StringUtils.split(ignoreOutputField, "/");
                configuration.ignoreOutputFields.add(new FieldPath(split[0], split[1], split[2]));
            }
        }
        if (configFile.protoLockFile != null) {
            configuration.protoLockFile = new File(configFile.protoLockFile);
        }
        configuration.failIfRemovedFields = configFile.failIfRemovedFields;
    }

    private static Map<Pattern, String> parseRegexpKeyValue(Map<String, String> customTypeMappings) {
        HashMap<Pattern, String> result = new HashMap<Pattern, String>();
        for (Map.Entry<String, String> kv : customTypeMappings.entrySet()) {
            Pattern p = Pattern.compile(kv.getKey());
            result.put(p, kv.getValue());
        }
        return result;
    }

    private static Schema2ProtoConfiguration parseCommandLineOptions(CommandLine cmd) throws InvalidConfigurationException {
        Schema2ProtoConfiguration configuration = new Schema2ProtoConfiguration();
        String[] args2 = cmd.getArgs();
        if (args2.length != 1) {
            throw new InvalidConfigurationException("Missing xsd file argument");
        }
        configuration.xsdFile = new File(args2[0]);
        if (!cmd.hasOption(OPTION_OUTPUT_DIRECTORY)) {
            throw new InvalidConfigurationException(OPTION_OUTPUT_DIRECTORY);
        }
        configuration.outputDirectory = new File(cmd.getOptionValue(OPTION_OUTPUT_DIRECTORY));
        configuration.outputFilename = cmd.getOptionValue(OPTION_OUTPUT_FILENAME);
        if (cmd.hasOption(OPTION_PACKAGE)) {
            configuration.defaultProtoPackage = cmd.getOptionValue(OPTION_PACKAGE);
        }
        if (cmd.hasOption(OPTION_FORCE_PACKAGE)) {
            configuration.forceProtoPackage = cmd.getOptionValue(OPTION_FORCE_PACKAGE);
        }
        configuration.customTypeMappings = Schema2Proto.parseRegexMap(cmd, OPTION_CUSTOM_TYPE_MAPPINGS);
        configuration.customTypeReplacements = Schema2Proto.parseRegexMap(cmd, OPTION_CUSTOM_TYPE_REPLACINGS);
        configuration.customNameMappings = Schema2Proto.parseRegexMap(cmd, OPTION_CUSTOM_NAME_MAPPINGS);
        TreeMap<String, Object> options = new TreeMap<String, Object>();
        if (cmd.hasOption(OPTION_OPTIONS)) {
            for (String mapping : cmd.getOptionValue(OPTION_OPTIONS).split(",")) {
                int colon = mapping.indexOf(58);
                if (colon > -1) {
                    String optionName = mapping.substring(0, colon);
                    String parameter = mapping.substring(colon + 1);
                    if (parameter.equals("true")) {
                        options.put(optionName, true);
                        continue;
                    }
                    if (parameter.equals("false")) {
                        options.put(optionName, false);
                        continue;
                    }
                    options.put(optionName, parameter);
                    continue;
                }
                LOGGER.error("{} is not a option, use optionName:optionValue", (Object)mapping);
            }
        }
        configuration.options = options;
        configuration.customImports = Schema2Proto.parseCommaSeparatedStringValues(cmd, OPTION_CUSTOM_IMPORTS);
        configuration.customImportLocations = Schema2Proto.parseCommaSeparatedStringValues(cmd, OPTION_CUSTOM_IMPORT_LOCATIONS);
        if (cmd.hasOption(OPTION_IGNORE_OUTPUT_FIELDS)) {
            for (String ignoreOutputField : cmd.getOptionValue(OPTION_IGNORE_OUTPUT_FIELDS).split(",")) {
                String[] split = StringUtils.split(ignoreOutputField, "/");
                configuration.ignoreOutputFields.add(new FieldPath(split[0], split[1], split[2]));
            }
        }
        if (cmd.hasOption(OPTION_INCLUDE_MESSAGE_DOCS)) {
            configuration.includeMessageDocs = Boolean.parseBoolean(cmd.getOptionValue(OPTION_INCLUDE_MESSAGE_DOCS));
        }
        if (cmd.hasOption(OPTION_INCLUDE_FIELD_DOCS)) {
            configuration.includeFieldDocs = Boolean.parseBoolean(cmd.getOptionValue(OPTION_INCLUDE_FIELD_DOCS));
        }
        if (cmd.hasOption(OPTION_INCLUDE_SOURCE_LOCATION_IN_DOC)) {
            configuration.includeSourceLocationInDoc = Boolean.parseBoolean(cmd.getOptionValue(OPTION_INCLUDE_SOURCE_LOCATION_IN_DOC));
        }
        if (cmd.hasOption(OPTION_INHERITANCE_TO_COMPOSITION)) {
            configuration.inheritanceToComposition = Boolean.parseBoolean(cmd.getOptionValue(OPTION_INHERITANCE_TO_COMPOSITION));
        }
        if (cmd.hasOption(OPTION_INCLUDE_VALIDATION_RULES)) {
            configuration.includeValidationRules = Boolean.parseBoolean(cmd.getOptionValue(OPTION_INCLUDE_VALIDATION_RULES));
        }
        if (cmd.hasOption(OPTION_INCLUDE_SKIP_EMPTY_TYPE_INHERITANCE)) {
            configuration.skipEmptyTypeInheritance = Boolean.parseBoolean(cmd.getOptionValue(OPTION_INCLUDE_SKIP_EMPTY_TYPE_INHERITANCE));
        }
        if (cmd.hasOption(OPTION_INCLUDE_XSD_OPTIONS)) {
            configuration.includeXsdOptions = Boolean.parseBoolean(cmd.getOptionValue(OPTION_INCLUDE_XSD_OPTIONS));
        }
        if (cmd.hasOption(OPTION_PROTOLOCK_FILENAME)) {
            configuration.protoLockFile = new File(cmd.getOptionValue(OPTION_PROTOLOCK_FILENAME));
        }
        if (cmd.hasOption(OPTION_DERIVATION_BY_SUBSUMPTION)) {
            configuration.derivationBySubsumption = Boolean.parseBoolean(cmd.getOptionValue(OPTION_DERIVATION_BY_SUBSUMPTION));
        }
        if (cmd.hasOption(OPTION_INCLUDE_GO_PACKAGE_OPTIONS)) {
            configuration.includeGoPackageOptions = Boolean.parseBoolean(cmd.getOptionValue(OPTION_INCLUDE_GO_PACKAGE_OPTIONS));
        }
        if (cmd.hasOption(OPTION_GO_PACKAGE_SOURCE_PREFIX)) {
            configuration.goPackageSourcePrefix = cmd.getOptionValue(OPTION_GO_PACKAGE_SOURCE_PREFIX);
        }
        return configuration;
    }

    private static List<String> parseCommaSeparatedStringValues(CommandLine cmd, String optionName) {
        ArrayList<String> imports = new ArrayList<String>();
        if (cmd.hasOption(optionName)) {
            imports.addAll(Arrays.asList(cmd.getOptionValue(optionName).split(",")));
        }
        return imports;
    }

    private static SortedMap<Pattern, String> parseRegexMap(CommandLine cmd, String optionName) {
        TreeMap<Pattern, String> customTypeMappings = new TreeMap<Pattern, String>();
        if (cmd.hasOption(optionName)) {
            for (String mapping : cmd.getOptionValue(optionName).split(",")) {
                int colon = mapping.indexOf(58);
                if (colon > -1) {
                    customTypeMappings.put(Pattern.compile(mapping.substring(0, colon)), mapping.substring(colon + 1));
                    continue;
                }
                LOGGER.error("{} is not a valid mapping - use schematype:outputtype/fieldname", (Object)mapping);
            }
        }
        return customTypeMappings;
    }
}

