/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.generateproto;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import no.entur.schema2proto.generateproto.FieldPath;
import no.entur.schema2proto.generateproto.Schema2ProtoConfiguration;

public class TypeAndNameMapper {
    private Map<Pattern, String> typeMappings = new LinkedHashMap<Pattern, String>();
    private Map<Pattern, String> typeReplacing = new LinkedHashMap<Pattern, String>();
    private Map<Pattern, String> nameMappings = new LinkedHashMap<Pattern, String>();
    private Set<String> reservedJavaKeywords = new HashSet<String>();
    private List<FieldPath> ignoreFieldPaths;

    public TypeAndNameMapper(Schema2ProtoConfiguration configuration) {
        this.typeReplacing.putAll(this.getStandardXsdTypeMappings());
        this.updateMappings(this.typeReplacing, configuration.customTypeReplacements);
        this.updateMappings(this.typeMappings, configuration.customTypeMappings);
        this.updateMappings(this.nameMappings, configuration.customNameMappings);
        this.reservedJavaKeywords.addAll(this.getReservedWords());
        this.ignoreFieldPaths = configuration.ignoreOutputFields;
    }

    private void updateMappings(Map<Pattern, String> existing, Map<Pattern, String> updated) {
        for (Pattern updatedKey : updated.keySet()) {
            HashSet<Pattern> keys2 = new HashSet<Pattern>(existing.keySet());
            for (Pattern key : keys2) {
                if (!key.pattern().equals(updatedKey.pattern())) continue;
                existing.remove(key);
            }
            existing.put(updatedKey, updated.get(updatedKey));
        }
    }

    private Map<Pattern, String> getStandardXsdTypeMappings() {
        HashMap<Pattern, String> standardTypeMappings = new HashMap<Pattern, String>();
        standardTypeMappings.put(Pattern.compile("^string$"), "string");
        standardTypeMappings.put(Pattern.compile("^boolean$"), "bool");
        standardTypeMappings.put(Pattern.compile("^float$"), "float");
        standardTypeMappings.put(Pattern.compile("^double$"), "double");
        standardTypeMappings.put(Pattern.compile("^decimal$"), "double");
        standardTypeMappings.put(Pattern.compile("^duration$"), "string");
        standardTypeMappings.put(Pattern.compile("^dateTime$"), "uint64");
        standardTypeMappings.put(Pattern.compile("^time$"), "uint64");
        standardTypeMappings.put(Pattern.compile("^date$"), "uint32");
        standardTypeMappings.put(Pattern.compile("^gYearMonth$"), "string");
        standardTypeMappings.put(Pattern.compile("^gYear$"), "uint32");
        standardTypeMappings.put(Pattern.compile("^gMonthDay$"), "string");
        standardTypeMappings.put(Pattern.compile("^gDay$"), "uint32");
        standardTypeMappings.put(Pattern.compile("^gMonth$"), "uint32");
        standardTypeMappings.put(Pattern.compile("^hexBinary$"), "bytes");
        standardTypeMappings.put(Pattern.compile("^base64Binary$"), "bytes");
        standardTypeMappings.put(Pattern.compile("^anyURI$"), "string");
        standardTypeMappings.put(Pattern.compile("^QName$"), "string");
        standardTypeMappings.put(Pattern.compile("^NOTATION$"), "string");
        standardTypeMappings.put(Pattern.compile("^normalizedString$"), "string");
        standardTypeMappings.put(Pattern.compile("^token$"), "string");
        standardTypeMappings.put(Pattern.compile("^language$"), "string");
        standardTypeMappings.put(Pattern.compile("^IDREFS$"), "string");
        standardTypeMappings.put(Pattern.compile("^ENTITIES$"), "string");
        standardTypeMappings.put(Pattern.compile("^NMTOKEN$"), "string");
        standardTypeMappings.put(Pattern.compile("^NMTOKENS$"), "string");
        standardTypeMappings.put(Pattern.compile("^Name$"), "string");
        standardTypeMappings.put(Pattern.compile("^NCName$"), "string");
        standardTypeMappings.put(Pattern.compile("^ID$"), "string");
        standardTypeMappings.put(Pattern.compile("^IDREF$"), "string");
        standardTypeMappings.put(Pattern.compile("^ENTITY$"), "string");
        standardTypeMappings.put(Pattern.compile("^integer$"), "int32");
        standardTypeMappings.put(Pattern.compile("^nonPositiveInteger$"), "sint32");
        standardTypeMappings.put(Pattern.compile("^negativeInteger$"), "sint32");
        standardTypeMappings.put(Pattern.compile("^long$"), "int64");
        standardTypeMappings.put(Pattern.compile("^int$"), "int32");
        standardTypeMappings.put(Pattern.compile("^short$"), "int32");
        standardTypeMappings.put(Pattern.compile("^byte$"), "bytes");
        standardTypeMappings.put(Pattern.compile("^nonNegativeInteger$"), "uint32");
        standardTypeMappings.put(Pattern.compile("^unsignedLong$"), "uint64");
        standardTypeMappings.put(Pattern.compile("^unsignedInt$"), "uint32");
        standardTypeMappings.put(Pattern.compile("^unsignedShort$"), "uint32");
        standardTypeMappings.put(Pattern.compile("^unsignedByte$"), "uint32");
        standardTypeMappings.put(Pattern.compile("^positiveInteger$"), "uint32");
        standardTypeMappings.put(Pattern.compile("^anySimpleType$"), "string");
        standardTypeMappings.put(Pattern.compile("^anyType$"), "string");
        return standardTypeMappings;
    }

    public String translateType(String type) {
        for (Map.Entry<Pattern, String> p : this.typeMappings.entrySet()) {
            Matcher m4 = p.getKey().matcher(type);
            if (!m4.matches()) continue;
            type = m4.replaceAll(p.getValue());
            break;
        }
        type = type.replace("-", "");
        return type;
    }

    public String translateFieldName(String name) {
        for (Pattern p : this.nameMappings.keySet()) {
            Matcher m4 = p.matcher(name);
            if (!m4.matches()) continue;
            return m4.replaceAll(this.nameMappings.get(p));
        }
        return name;
    }

    public String escapeFieldName(String fieldName) {
        if (this.reservedJavaKeywords.contains(fieldName)) {
            return fieldName + "_field";
        }
        return fieldName;
    }

    public boolean ignoreOutputField(String packageName, String messageName, String fieldName) {
        for (FieldPath f : this.ignoreFieldPaths) {
            if (!f.matches(packageName, messageName, fieldName)) continue;
            return true;
        }
        return false;
    }

    private Set<String> getReservedWords() {
        HashSet<String> reservedWords = new HashSet<String>();
        reservedWords.add("abstract");
        reservedWords.add("assert");
        reservedWords.add("boolean");
        reservedWords.add("break");
        reservedWords.add("byte");
        reservedWords.add("case");
        reservedWords.add("catch");
        reservedWords.add("char");
        reservedWords.add("class");
        reservedWords.add("const");
        reservedWords.add("default");
        reservedWords.add("do");
        reservedWords.add("double");
        reservedWords.add("else");
        reservedWords.add("enum");
        reservedWords.add("extends");
        reservedWords.add("false");
        reservedWords.add("final");
        reservedWords.add("finally");
        reservedWords.add("float");
        reservedWords.add("for");
        reservedWords.add("goto");
        reservedWords.add("if");
        reservedWords.add("implements");
        reservedWords.add("import");
        reservedWords.add("instanceof");
        reservedWords.add("int");
        reservedWords.add("interface");
        reservedWords.add("long");
        reservedWords.add("native");
        reservedWords.add("new");
        reservedWords.add("null");
        reservedWords.add("package");
        reservedWords.add("private");
        reservedWords.add("protected");
        reservedWords.add("public");
        reservedWords.add("return");
        reservedWords.add("short");
        reservedWords.add("static");
        reservedWords.add("strictfp");
        reservedWords.add("super");
        reservedWords.add("switch");
        reservedWords.add("synchronized");
        reservedWords.add("this");
        reservedWords.add("throw");
        reservedWords.add("throws");
        reservedWords.add("transient");
        reservedWords.add("true");
        reservedWords.add("try");
        reservedWords.add("void");
        reservedWords.add("volatile");
        reservedWords.add("while");
        reservedWords.add("continue");
        return reservedWords;
    }

    public String replaceType(String type) {
        for (Map.Entry<Pattern, String> p : this.typeReplacing.entrySet()) {
            Matcher m4 = p.getKey().matcher(type);
            if (!m4.matches()) continue;
            type = m4.replaceAll(p.getValue());
            break;
        }
        return type;
    }
}

