/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public final class ProtoFile {
    static final ProtoMember JAVA_PACKAGE = ProtoMember.get(Options.FILE_OPTIONS, "java_package");
    private Location location;
    private List<String> imports = new ArrayList<String>();
    private List<String> publicImports = new ArrayList<String>();
    private String packageName;
    private List<Type> types = new ArrayList<Type>();
    private List<Service> services = new ArrayList<Service>();
    private List<Extend> extendList = new ArrayList<Extend>();
    private Options options;
    private Syntax syntax;
    private Object javaPackage;

    public ProtoFile(Location location, List<String> imports, List<String> publicImports, String packageName, List<Type> types, List<Service> services, List<Extend> extendList, Options options, Syntax syntax) {
        this.location = location;
        this.imports.addAll(imports);
        this.publicImports.addAll(publicImports);
        this.packageName = packageName;
        this.types.addAll(types);
        this.services.addAll(services);
        this.extendList.addAll(extendList);
        this.options = options;
        this.syntax = syntax;
    }

    public ProtoFile(Syntax syntax, String packageName) {
        this.syntax = syntax;
        this.packageName = packageName;
        this.options = new Options(ProtoType.BOOL, new ArrayList<OptionElement>());
        this.location = new Location("path", "base", 1, 1);
    }

    public void mergeFrom(ProtoFile source2) {
        if (this.syntax != source2.syntax) {
            throw new IllegalArgumentException("Source and destination protos must follow the same syntax level (proto2/proto3)");
        }
        this.mergeImports(source2);
        this.mergePublicImports(source2);
        this.types.addAll(source2.types);
        this.services.addAll(source2.services);
    }

    private void mergeImports(ProtoFile source2) {
        TreeSet<String> mergedImports = new TreeSet<String>();
        mergedImports.addAll(this.imports);
        mergedImports.addAll(source2.imports);
        mergedImports.remove(this.location.getPath());
        this.imports.clear();
        this.imports.addAll(mergedImports);
    }

    private void mergePublicImports(ProtoFile source2) {
        TreeSet<String> mergedImports = new TreeSet<String>();
        mergedImports.addAll(this.publicImports);
        mergedImports.addAll(source2.publicImports);
        this.publicImports.clear();
        this.publicImports.addAll(mergedImports);
    }

    static ProtoFile get(ProtoFileElement protoFileElement) {
        String packageName = protoFileElement.getPackageName();
        ImmutableList<Type> types = Type.fromElements(packageName, protoFileElement.getTypes());
        ImmutableList<Service> services = Service.fromElements(packageName, protoFileElement.getServices());
        ImmutableList<Extend> wireExtends = Extend.fromElements(packageName, protoFileElement.getExtendDeclarations());
        Options options = new Options(Options.FILE_OPTIONS, protoFileElement.getOptions());
        return new ProtoFile(protoFileElement.getLocation(), protoFileElement.getImports(), protoFileElement.getPublicImports(), packageName, types, services, wireExtends, options, protoFileElement.getSyntax());
    }

    ProtoFileElement toElement() {
        return new ProtoFileElement(this.location, this.packageName, this.syntax, this.imports, this.publicImports, Type.toElements(this.types), Service.toElements(this.services), Extend.toElements(this.extendList), this.options.toElements());
    }

    public Location location() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public List<String> imports() {
        return this.imports;
    }

    public List<String> publicImports() {
        return this.publicImports;
    }

    public String name() {
        String result = this.location().getPath();
        int slashIndex = result.lastIndexOf(47);
        if (slashIndex != -1) {
            result = result.substring(slashIndex + 1);
        }
        if (result.endsWith(".proto")) {
            result = result.substring(0, result.length() - ".proto".length());
        }
        return result;
    }

    public String packageName() {
        return this.packageName;
    }

    public String javaPackage() {
        return this.javaPackage != null ? String.valueOf(this.javaPackage) : null;
    }

    public List<Type> types() {
        return this.types;
    }

    public List<Service> services() {
        return this.services;
    }

    List<Extend> extendList() {
        return this.extendList;
    }

    public Options options() {
        return this.options;
    }

    ProtoFile retainAll(Schema schema, MarkSet markSet) {
        ImmutableList.Builder retainedTypes = ImmutableList.builder();
        for (Type type : this.types) {
            Type retainedType = type.retainAll(schema, markSet);
            if (retainedType == null) continue;
            retainedTypes.add(retainedType);
        }
        ImmutableList.Builder retainedServices = ImmutableList.builder();
        for (Service service : this.services) {
            Service retainedService = service.retainAll(schema, markSet);
            if (retainedService == null) continue;
            retainedServices.add(retainedService);
        }
        ProtoFile protoFile = new ProtoFile(this.location, this.imports, this.publicImports, this.packageName, (List<Type>)((Object)retainedTypes.build()), (List<Service>)((Object)retainedServices.build()), this.extendList, this.options.retainAll(schema, markSet), this.syntax);
        protoFile.javaPackage = this.javaPackage;
        return protoFile;
    }

    void linkOptions(Linker linker) {
        this.options.link(linker);
        this.javaPackage = this.options().get(JAVA_PACKAGE);
    }

    public String toString() {
        return this.location().getPath();
    }

    public String toSchema() {
        return this.toElement().toSchema();
    }

    void validate(Linker linker) {
        linker.validateEnumConstantNameUniqueness(this.types);
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public List<Extend> getExtendList() {
        return this.extendList;
    }

    public static enum Syntax {
        PROTO_2("proto2"),
        PROTO_3("proto3");

        private final String string;

        private Syntax(String string2) {
            this.string = string2;
        }

        public static Syntax get(String string) {
            for (Syntax syntax : Syntax.values()) {
                if (!syntax.string.equals(string)) continue;
                return syntax;
            }
            throw new IllegalArgumentException("unexpected syntax: " + string);
        }

        public String toString() {
            return this.string;
        }
    }
}

