/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.rngdatatype.helpers;

import com.sun.tools.rngdatatype.Datatype;
import com.sun.tools.rngdatatype.DatatypeBuilder;
import com.sun.tools.rngdatatype.DatatypeException;
import com.sun.tools.rngdatatype.DatatypeLibrary;
import com.sun.tools.rngdatatype.DatatypeLibraryFactory;
import com.sun.tools.rngdatatype.DatatypeStreamingValidator;
import com.sun.tools.rngdatatype.ValidationContext;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public final class ProxyDatatypeLibraryFactory
implements DatatypeLibraryFactory {
    private static final String RELAXNG_FACTORY_NAME = "org.relaxng.datatype.DatatypeLibraryFactory";

    @Override
    public DatatypeLibrary createDatatypeLibrary(String uri) {
        Class<?> factoryClass;
        try {
            factoryClass = Class.forName(RELAXNG_FACTORY_NAME, false, ProxyDatatypeLibraryFactory.class.getClassLoader());
            Module main = ProxyDatatypeLibraryFactory.class.getModule();
            main.addUses(factoryClass);
        }
        catch (Throwable t2) {
            return null;
        }
        ServiceLoader<org.relaxng.datatype.DatatypeLibraryFactory> extLoader = ServiceLoader.load(factoryClass);
        for (org.relaxng.datatype.DatatypeLibraryFactory factory : extLoader) {
            final org.relaxng.datatype.DatatypeLibrary datatypeLibrary = factory.createDatatypeLibrary(uri);
            if (datatypeLibrary == null) continue;
            return new DatatypeLibrary(){

                @Override
                public DatatypeBuilder createDatatypeBuilder(String baseTypeLocalName) throws DatatypeException {
                    try {
                        final org.relaxng.datatype.DatatypeBuilder builder = datatypeLibrary.createDatatypeBuilder(baseTypeLocalName);
                        return new DatatypeBuilder(){

                            @Override
                            public void addParameter(String name, String strValue, ValidationContext context) throws DatatypeException {
                                try {
                                    builder.addParameter(name, strValue, (org.relaxng.datatype.ValidationContext)Proxy.newProxyInstance(ValidationContext.class.getClassLoader(), new Class[]{org.relaxng.datatype.ValidationContext.class}, (InvocationHandler)new GIH(org.relaxng.datatype.ValidationContext.class, context)));
                                }
                                catch (org.relaxng.datatype.DatatypeException de) {
                                    throw new DatatypeException(de.getIndex(), de.getMessage());
                                }
                            }

                            @Override
                            public Datatype createDatatype() throws DatatypeException {
                                try {
                                    org.relaxng.datatype.Datatype datatype = builder.createDatatype();
                                    return (Datatype)Proxy.newProxyInstance(Datatype.class.getClassLoader(), new Class[]{Datatype.class}, (InvocationHandler)new GIH(org.relaxng.datatype.Datatype.class, datatype));
                                }
                                catch (org.relaxng.datatype.DatatypeException de) {
                                    throw new DatatypeException(de.getIndex(), de.getMessage());
                                }
                            }
                        };
                    }
                    catch (org.relaxng.datatype.DatatypeException de) {
                        throw new DatatypeException(de.getIndex(), de.getMessage());
                    }
                }

                @Override
                public Datatype createDatatype(String typeLocalName) throws DatatypeException {
                    try {
                        org.relaxng.datatype.Datatype datatype = datatypeLibrary.createDatatype(typeLocalName);
                        return (Datatype)Proxy.newProxyInstance(Datatype.class.getClassLoader(), new Class[]{Datatype.class}, (InvocationHandler)new GIH(org.relaxng.datatype.Datatype.class, datatype));
                    }
                    catch (org.relaxng.datatype.DatatypeException de) {
                        throw new DatatypeException(de.getIndex(), de.getMessage());
                    }
                }
            };
        }
        return null;
    }

    private static class GIH
    implements InvocationHandler {
        private final Object obj;
        private final Map<String, Method> methods;

        GIH(Class<?> cls, Object obj) {
            this.obj = obj;
            this.methods = Arrays.stream(cls.getMethods()).collect(Collectors.toMap(k -> k.getParameterCount() + k.getName(), v -> v));
            for (Method m4 : Object.class.getMethods()) {
                this.methods.putIfAbsent(m4.getParameterCount() + m4.getName(), m4);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException();
            }
            if (args2 != null) {
                ArrayList<Object> params = new ArrayList<Object>();
                for (Object o : args2) {
                    if (o == null) {
                        params.add(o);
                        continue;
                    }
                    if (Proxy.isProxyClass(o.getClass())) {
                        params.add(o);
                        continue;
                    }
                    if (o instanceof ValidationContext) {
                        params.add(Proxy.newProxyInstance(ValidationContext.class.getClassLoader(), new Class[]{org.relaxng.datatype.ValidationContext.class}, (InvocationHandler)new GIH(org.relaxng.datatype.ValidationContext.class, o)));
                        continue;
                    }
                    if (o instanceof org.relaxng.datatype.ValidationContext) {
                        params.add(Proxy.newProxyInstance(ValidationContext.class.getClassLoader(), new Class[]{ValidationContext.class}, (InvocationHandler)new GIH(ValidationContext.class, o)));
                        continue;
                    }
                    params.add(o);
                }
                if ("createStreamingValidator".equals(method.getName()) && org.relaxng.datatype.ValidationContext.class.equals(method.getParameterTypes()[0])) {
                    Object result = this.methods.get(method.getParameterCount() + method.getName()).invoke(this.obj, params.toArray(new Object[0]));
                    return Proxy.newProxyInstance(DatatypeStreamingValidator.class.getClassLoader(), new Class[]{DatatypeStreamingValidator.class}, (InvocationHandler)new GIH(DatatypeStreamingValidator.class, result));
                }
                return this.methods.get(method.getParameterCount() + method.getName()).invoke(this.obj, params.toArray(new Object[0]));
            }
            return this.methods.get(method.getParameterCount() + method.getName()).invoke(this.obj, args2);
        }
    }
}

