/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.pgv;

import com.google.re2j.Pattern;
import io.envoyproxy.pgv.ValidationException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.InetAddressValidator;

public final class StringValidation {
    private StringValidation() {
    }

    public static void length(String field, String value, int expected) throws ValidationException {
        int actual = value.codePointCount(0, value.length());
        if (actual != expected) {
            throw new ValidationException(field, StringValidation.enquote(value), "length must be " + expected + " but got: " + actual);
        }
    }

    public static void minLength(String field, String value, int expected) throws ValidationException {
        int actual = value.codePointCount(0, value.length());
        if (actual < expected) {
            throw new ValidationException(field, StringValidation.enquote(value), "length must be at least " + expected + " but got: " + actual);
        }
    }

    public static void maxLength(String field, String value, int expected) throws ValidationException {
        int actual = value.codePointCount(0, value.length());
        if (actual > expected) {
            throw new ValidationException(field, StringValidation.enquote(value), "length must be at most " + expected + " but got: " + actual);
        }
    }

    public static void lenBytes(String field, String value, int expected) throws ValidationException {
        if (value.getBytes(StandardCharsets.UTF_8).length != expected) {
            throw new ValidationException(field, StringValidation.enquote(value), "bytes length must be " + expected);
        }
    }

    public static void minBytes(String field, String value, int expected) throws ValidationException {
        if (value.getBytes(StandardCharsets.UTF_8).length < expected) {
            throw new ValidationException(field, StringValidation.enquote(value), "bytes length must be at least " + expected);
        }
    }

    public static void maxBytes(String field, String value, int expected) throws ValidationException {
        if (value.getBytes(StandardCharsets.UTF_8).length > expected) {
            throw new ValidationException(field, StringValidation.enquote(value), "bytes length must be at most " + expected);
        }
    }

    public static void pattern(String field, String value, Pattern p) throws ValidationException {
        if (!p.matches(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "must match pattern " + p.pattern());
        }
    }

    public static void prefix(String field, String value, String prefix) throws ValidationException {
        if (!value.startsWith(prefix)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should start with " + prefix);
        }
    }

    public static void contains(String field, String value, String contains) throws ValidationException {
        if (!value.contains(contains)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should contain " + contains);
        }
    }

    public static void notContains(String field, String value, String contains) throws ValidationException {
        if (value.contains(contains)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should not contain " + contains);
        }
    }

    public static void suffix(String field, String value, String suffix) throws ValidationException {
        if (!value.endsWith(suffix)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should end with " + suffix);
        }
    }

    public static void email(String field, String value) throws ValidationException {
        if (!value.isEmpty() && value.charAt(value.length() - 1) == '>') {
            char[] chars = value.toCharArray();
            StringBuilder sb = new StringBuilder();
            boolean insideQuotes = false;
            for (int i = chars.length - 2; i >= 0; --i) {
                char c = chars[i];
                if (c == '<') {
                    if (!insideQuotes) {
                        break;
                    }
                } else if (c == '\"') {
                    insideQuotes = !insideQuotes;
                }
                sb.append(c);
            }
            value = sb.reverse().toString();
        }
        if (!Lazy.EMAIL_VALIDATOR.isValid(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid email");
        }
    }

    public static void address(String field, String value) throws ValidationException {
        boolean validHost = StringValidation.isAscii(value) && DomainValidator.getInstance(true).isValid(value);
        boolean validIp = InetAddressValidator.getInstance().isValid(value);
        if (!validHost && !validIp) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid host, or an ip address.");
        }
    }

    public static void hostName(String field, String value) throws ValidationException {
        if (!StringValidation.isAscii(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid host containing only ascii characters");
        }
        DomainValidator domainValidator = DomainValidator.getInstance(true);
        if (!domainValidator.isValid(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid host");
        }
    }

    public static void ip(String field, String value) throws ValidationException {
        InetAddressValidator ipValidator = InetAddressValidator.getInstance();
        if (!ipValidator.isValid(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid ip address");
        }
    }

    public static void ipv4(String field, String value) throws ValidationException {
        InetAddressValidator ipValidator = InetAddressValidator.getInstance();
        if (!ipValidator.isValidInet4Address(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid ipv4 address");
        }
    }

    public static void ipv6(String field, String value) throws ValidationException {
        InetAddressValidator ipValidator = InetAddressValidator.getInstance();
        if (!ipValidator.isValidInet6Address(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid ipv6 address");
        }
    }

    public static void uri(String field, String value) throws ValidationException {
        try {
            URI uri = new URI(value);
            if (!uri.isAbsolute()) {
                throw new ValidationException(field, StringValidation.enquote(value), "should be a valid absolute uri");
            }
        }
        catch (URISyntaxException ex) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid absolute uri");
        }
    }

    public static void uriRef(String field, String value) throws ValidationException {
        try {
            new URI(value);
        }
        catch (URISyntaxException ex) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid absolute uri");
        }
    }

    public static void uuid(String field, String value) throws ValidationException {
        if (value.length() == 36) {
            long lsb4;
            long lsb3;
            long lsb2;
            long lsb1;
            long msb4;
            long msb3;
            long msb2;
            byte[] nibbles;
            long msb1;
            char dash1 = value.charAt(8);
            char dash2 = value.charAt(13);
            char dash3 = value.charAt(18);
            char dash4 = value.charAt(23);
            if (dash1 == '-' && dash2 == '-' && dash3 == '-' && dash4 == '-' && ((msb1 = StringValidation.uuidParse4Nibbles(nibbles = UuidHolder.NIBBLES, value, 0)) | (msb2 = StringValidation.uuidParse4Nibbles(nibbles, value, 4)) | (msb3 = StringValidation.uuidParse4Nibbles(nibbles, value, 9)) | (msb4 = StringValidation.uuidParse4Nibbles(nibbles, value, 14)) | (lsb1 = StringValidation.uuidParse4Nibbles(nibbles, value, 19)) | (lsb2 = StringValidation.uuidParse4Nibbles(nibbles, value, 24)) | (lsb3 = StringValidation.uuidParse4Nibbles(nibbles, value, 28)) | (lsb4 = StringValidation.uuidParse4Nibbles(nibbles, value, 32))) >= 0L) {
                return;
            }
        }
        throw new ValidationException(field, StringValidation.enquote(value), "invalid UUID string");
    }

    private static long uuidParse4Nibbles(byte[] nibbles, String value, int i) {
        char c4;
        char c3;
        char c2;
        char c1 = value.charAt(i);
        return (c1 | (c2 = value.charAt(i + 1)) | (c3 = value.charAt(i + 2)) | (c4 = value.charAt(i + 3))) > 255 ? -1L : (long)(nibbles[c1] << 12 | nibbles[c2] << 8 | nibbles[c3] << 4 | nibbles[c4]);
    }

    private static String enquote(String value) {
        return "\"" + value + "\"";
    }

    private static boolean isAscii(String value) {
        for (char c : value.toCharArray()) {
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private static class Lazy {
        static final EmailValidator EMAIL_VALIDATOR = EmailValidator.getInstance(true, true);

        private Lazy() {
        }
    }

    private static class UuidHolder {
        private static final byte[] NIBBLES;

        private UuidHolder() {
        }

        static {
            byte[] ns = new byte[256];
            Arrays.fill(ns, (byte)-1);
            ns[48] = 0;
            ns[49] = 1;
            ns[50] = 2;
            ns[51] = 3;
            ns[52] = 4;
            ns[53] = 5;
            ns[54] = 6;
            ns[55] = 7;
            ns[56] = 8;
            ns[57] = 9;
            ns[65] = 10;
            ns[66] = 11;
            ns[67] = 12;
            ns[68] = 13;
            ns[69] = 14;
            ns[70] = 15;
            ns[97] = 10;
            ns[98] = 11;
            ns[99] = 12;
            ns[100] = 13;
            ns[101] = 14;
            ns[102] = 15;
            NIBBLES = ns;
        }
    }
}

