/*
 * Decompiled with CFR 0.152.
 */
package no.entur.schema2proto.generateproto;

import de.slub.urn.URN;
import de.slub.urn.URNSyntaxError;
import de.slub.urn.URN_8141;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceHelper {
    public static final String XML_SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final String PACKAGE_SEPARATOR = ".";
    public static final String URN_PART_SEPARATOR = ":";
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceHelper.class);
    private static Map<String, String> NAMESPACE_TO_PACKAGENAME = new HashMap<String, String>();

    public static String xmlNamespaceToProtoPackage(String namespace, String forceProtoPackage) {
        String packageName;
        if (forceProtoPackage != null) {
            packageName = forceProtoPackage.toLowerCase();
        } else if (StringUtils.trimToNull(namespace) == null) {
            packageName = null;
        } else {
            packageName = NAMESPACE_TO_PACKAGENAME.get(namespace);
            if (packageName == null) {
                try {
                    packageName = "URN:".equals(namespace.substring(0, 4).toUpperCase()) ? NamespaceHelper.convertAsUrn(namespace) : NamespaceHelper.convertAsUrl(namespace);
                }
                catch (MalformedURLException e) {
                    packageName = NamespaceHelper.convertAsBrokenUrl(namespace);
                    LOGGER.warn("Unable to create decent package name from XML namespace {}, falling back to {} ", namespace, packageName, e);
                }
                catch (URNSyntaxError urnSyntaxError) {
                    LOGGER.warn("Unable to create decent package name from XML namespace {}, falling back to {} ", namespace, packageName, urnSyntaxError);
                }
            }
            packageName = StringUtils.trimToNull(packageName).toLowerCase();
            NAMESPACE_TO_PACKAGENAME.put(namespace, packageName);
        }
        return packageName;
    }

    @NotNull
    private static String convertAsBrokenUrl(String namespace) {
        if (namespace.contains("://")) {
            namespace = namespace.substring(namespace.indexOf("://") + 3);
        }
        if ((namespace = namespace.replace("/", PACKAGE_SEPARATOR).replace("-", PACKAGE_SEPARATOR)).startsWith(PACKAGE_SEPARATOR)) {
            namespace = namespace.substring(1);
        }
        if (namespace.endsWith(PACKAGE_SEPARATOR)) {
            namespace = namespace.substring(0, namespace.length() - 1);
        }
        return namespace;
    }

    private static String convertAsUrl(String namespace) throws MalformedURLException {
        String[] pathparts;
        URL url = new URL(namespace);
        String host = url.getHost();
        String[] hostparts = StringUtils.split(host, PACKAGE_SEPARATOR);
        StringBuilder packageBuilder = new StringBuilder();
        for (int i = hostparts.length; i > 0; --i) {
            String hostpart = hostparts[i - 1];
            hostpart = NamespaceHelper.escapePart(hostpart);
            packageBuilder.append(hostpart);
            packageBuilder.append(PACKAGE_SEPARATOR);
        }
        String path = url.getPath();
        for (String pathpart : pathparts = StringUtils.split(path, "/")) {
            pathpart = NamespaceHelper.escapePart(pathpart);
            packageBuilder.append(pathpart);
            packageBuilder.append(PACKAGE_SEPARATOR);
        }
        return StringUtils.removeEnd(packageBuilder.toString(), PACKAGE_SEPARATOR);
    }

    static String convertAsUrn(String namespace) throws URNSyntaxError {
        URN_8141 urn = URN.rfc8141().parse(namespace);
        List<String> parts = new ArrayList<String>();
        parts.addAll(Arrays.asList(StringUtils.split(((URN)urn).namespaceIdentifier().toString(), URN_PART_SEPARATOR)));
        parts.addAll(Arrays.asList(StringUtils.split(((URN)urn).namespaceSpecificString().toString(), URN_PART_SEPARATOR)));
        parts = parts.stream().map(e -> NamespaceHelper.escapePart(e)).collect(Collectors.toList());
        parts = parts.stream().map(e -> StringUtils.remove(e, "!$&\u00b4()*+,;=")).collect(Collectors.toList());
        return StringUtils.join(parts, PACKAGE_SEPARATOR);
    }

    private static String escapePart(String pathpart) {
        String escapedPart = StringUtils.replaceEach(pathpart, new String[]{PACKAGE_SEPARATOR, "-", URN_PART_SEPARATOR, "#"}, new String[]{"_", "_", "_", "_"});
        if (Character.isDigit(escapedPart.charAt(0))) {
            escapedPart = "v" + escapedPart;
        }
        return escapedPart;
    }

    public static String xmlNamespaceToProtoFieldPackagename(String namespace, String forceProtoPackage) {
        String packageName = null;
        packageName = XML_SCHEMA_NAMESPACE.equals(namespace) ? null : (forceProtoPackage != null ? forceProtoPackage : NamespaceHelper.xmlNamespaceToProtoPackage(namespace, forceProtoPackage));
        if (packageName != null) {
            packageName = StringUtils.lowerCase(packageName);
        }
        return packageName;
    }
}

