/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.constraints;

import build.buf.protovalidate.Config;
import build.buf.protovalidate.exceptions.CompilationException;
import build.buf.protovalidate.internal.constraints.DescriptorMappings;
import build.buf.protovalidate.internal.errors.FieldPathUtils;
import build.buf.protovalidate.internal.evaluator.ObjectValue;
import build.buf.protovalidate.internal.expression.AstExpression;
import build.buf.protovalidate.internal.expression.CompiledProgram;
import build.buf.protovalidate.internal.expression.Expression;
import build.buf.protovalidate.internal.expression.Variable;
import build.buf.validate.FieldConstraints;
import build.buf.validate.FieldPath;
import build.buf.validate.PredefinedConstraints;
import build.buf.validate.ValidateProto;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TypeRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.projectnessie.cel.Ast;
import org.projectnessie.cel.Env;
import org.projectnessie.cel.EnvOption;
import org.projectnessie.cel.EvalOption;
import org.projectnessie.cel.Program;
import org.projectnessie.cel.ProgramOption;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.interpreter.Activation;

public class ConstraintCache {
    private static final ExtensionRegistry EXTENSION_REGISTRY = ExtensionRegistry.newInstance();
    private static final ProgramOption PARTIAL_EVAL_OPTIONS;
    private static final Map<Descriptors.FieldDescriptor, List<CelRule>> descriptorMap;
    private final Env env;
    private final TypeRegistry typeRegistry;
    private final ExtensionRegistry extensionRegistry;
    private final boolean allowUnknownFields;

    public ConstraintCache(Env env, Config config) {
        this.env = env;
        this.typeRegistry = config.getTypeRegistry();
        this.extensionRegistry = config.getExtensionRegistry();
        this.allowUnknownFields = config.isAllowingUnknownFields();
    }

    public List<CompiledProgram> compile(Descriptors.FieldDescriptor fieldDescriptor, FieldConstraints fieldConstraints, boolean forItems) throws CompilationException {
        ResolvedConstraint resolved = this.resolveConstraints(fieldDescriptor, fieldConstraints, forItems);
        if (resolved == null) {
            return Collections.emptyList();
        }
        Message message = resolved.message;
        ArrayList<CelRule> completeProgramList = new ArrayList<CelRule>();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : message.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor constraintFieldDesc = entry.getKey();
            List<CelRule> programList = this.compileRule(fieldDescriptor, forItems, resolved.setOneof, constraintFieldDesc, message);
            if (programList == null) continue;
            completeProgramList.addAll(programList);
        }
        ArrayList<CompiledProgram> programs = new ArrayList<CompiledProgram>();
        for (CelRule rule : completeProgramList) {
            Env ruleEnv = this.getRuleEnv(fieldDescriptor, message, rule.field, forItems);
            Variable ruleVar = Variable.newRuleVariable(message, message.getField(rule.field));
            ProgramOption globals = ProgramOption.globals(ruleVar);
            ObjectValue ruleValue = new ObjectValue(rule.field, message.getField(rule.field));
            try {
                Object val;
                Program program = ruleEnv.program(rule.astExpression.ast, globals, PARTIAL_EVAL_OPTIONS);
                Program.EvalResult evalResult = program.eval(Activation.emptyActivation());
                Val value = evalResult.getVal();
                if (value != null && ((val = value.value()) instanceof Boolean && value.booleanValue() || val instanceof String && val.equals(""))) continue;
                Ast residual = ruleEnv.residualAst(rule.astExpression.ast, evalResult.getEvalDetails());
                programs.add(new CompiledProgram(ruleEnv.program(residual, globals), rule.astExpression.source, rule.rulePath, ruleValue));
            }
            catch (Exception e) {
                programs.add(new CompiledProgram(ruleEnv.program(rule.astExpression.ast, globals), rule.astExpression.source, rule.rulePath, ruleValue));
            }
        }
        return Collections.unmodifiableList(programs);
    }

    @Nullable
    private List<CelRule> compileRule(Descriptors.FieldDescriptor fieldDescriptor, boolean forItems, Descriptors.FieldDescriptor setOneof, Descriptors.FieldDescriptor constraintFieldDesc, Message message) throws CompilationException {
        List<CelRule> celRules = descriptorMap.get(fieldDescriptor);
        if (celRules != null) {
            return celRules;
        }
        PredefinedConstraints constraints = this.getFieldConstraints(constraintFieldDesc);
        if (constraints == null) {
            return null;
        }
        List<Expression> expressions = Expression.fromConstraints(constraints.getCelList());
        celRules = new ArrayList<CelRule>(expressions.size());
        Env ruleEnv = this.getRuleEnv(fieldDescriptor, message, constraintFieldDesc, forItems);
        for (Expression expression : expressions) {
            FieldPath rulePath = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(setOneof)).addElements(FieldPathUtils.fieldPathElement(constraintFieldDesc)).build();
            celRules.add(new CelRule(AstExpression.newAstExpression(ruleEnv, expression), constraintFieldDesc, rulePath));
        }
        descriptorMap.put(constraintFieldDesc, celRules);
        return celRules;
    }

    @Nullable
    private PredefinedConstraints getFieldConstraints(Descriptors.FieldDescriptor constraintFieldDesc) throws CompilationException {
        PredefinedConstraints constraints;
        DescriptorProtos.FieldOptions options = constraintFieldDesc.getOptions();
        if (options.getUnknownFields().hasField(ValidateProto.predefined.getNumber())) {
            try {
                options = DescriptorProtos.FieldOptions.parseFrom(options.toByteString(), (ExtensionRegistryLite)EXTENSION_REGISTRY);
            }
            catch (InvalidProtocolBufferException e) {
                throw new CompilationException("Failed to parse field options", e);
            }
        }
        if (!options.hasExtension(ValidateProto.predefined)) {
            return null;
        }
        Object extensionValue = options.getField(ValidateProto.predefined.getDescriptor());
        if (extensionValue instanceof PredefinedConstraints) {
            constraints = (PredefinedConstraints)extensionValue;
        } else if (extensionValue instanceof MessageLite) {
            try {
                constraints = PredefinedConstraints.parseFrom(((MessageLite)extensionValue).toByteString());
            }
            catch (InvalidProtocolBufferException e) {
                throw new CompilationException("Failed to parse field constraints", e);
            }
        } else {
            return null;
        }
        return constraints;
    }

    private Env getRuleEnv(Descriptors.FieldDescriptor fieldDescriptor, Message constraintMessage, Descriptors.FieldDescriptor constraintFieldDesc, boolean forItems) {
        return this.env.extend(EnvOption.types(constraintMessage.getDefaultInstanceForType()), EnvOption.declarations(Decls.newVar("this", DescriptorMappings.getCELType(fieldDescriptor, forItems)), Decls.newVar("rules", Decls.newObjectType(constraintMessage.getDescriptorForType().getFullName())), Decls.newVar("rule", DescriptorMappings.getCELType(constraintFieldDesc, false))));
    }

    @Nullable
    private ResolvedConstraint resolveConstraints(Descriptors.FieldDescriptor fieldDescriptor, FieldConstraints fieldConstraints, boolean forItems) throws CompilationException {
        Descriptors.FieldDescriptor oneofFieldDescriptor = fieldConstraints.getOneofFieldDescriptor(DescriptorMappings.FIELD_CONSTRAINTS_ONEOF_DESC);
        if (oneofFieldDescriptor == null) {
            return null;
        }
        Descriptors.FieldDescriptor expectedConstraintDescriptor = DescriptorMappings.getExpectedConstraintDescriptor(fieldDescriptor, forItems);
        if (expectedConstraintDescriptor != null && !oneofFieldDescriptor.getFullName().equals(expectedConstraintDescriptor.getFullName())) {
            throw new CompilationException(String.format("expected constraint %s, got %s on field %s", expectedConstraintDescriptor.getName(), oneofFieldDescriptor.getName(), fieldDescriptor.getName()));
        }
        if (expectedConstraintDescriptor == null || !fieldConstraints.hasField(oneofFieldDescriptor)) {
            return null;
        }
        Message typeConstraints = (Message)fieldConstraints.getField(oneofFieldDescriptor);
        if (!typeConstraints.getUnknownFields().isEmpty()) {
            Descriptors.Descriptor expectedConstraintMessageDescriptor = this.typeRegistry.find(expectedConstraintDescriptor.getMessageType().getFullName());
            if (expectedConstraintMessageDescriptor == null) {
                expectedConstraintMessageDescriptor = expectedConstraintDescriptor.getMessageType();
            }
            try {
                typeConstraints = DynamicMessage.parseFrom(expectedConstraintMessageDescriptor, typeConstraints.toByteString(), this.extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.allowUnknownFields && !typeConstraints.getUnknownFields().isEmpty()) {
            throw new CompilationException("unrecognized field constraints");
        }
        return new ResolvedConstraint(typeConstraints, oneofFieldDescriptor);
    }

    static {
        EXTENSION_REGISTRY.add(ValidateProto.predefined);
        PARTIAL_EVAL_OPTIONS = ProgramOption.evalOptions(EvalOption.OptTrackState, EvalOption.OptExhaustiveEval, EvalOption.OptOptimize, EvalOption.OptPartialEval);
        descriptorMap = new ConcurrentHashMap<Descriptors.FieldDescriptor, List<CelRule>>();
    }

    private static class ResolvedConstraint {
        final Message message;
        final Descriptors.FieldDescriptor setOneof;

        ResolvedConstraint(Message message, Descriptors.FieldDescriptor setOneof) {
            this.message = message;
            this.setOneof = setOneof;
        }
    }

    private static class CelRule {
        public final AstExpression astExpression;
        public final Descriptors.FieldDescriptor field;
        public final FieldPath rulePath;

        public CelRule(AstExpression astExpression, Descriptors.FieldDescriptor field, FieldPath rulePath) {
            this.astExpression = astExpression;
            this.field = field;
            this.rulePath = rulePath;
        }
    }
}

