/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.errors;

import build.buf.protovalidate.Violation;
import build.buf.protovalidate.internal.errors.FieldPathUtils;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.validate.FieldPath;
import build.buf.validate.FieldPathElement;
import build.buf.validate.Violation;
import com.google.protobuf.Descriptors;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ConstraintViolation
implements Violation {
    public static final List<Builder> NO_VIOLATIONS = new ArrayList<Builder>();
    private final build.buf.validate.Violation proto;
    @Nullable
    private final FieldValue fieldValue;
    @Nullable
    private final FieldValue ruleValue;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ConstraintViolation(build.buf.validate.Violation proto, @Nullable FieldValue fieldValue, @Nullable FieldValue ruleValue) {
        this.proto = proto;
        this.fieldValue = fieldValue;
        this.ruleValue = ruleValue;
    }

    @Override
    public build.buf.validate.Violation toProto() {
        return this.proto;
    }

    @Override
    @Nullable
    public FieldValue getFieldValue() {
        return this.fieldValue;
    }

    @Override
    @Nullable
    public FieldValue getRuleValue() {
        return this.ruleValue;
    }

    public static class FieldValue
    implements Violation.FieldValue {
        @Nullable
        private final Object value;
        private final Descriptors.FieldDescriptor descriptor;

        public FieldValue(@Nullable Object value, Descriptors.FieldDescriptor descriptor) {
            this.value = value;
            this.descriptor = descriptor;
        }

        public FieldValue(Value value) {
            this.value = value.value(Object.class);
            this.descriptor = Objects.requireNonNull(value.fieldDescriptor());
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.value;
        }

        @Override
        public Descriptors.FieldDescriptor getDescriptor() {
            return this.descriptor;
        }
    }

    public static class Builder {
        @Nullable
        private String constraintId;
        @Nullable
        private String message;
        private boolean forKey = false;
        private final Deque<FieldPathElement> fieldPath = new ArrayDeque<FieldPathElement>();
        private final Deque<FieldPathElement> rulePath = new ArrayDeque<FieldPathElement>();
        @Nullable
        private FieldValue fieldValue;
        @Nullable
        private FieldValue ruleValue;

        public Builder setConstraintId(String constraintId) {
            this.constraintId = constraintId;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setForKey(boolean forKey) {
            this.forKey = forKey;
            return this;
        }

        public Builder addAllFieldPathElements(Collection<? extends FieldPathElement> fieldPathElements) {
            this.fieldPath.addAll(fieldPathElements);
            return this;
        }

        public Builder addFirstFieldPathElement(@Nullable FieldPathElement fieldPathElement) {
            if (fieldPathElement != null) {
                this.fieldPath.addFirst(fieldPathElement);
            }
            return this;
        }

        public Builder addAllRulePathElements(Collection<? extends FieldPathElement> rulePathElements) {
            this.rulePath.addAll(rulePathElements);
            return this;
        }

        public Builder addFirstRulePathElement(FieldPathElement rulePathElements) {
            this.rulePath.addFirst(rulePathElements);
            return this;
        }

        public Builder setFieldValue(@Nullable FieldValue fieldValue) {
            this.fieldValue = fieldValue;
            return this;
        }

        public Builder setRuleValue(@Nullable FieldValue ruleValue) {
            this.ruleValue = ruleValue;
            return this;
        }

        public ConstraintViolation build() {
            Violation.Builder protoBuilder = build.buf.validate.Violation.newBuilder();
            if (this.constraintId != null) {
                protoBuilder.setConstraintId(this.constraintId);
            }
            if (this.message != null) {
                protoBuilder.setMessage(this.message);
            }
            if (this.forKey) {
                protoBuilder.setForKey(true);
            }
            if (!this.fieldPath.isEmpty()) {
                FieldPath field = FieldPath.newBuilder().addAllElements(this.fieldPath).build();
                protoBuilder.setField(field).setFieldPath(FieldPathUtils.fieldPathString(field));
            }
            if (!this.rulePath.isEmpty()) {
                protoBuilder.setRule(FieldPath.newBuilder().addAllElements(this.rulePath));
            }
            return new ConstraintViolation(protoBuilder.build(), this.fieldValue, this.ruleValue);
        }

        private Builder() {
        }
    }
}

