/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.errors;

import build.buf.protovalidate.internal.errors.ConstraintViolation;
import build.buf.validate.FieldPath;
import build.buf.validate.FieldPathElement;
import com.google.protobuf.Descriptors;
import java.util.List;
import javax.annotation.Nullable;

public final class FieldPathUtils {
    private FieldPathUtils() {
    }

    static String fieldPathString(FieldPath fieldPath) {
        StringBuilder builder = new StringBuilder();
        for (FieldPathElement element : fieldPath.getElementsList()) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(element.getFieldName());
            switch (element.getSubscriptCase()) {
                case INDEX: {
                    builder.append("[");
                    builder.append(element.getIndex());
                    builder.append("]");
                    break;
                }
                case BOOL_KEY: {
                    if (element.getBoolKey()) {
                        builder.append("[true]");
                        break;
                    }
                    builder.append("[false]");
                    break;
                }
                case INT_KEY: {
                    builder.append("[");
                    builder.append(element.getIntKey());
                    builder.append("]");
                    break;
                }
                case UINT_KEY: {
                    builder.append("[");
                    builder.append(element.getUintKey());
                    builder.append("]");
                    break;
                }
                case STRING_KEY: {
                    builder.append("[\"");
                    builder.append(element.getStringKey().replace("\\", "\\\\").replace("\"", "\\\""));
                    builder.append("\"]");
                    break;
                }
            }
        }
        return builder.toString();
    }

    public static FieldPathElement fieldPathElement(Descriptors.FieldDescriptor fieldDescriptor) {
        String name = fieldDescriptor.isExtension() ? "[" + fieldDescriptor.getFullName() + "]" : fieldDescriptor.getName();
        return FieldPathElement.newBuilder().setFieldNumber(fieldDescriptor.getNumber()).setFieldName(name).setFieldType(fieldDescriptor.getType().toProto()).build();
    }

    public static List<ConstraintViolation.Builder> updatePaths(List<ConstraintViolation.Builder> violations, @Nullable FieldPathElement fieldPathElement, List<FieldPathElement> rulePathElements) {
        if (fieldPathElement != null || !rulePathElements.isEmpty()) {
            for (ConstraintViolation.Builder violation : violations) {
                for (int i = rulePathElements.size() - 1; i >= 0; --i) {
                    violation.addFirstRulePathElement(rulePathElements.get(i));
                }
                if (fieldPathElement == null) continue;
                violation.addFirstFieldPathElement(fieldPathElement);
            }
        }
        return violations;
    }
}

