/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.errors.ConstraintViolation;
import build.buf.protovalidate.internal.errors.FieldPathUtils;
import build.buf.protovalidate.internal.evaluator.ConstraintViolationHelper;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.protovalidate.internal.evaluator.ValueEvaluator;
import build.buf.validate.AnyRules;
import build.buf.validate.FieldConstraints;
import build.buf.validate.FieldPath;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class AnyEvaluator
implements Evaluator {
    private final ConstraintViolationHelper helper;
    private final Descriptors.FieldDescriptor typeURLDescriptor;
    private final Set<String> in;
    private final List<String> inValue;
    private final Set<String> notIn;
    private final List<String> notInValue;
    private static final Descriptors.FieldDescriptor ANY_DESCRIPTOR = FieldConstraints.getDescriptor().findFieldByNumber(20);
    private static final Descriptors.FieldDescriptor IN_DESCRIPTOR = AnyRules.getDescriptor().findFieldByNumber(2);
    private static final Descriptors.FieldDescriptor NOT_IN_DESCRIPTOR = AnyRules.getDescriptor().findFieldByNumber(3);
    private static final FieldPath IN_RULE_PATH = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(ANY_DESCRIPTOR)).addElements(FieldPathUtils.fieldPathElement(IN_DESCRIPTOR)).build();
    private static final FieldPath NOT_IN_RULE_PATH = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(ANY_DESCRIPTOR)).addElements(FieldPathUtils.fieldPathElement(NOT_IN_DESCRIPTOR)).build();

    AnyEvaluator(ValueEvaluator valueEvaluator, Descriptors.FieldDescriptor typeURLDescriptor, List<String> in, List<String> notIn) {
        this.helper = new ConstraintViolationHelper(valueEvaluator);
        this.typeURLDescriptor = typeURLDescriptor;
        this.in = AnyEvaluator.stringsToSet(in);
        this.inValue = in;
        this.notIn = AnyEvaluator.stringsToSet(notIn);
        this.notInValue = notIn;
    }

    @Override
    public List<ConstraintViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        ConstraintViolation.Builder violation;
        Message anyValue = val.messageValue();
        if (anyValue == null) {
            return ConstraintViolation.NO_VIOLATIONS;
        }
        ArrayList<ConstraintViolation.Builder> violationList = new ArrayList<ConstraintViolation.Builder>();
        String typeURL = (String)anyValue.getField(this.typeURLDescriptor);
        if (!this.in.isEmpty() && !this.in.contains(typeURL)) {
            violation = ConstraintViolation.newBuilder().addAllRulePathElements(this.helper.getRulePrefixElements()).addAllRulePathElements(IN_RULE_PATH.getElementsList()).addFirstFieldPathElement(this.helper.getFieldPathElement()).setConstraintId("any.in").setMessage("type URL must be in the allow list").setFieldValue(new ConstraintViolation.FieldValue(val)).setRuleValue(new ConstraintViolation.FieldValue(this.inValue, IN_DESCRIPTOR));
            violationList.add(violation);
            if (failFast) {
                return violationList;
            }
        }
        if (!this.notIn.isEmpty() && this.notIn.contains(typeURL)) {
            violation = ConstraintViolation.newBuilder().addAllRulePathElements(this.helper.getRulePrefixElements()).addAllRulePathElements(NOT_IN_RULE_PATH.getElementsList()).addFirstFieldPathElement(this.helper.getFieldPathElement()).setConstraintId("any.not_in").setMessage("type URL must not be in the block list").setFieldValue(new ConstraintViolation.FieldValue(val)).setRuleValue(new ConstraintViolation.FieldValue(this.notInValue, NOT_IN_DESCRIPTOR));
            violationList.add(violation);
        }
        return violationList;
    }

    @Override
    public boolean tautology() {
        return this.in.isEmpty() && this.notIn.isEmpty();
    }

    private static Set<String> stringsToSet(List<String> strings) {
        if (strings.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(strings);
    }
}

