/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.errors.ConstraintViolation;
import build.buf.protovalidate.internal.errors.FieldPathUtils;
import build.buf.protovalidate.internal.evaluator.ConstraintViolationHelper;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.protovalidate.internal.evaluator.ValueEvaluator;
import build.buf.protovalidate.internal.expression.CompiledProgram;
import build.buf.protovalidate.internal.expression.Variable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class CelPrograms
implements Evaluator {
    private final ConstraintViolationHelper helper;
    private final List<CompiledProgram> programs;

    CelPrograms(@Nullable ValueEvaluator valueEvaluator, List<CompiledProgram> compiledPrograms) {
        this.helper = new ConstraintViolationHelper(valueEvaluator);
        this.programs = compiledPrograms;
    }

    @Override
    public boolean tautology() {
        return this.programs.isEmpty();
    }

    @Override
    public List<ConstraintViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        Variable activation = Variable.newThisVariable(val.value(Object.class));
        ArrayList<ConstraintViolation.Builder> violations = new ArrayList<ConstraintViolation.Builder>();
        for (CompiledProgram program : this.programs) {
            ConstraintViolation.Builder violation = program.eval(val, activation);
            if (violation == null) continue;
            violations.add(violation);
            if (!failFast) continue;
            break;
        }
        return FieldPathUtils.updatePaths(violations, this.helper.getFieldPathElement(), this.helper.getRulePrefixElements());
    }
}

