/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.exceptions.CompilationException;
import build.buf.validate.FieldConstraints;
import build.buf.validate.MessageConstraints;
import build.buf.validate.OneofConstraints;
import build.buf.validate.ValidateProto;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;

class ConstraintResolver {
    private static final ExtensionRegistry EXTENSION_REGISTRY = ExtensionRegistry.newInstance();

    ConstraintResolver() {
    }

    MessageConstraints resolveMessageConstraints(Descriptors.Descriptor desc) throws InvalidProtocolBufferException, CompilationException {
        DescriptorProtos.MessageOptions options = desc.getOptions();
        if (options.getUnknownFields().hasField(ValidateProto.message.getNumber())) {
            options = DescriptorProtos.MessageOptions.parseFrom(options.toByteString(), (ExtensionRegistryLite)EXTENSION_REGISTRY);
        }
        if (!options.hasExtension(ValidateProto.message)) {
            return MessageConstraints.getDefaultInstance();
        }
        Object value = options.getField(ValidateProto.message.getDescriptor());
        if (value instanceof MessageConstraints) {
            return (MessageConstraints)value;
        }
        if (value instanceof MessageLite) {
            return MessageConstraints.parseFrom(((MessageLite)value).toByteString());
        }
        throw new CompilationException("unexpected message constraint option type: " + value);
    }

    OneofConstraints resolveOneofConstraints(Descriptors.OneofDescriptor desc) throws InvalidProtocolBufferException, CompilationException {
        DescriptorProtos.OneofOptions options = desc.getOptions();
        if (options.getUnknownFields().hasField(ValidateProto.oneof.getNumber())) {
            options = DescriptorProtos.OneofOptions.parseFrom(options.toByteString(), (ExtensionRegistryLite)EXTENSION_REGISTRY);
        }
        if (!options.hasExtension(ValidateProto.oneof)) {
            return OneofConstraints.getDefaultInstance();
        }
        Object value = options.getField(ValidateProto.oneof.getDescriptor());
        if (value instanceof OneofConstraints) {
            return (OneofConstraints)value;
        }
        if (value instanceof MessageLite) {
            return OneofConstraints.parseFrom(((MessageLite)value).toByteString());
        }
        throw new CompilationException("unexpected oneof constraint option type: " + value);
    }

    FieldConstraints resolveFieldConstraints(Descriptors.FieldDescriptor desc) throws InvalidProtocolBufferException, CompilationException {
        DescriptorProtos.FieldOptions options = desc.getOptions();
        if (options.getUnknownFields().hasField(ValidateProto.field.getNumber())) {
            options = DescriptorProtos.FieldOptions.parseFrom(options.toByteString(), (ExtensionRegistryLite)EXTENSION_REGISTRY);
        }
        if (!options.hasExtension(ValidateProto.field)) {
            return FieldConstraints.getDefaultInstance();
        }
        Object value = options.getField(ValidateProto.field.getDescriptor());
        if (value instanceof FieldConstraints) {
            return (FieldConstraints)value;
        }
        if (value instanceof MessageLite) {
            return FieldConstraints.parseFrom(((MessageLite)value).toByteString());
        }
        throw new CompilationException("unexpected field constraint option type: " + value);
    }

    static {
        EXTENSION_REGISTRY.add(ValidateProto.message);
        EXTENSION_REGISTRY.add(ValidateProto.oneof);
        EXTENSION_REGISTRY.add(ValidateProto.field);
    }
}

