/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.errors.ConstraintViolation;
import build.buf.protovalidate.internal.errors.FieldPathUtils;
import build.buf.protovalidate.internal.evaluator.ConstraintViolationHelper;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.protovalidate.internal.evaluator.ValueEvaluator;
import build.buf.validate.EnumRules;
import build.buf.validate.FieldConstraints;
import build.buf.validate.FieldPath;
import com.google.protobuf.Descriptors;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class EnumEvaluator
implements Evaluator {
    private final ConstraintViolationHelper helper;
    private final Set<Integer> values;
    private static final Descriptors.FieldDescriptor DEFINED_ONLY_DESCRIPTOR = EnumRules.getDescriptor().findFieldByNumber(2);
    private static final FieldPath DEFINED_ONLY_RULE_PATH = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(FieldConstraints.getDescriptor().findFieldByNumber(16))).addElements(FieldPathUtils.fieldPathElement(DEFINED_ONLY_DESCRIPTOR)).build();

    EnumEvaluator(ValueEvaluator valueEvaluator, List<Descriptors.EnumValueDescriptor> valueDescriptors) {
        this.helper = new ConstraintViolationHelper(valueEvaluator);
        this.values = valueDescriptors.isEmpty() ? Collections.emptySet() : valueDescriptors.stream().map(Descriptors.EnumValueDescriptor::getNumber).collect(Collectors.toSet());
    }

    @Override
    public boolean tautology() {
        return false;
    }

    @Override
    public List<ConstraintViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        Descriptors.EnumValueDescriptor enumValue = val.value(Descriptors.EnumValueDescriptor.class);
        if (enumValue == null) {
            return ConstraintViolation.NO_VIOLATIONS;
        }
        if (!this.values.contains(enumValue.getNumber())) {
            return Collections.singletonList(ConstraintViolation.newBuilder().addAllRulePathElements(this.helper.getRulePrefixElements()).addAllRulePathElements(DEFINED_ONLY_RULE_PATH.getElementsList()).addFirstFieldPathElement(this.helper.getFieldPathElement()).setConstraintId("enum.defined_only").setMessage("value must be one of the defined enum values").setFieldValue(new ConstraintViolation.FieldValue(val)).setRuleValue(new ConstraintViolation.FieldValue(true, DEFINED_ONLY_DESCRIPTOR)));
        }
        return ConstraintViolation.NO_VIOLATIONS;
    }
}

