/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.errors.ConstraintViolation;
import build.buf.protovalidate.internal.errors.FieldPathUtils;
import build.buf.protovalidate.internal.evaluator.ConstraintViolationHelper;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.ObjectValue;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.protovalidate.internal.evaluator.ValueEvaluator;
import build.buf.validate.FieldConstraints;
import build.buf.validate.FieldPath;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

class FieldEvaluator
implements Evaluator {
    private static final Descriptors.FieldDescriptor REQUIRED_DESCRIPTOR = FieldConstraints.getDescriptor().findFieldByNumber(25);
    private static final FieldPath REQUIRED_RULE_PATH = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(REQUIRED_DESCRIPTOR)).build();
    private final ConstraintViolationHelper helper;
    public final ValueEvaluator valueEvaluator;
    private final Descriptors.FieldDescriptor descriptor;
    private final boolean required;
    private final boolean ignoreEmpty;
    private final boolean ignoreDefault;
    @Nullable
    private final Object zero;

    FieldEvaluator(ValueEvaluator valueEvaluator, Descriptors.FieldDescriptor descriptor, boolean required, boolean ignoreEmpty, boolean ignoreDefault, @Nullable Object zero) {
        this.helper = new ConstraintViolationHelper(valueEvaluator);
        this.valueEvaluator = valueEvaluator;
        this.descriptor = descriptor;
        this.required = required;
        this.ignoreEmpty = ignoreEmpty;
        this.ignoreDefault = ignoreDefault;
        this.zero = zero;
    }

    @Override
    public boolean tautology() {
        return !this.required && this.valueEvaluator.tautology();
    }

    @Override
    public List<ConstraintViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        Message message = val.messageValue();
        if (message == null) {
            return ConstraintViolation.NO_VIOLATIONS;
        }
        boolean hasField = this.descriptor.isRepeated() ? message.getRepeatedFieldCount(this.descriptor) != 0 : message.hasField(this.descriptor);
        if (this.required && !hasField) {
            return Collections.singletonList(ConstraintViolation.newBuilder().addFirstFieldPathElement(FieldPathUtils.fieldPathElement(this.descriptor)).addAllRulePathElements(this.helper.getRulePrefixElements()).addAllRulePathElements(REQUIRED_RULE_PATH.getElementsList()).setConstraintId("required").setMessage("value is required").setRuleValue(new ConstraintViolation.FieldValue(true, REQUIRED_DESCRIPTOR)));
        }
        if (this.ignoreEmpty && !hasField) {
            return ConstraintViolation.NO_VIOLATIONS;
        }
        Object fieldValue = message.getField(this.descriptor);
        if (this.ignoreDefault && Objects.equals(this.zero, fieldValue)) {
            return ConstraintViolation.NO_VIOLATIONS;
        }
        return this.valueEvaluator.evaluate(new ObjectValue(this.descriptor, fieldValue), failFast);
    }
}

