/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.errors.ConstraintViolation;
import build.buf.protovalidate.internal.errors.FieldPathUtils;
import build.buf.protovalidate.internal.evaluator.ConstraintViolationHelper;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.protovalidate.internal.evaluator.ValueEvaluator;
import build.buf.validate.FieldConstraints;
import build.buf.validate.FieldPath;
import build.buf.validate.FieldPathElement;
import build.buf.validate.RepeatedRules;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

class ListEvaluator
implements Evaluator {
    private static final FieldPath REPEATED_ITEMS_RULE_PATH = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(FieldConstraints.getDescriptor().findFieldByNumber(18))).addElements(FieldPathUtils.fieldPathElement(RepeatedRules.getDescriptor().findFieldByNumber(4))).build();
    private final ConstraintViolationHelper helper;
    final ValueEvaluator itemConstraints;

    ListEvaluator(ValueEvaluator valueEvaluator) {
        this.helper = new ConstraintViolationHelper(valueEvaluator);
        this.itemConstraints = new ValueEvaluator(null, REPEATED_ITEMS_RULE_PATH);
    }

    @Override
    public boolean tautology() {
        return this.itemConstraints.tautology();
    }

    @Override
    public List<ConstraintViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        ArrayList<ConstraintViolation.Builder> allViolations = new ArrayList<ConstraintViolation.Builder>();
        List<Value> repeatedValues = val.repeatedValue();
        for (int i = 0; i < repeatedValues.size(); ++i) {
            List<ConstraintViolation.Builder> violations = this.itemConstraints.evaluate(repeatedValues.get(i), failFast);
            if (violations.isEmpty()) continue;
            FieldPathElement fieldPathElement = Objects.requireNonNull(this.helper.getFieldPathElement()).toBuilder().setIndex(i).build();
            FieldPathUtils.updatePaths(violations, fieldPathElement, this.helper.getRulePrefixElements());
            if (failFast && !violations.isEmpty()) {
                return violations;
            }
            allViolations.addAll(violations);
        }
        return allViolations;
    }
}

