/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.errors.ConstraintViolation;
import build.buf.protovalidate.internal.errors.FieldPathUtils;
import build.buf.protovalidate.internal.evaluator.ConstraintViolationHelper;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.protovalidate.internal.evaluator.ValueEvaluator;
import build.buf.validate.FieldConstraints;
import build.buf.validate.FieldPath;
import build.buf.validate.FieldPathElement;
import build.buf.validate.MapRules;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class MapEvaluator
implements Evaluator {
    private static final FieldPath MAP_KEYS_RULE_PATH = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(FieldConstraints.getDescriptor().findFieldByNumber(19))).addElements(FieldPathUtils.fieldPathElement(MapRules.getDescriptor().findFieldByNumber(4))).build();
    private static final FieldPath MAP_VALUES_RULE_PATH = FieldPath.newBuilder().addElements(FieldPathUtils.fieldPathElement(FieldConstraints.getDescriptor().findFieldByNumber(19))).addElements(FieldPathUtils.fieldPathElement(MapRules.getDescriptor().findFieldByNumber(5))).build();
    private final ConstraintViolationHelper helper;
    private final ValueEvaluator keyEvaluator;
    private final ValueEvaluator valueEvaluator;
    final Descriptors.FieldDescriptor fieldDescriptor;
    final Descriptors.FieldDescriptor keyFieldDescriptor;
    final Descriptors.FieldDescriptor valueFieldDescriptor;

    MapEvaluator(ValueEvaluator valueEvaluator, Descriptors.FieldDescriptor fieldDescriptor) {
        this.helper = new ConstraintViolationHelper(valueEvaluator);
        this.keyEvaluator = new ValueEvaluator(null, MAP_KEYS_RULE_PATH);
        this.valueEvaluator = new ValueEvaluator(null, MAP_VALUES_RULE_PATH);
        this.fieldDescriptor = fieldDescriptor;
        this.keyFieldDescriptor = fieldDescriptor.getMessageType().findFieldByNumber(1);
        this.valueFieldDescriptor = fieldDescriptor.getMessageType().findFieldByNumber(2);
    }

    public ValueEvaluator getKeyEvaluator() {
        return this.keyEvaluator;
    }

    public ValueEvaluator getValueEvaluator() {
        return this.valueEvaluator;
    }

    @Override
    public boolean tautology() {
        return this.keyEvaluator.tautology() && this.valueEvaluator.tautology();
    }

    @Override
    public List<ConstraintViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        ArrayList<ConstraintViolation.Builder> violations = new ArrayList<ConstraintViolation.Builder>();
        Map<Value, Value> mapValue = val.mapValue();
        for (Map.Entry<Value, Value> entry : mapValue.entrySet()) {
            violations.addAll(this.evalPairs(entry.getKey(), entry.getValue(), failFast));
            if (!failFast || violations.isEmpty()) continue;
            return violations;
        }
        if (violations.isEmpty()) {
            return ConstraintViolation.NO_VIOLATIONS;
        }
        return violations;
    }

    private List<ConstraintViolation.Builder> evalPairs(Value key, Value value, boolean failFast) throws ExecutionException {
        List keyViolations = this.keyEvaluator.evaluate(key, failFast).stream().map(violation -> violation.setForKey(true)).collect(Collectors.toList());
        List<ConstraintViolation.Builder> valueViolations = failFast && !keyViolations.isEmpty() ? ConstraintViolation.NO_VIOLATIONS : this.valueEvaluator.evaluate(value, failFast);
        if (keyViolations.isEmpty() && valueViolations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ConstraintViolation.Builder> violations = new ArrayList<ConstraintViolation.Builder>(keyViolations.size() + valueViolations.size());
        violations.addAll(keyViolations);
        violations.addAll(valueViolations);
        FieldPathElement.Builder fieldPathElementBuilder = Objects.requireNonNull(this.helper.getFieldPathElement()).toBuilder();
        fieldPathElementBuilder.setKeyType(this.keyFieldDescriptor.getType().toProto());
        fieldPathElementBuilder.setValueType(this.valueFieldDescriptor.getType().toProto());
        switch (this.keyFieldDescriptor.getType().toProto()) {
            case TYPE_INT64: 
            case TYPE_INT32: 
            case TYPE_SINT32: 
            case TYPE_SINT64: 
            case TYPE_SFIXED32: 
            case TYPE_SFIXED64: {
                fieldPathElementBuilder.setIntKey(key.value(Number.class).longValue());
                break;
            }
            case TYPE_UINT32: 
            case TYPE_UINT64: 
            case TYPE_FIXED32: 
            case TYPE_FIXED64: {
                fieldPathElementBuilder.setUintKey(key.value(Number.class).longValue());
                break;
            }
            case TYPE_BOOL: {
                fieldPathElementBuilder.setBoolKey(key.value(Boolean.class));
                break;
            }
            case TYPE_STRING: {
                fieldPathElementBuilder.setStringKey(key.value(String.class));
                break;
            }
            default: {
                throw new ExecutionException("Unexpected map key type");
            }
        }
        FieldPathElement fieldPathElement = fieldPathElementBuilder.build();
        return FieldPathUtils.updatePaths(violations, fieldPathElement, this.helper.getRulePrefixElements());
    }
}

