/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.errors.ConstraintViolation;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import java.util.ArrayList;
import java.util.List;

class MessageEvaluator
implements Evaluator {
    private final List<Evaluator> evaluators = new ArrayList<Evaluator>();

    MessageEvaluator() {
    }

    @Override
    public boolean tautology() {
        for (Evaluator evaluator : this.evaluators) {
            if (evaluator.tautology()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<ConstraintViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        ArrayList<ConstraintViolation.Builder> allViolations = new ArrayList<ConstraintViolation.Builder>();
        for (Evaluator evaluator : this.evaluators) {
            List<ConstraintViolation.Builder> violations = evaluator.evaluate(val, failFast);
            if (failFast && !violations.isEmpty()) {
                return violations;
            }
            allViolations.addAll(violations);
        }
        if (allViolations.isEmpty()) {
            return ConstraintViolation.NO_VIOLATIONS;
        }
        return allViolations;
    }

    public void append(Evaluator eval) {
        this.evaluators.add(eval);
    }
}

