/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.errors.ConstraintViolation;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.validate.FieldPathElement;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.Collections;
import java.util.List;

public class OneofEvaluator
implements Evaluator {
    private final Descriptors.OneofDescriptor descriptor;
    private final boolean required;

    public OneofEvaluator(Descriptors.OneofDescriptor descriptor, boolean required) {
        this.descriptor = descriptor;
        this.required = required;
    }

    @Override
    public boolean tautology() {
        return !this.required;
    }

    @Override
    public List<ConstraintViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        Message message = val.messageValue();
        if (message == null || !this.required || message.getOneofFieldDescriptor(this.descriptor) != null) {
            return ConstraintViolation.NO_VIOLATIONS;
        }
        return Collections.singletonList(ConstraintViolation.newBuilder().addFirstFieldPathElement(FieldPathElement.newBuilder().setFieldName(this.descriptor.getName()).build()).setConstraintId("required").setMessage("exactly one field is required in oneof"));
    }
}

