/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.errors.ConstraintViolation;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.validate.FieldPath;
import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

class ValueEvaluator
implements Evaluator {
    @Nullable
    private final Descriptors.FieldDescriptor descriptor;
    @Nullable
    private final FieldPath nestedRule;
    @Nullable
    private Object zero;
    private final List<Evaluator> evaluators = new ArrayList<Evaluator>();
    private boolean ignoreEmpty;

    ValueEvaluator(@Nullable Descriptors.FieldDescriptor descriptor, @Nullable FieldPath nestedRule) {
        this.descriptor = descriptor;
        this.nestedRule = nestedRule;
    }

    @Nullable
    public Descriptors.FieldDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Nullable
    public FieldPath getNestedRule() {
        return this.nestedRule;
    }

    @Override
    public boolean tautology() {
        return this.evaluators.isEmpty();
    }

    @Override
    public List<ConstraintViolation.Builder> evaluate(Value val, boolean failFast) throws ExecutionException {
        if (this.shouldIgnore(val.value(Object.class))) {
            return ConstraintViolation.NO_VIOLATIONS;
        }
        ArrayList<ConstraintViolation.Builder> allViolations = new ArrayList<ConstraintViolation.Builder>();
        for (Evaluator evaluator : this.evaluators) {
            List<ConstraintViolation.Builder> violations = evaluator.evaluate(val, failFast);
            if (failFast && !violations.isEmpty()) {
                return violations;
            }
            allViolations.addAll(violations);
        }
        if (allViolations.isEmpty()) {
            return ConstraintViolation.NO_VIOLATIONS;
        }
        return allViolations;
    }

    public void append(Evaluator eval) {
        if (!eval.tautology()) {
            this.evaluators.add(eval);
        }
    }

    public void setIgnoreEmpty(Object zero) {
        this.ignoreEmpty = true;
        this.zero = zero;
    }

    private boolean shouldIgnore(Object value) {
        return this.ignoreEmpty && Objects.equals(value, this.zero);
    }
}

