/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.expression;

import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.errors.ConstraintViolation;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.protovalidate.internal.expression.Expression;
import build.buf.protovalidate.internal.expression.Variable;
import build.buf.validate.FieldPath;
import javax.annotation.Nullable;
import org.projectnessie.cel.Program;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.ref.Val;

public class CompiledProgram {
    private final Program program;
    private final Expression source;
    @Nullable
    private final FieldPath rulePath;
    @Nullable
    private final Value ruleValue;

    public CompiledProgram(Program program, Expression source2, @Nullable FieldPath rulePath, @Nullable Value ruleValue) {
        this.program = program;
        this.source = source2;
        this.rulePath = rulePath;
        this.ruleValue = ruleValue;
    }

    @Nullable
    public ConstraintViolation.Builder eval(Value fieldValue, Variable bindings) throws ExecutionException {
        Program.EvalResult evalResult = this.program.eval(bindings);
        Val val = evalResult.getVal();
        if (val instanceof Err) {
            throw new ExecutionException(String.format("error evaluating %s: %s", this.source.id, val));
        }
        Object value = val.value();
        if (value instanceof String) {
            if ("".equals(value)) {
                return null;
            }
            ConstraintViolation.Builder builder = ConstraintViolation.newBuilder().setConstraintId(this.source.id).setMessage(value.toString());
            if (fieldValue.fieldDescriptor() != null) {
                builder.setFieldValue(new ConstraintViolation.FieldValue(fieldValue));
            }
            if (this.rulePath != null) {
                builder.addAllRulePathElements(this.rulePath.getElementsList());
            }
            if (this.ruleValue != null && this.ruleValue.fieldDescriptor() != null) {
                builder.setRuleValue(new ConstraintViolation.FieldValue(this.ruleValue));
            }
            return builder;
        }
        if (value instanceof Boolean) {
            if (val.booleanValue()) {
                return null;
            }
            ConstraintViolation.Builder builder = ConstraintViolation.newBuilder().setConstraintId(this.source.id).setMessage(this.source.message);
            if (this.rulePath != null) {
                builder.addAllRulePathElements(this.rulePath.getElementsList());
            }
            if (this.ruleValue != null && this.ruleValue.fieldDescriptor() != null) {
                builder.setRuleValue(new ConstraintViolation.FieldValue(this.ruleValue));
            }
            return builder;
        }
        throw new ExecutionException(String.format("resolved to an unexpected type %s", val));
    }
}

