/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.function.Consumer;
import java.util.function.IntFunction;

public final class IntLruCache<E>
implements AutoCloseable {
    private final int capacity;
    private final IntFunction<E> factory;
    private final Consumer<E> closer;
    private final int[] keys;
    private final Object[] values;
    private int size;

    public IntLruCache(int capacity, IntFunction<E> factory, Consumer<E> closer) {
        this.capacity = capacity;
        this.factory = factory;
        this.closer = closer;
        this.keys = new int[capacity];
        this.values = new Object[capacity];
        this.size = 0;
    }

    public E lookup(int key) {
        int size = this.size;
        int[] keys2 = this.keys;
        Object[] values2 = this.values;
        for (int i = 0; i < size; ++i) {
            if (key != keys2[i]) continue;
            Object value = values2[i];
            this.makeMostRecent(key, value, i);
            return (E)value;
        }
        E value = this.factory.apply(key);
        if (value != null) {
            if (this.capacity == size) {
                this.closer.accept(values2[size - 1]);
            } else {
                this.size = ++size;
            }
            this.makeMostRecent(key, value, size - 1);
        }
        return value;
    }

    private void makeMostRecent(int key, Object value, int fromIndex) {
        int[] keys2 = this.keys;
        Object[] values2 = this.values;
        for (int i = fromIndex; i > 0; --i) {
            keys2[i] = keys2[i - 1];
            values2[i] = values2[i - 1];
        }
        keys2[0] = key;
        values2[0] = value;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public void close() {
        Consumer<E> closer = this.closer;
        Object[] values2 = this.values;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            closer.accept(values2[i]);
        }
    }
}

