/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.LongPredicate;
import java.util.function.ToLongFunction;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.LongLongFunction;
import org.agrona.collections.ObjLongConsumer;
import org.agrona.collections.ObjLongPredicate;
import org.agrona.collections.ObjectLongToLongFunction;

public class Object2LongHashMap<K>
implements Map<K, Long> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final long missingValue;
    private int resizeThreshold;
    private int size;
    private final boolean shouldAvoidAllocation;
    private K[] keys;
    private long[] values;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Object2LongHashMap(long missingValue) {
        this(8, 0.65f, missingValue);
    }

    public Object2LongHashMap(int initialCapacity, float loadFactor, long missingValue) {
        this(initialCapacity, loadFactor, missingValue, true);
    }

    public Object2LongHashMap(int initialCapacity, float loadFactor, long missingValue, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        int capacity = BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity));
        this.resizeThreshold = (int)((float)capacity * loadFactor);
        this.missingValue = missingValue;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.keys = new Object[capacity];
        this.values = new long[capacity];
        Arrays.fill(this.values, missingValue);
    }

    public Object2LongHashMap(Object2LongHashMap<K> mapToCopy) {
        this.loadFactor = mapToCopy.loadFactor;
        this.resizeThreshold = mapToCopy.resizeThreshold;
        this.size = mapToCopy.size;
        this.missingValue = mapToCopy.missingValue;
        this.shouldAvoidAllocation = mapToCopy.shouldAvoidAllocation;
        this.keys = (Object[])mapToCopy.keys.clone();
        this.values = (long[])mapToCopy.values.clone();
    }

    public long missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.missingValue != this.getValue(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Long)value);
    }

    public boolean containsValue(long value) {
        long[] values2;
        if (this.missingValue == value) {
            return false;
        }
        boolean found = false;
        for (long v : values2 = this.values) {
            if (value != v) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public long getOrDefault(Object key, long defaultValue) {
        long value = this.getValue(key);
        return this.missingValue != value ? value : defaultValue;
    }

    @Override
    public Long get(Object key) {
        return this.valueOrNull(this.getValue(key));
    }

    public long getValue(K key) {
        long value;
        Objects.requireNonNull(key);
        long missingValue = this.missingValue;
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int mask = values2.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (value = values2[index]) && !Objects.equals(keys2[index], key)) {
            ++index;
            index &= mask;
        }
        return value;
    }

    public long computeIfAbsent(K key, ToLongFunction<? super K> mappingFunction) {
        long value;
        Objects.requireNonNull(key);
        long missingValue = this.missingValue;
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int mask = values2.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (value = values2[index])) {
            if (Objects.equals(keys2[index], key)) {
                return value;
            }
            ++index;
            index &= mask;
        }
        long newValue = mappingFunction.applyAsLong(key);
        if (missingValue != newValue) {
            keys2[index] = key;
            values2[index] = newValue;
            if (++this.size > this.resizeThreshold) {
                this.increaseCapacity();
            }
        }
        return newValue;
    }

    public long computeIfPresent(K key, ObjectLongToLongFunction<? super K> remappingFunction) {
        long value;
        Objects.requireNonNull(key);
        long missingValue = this.missingValue;
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int mask = values2.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (value = values2[index])) {
            if (Objects.equals(keys2[index], key)) {
                long newValue;
                values2[index] = newValue = remappingFunction.apply(key, value);
                if (missingValue == newValue) {
                    keys2[index] = null;
                    --this.size;
                    this.compactChain(index);
                }
                return newValue;
            }
            ++index;
            index &= mask;
        }
        return missingValue;
    }

    public long compute(K key, ObjectLongToLongFunction<? super K> remappingFunction) {
        long oldValue;
        Objects.requireNonNull(key);
        long missingValue = this.missingValue;
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int mask = values2.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (oldValue = values2[index]) && !Objects.equals(keys2[index], key)) {
            ++index;
            index &= mask;
        }
        long newValue = remappingFunction.apply(key, oldValue);
        if (missingValue != newValue) {
            values2[index] = newValue;
            if (missingValue == oldValue) {
                keys2[index] = key;
                if (++this.size > this.resizeThreshold) {
                    this.increaseCapacity();
                }
            }
        } else if (missingValue != oldValue) {
            keys2[index] = null;
            values2[index] = missingValue;
            --this.size;
            this.compactChain(index);
        }
        return newValue;
    }

    public long merge(K key, long value, LongLongFunction remappingFunction) {
        long newValue;
        long oldValue;
        Objects.requireNonNull(key);
        Objects.requireNonNull(remappingFunction);
        long missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int mask = values2.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (oldValue = values2[index]) && !Objects.equals(keys2[index], key)) {
            ++index;
            index &= mask;
        }
        long l = newValue = missingValue == oldValue ? value : remappingFunction.apply(oldValue, value);
        if (missingValue != newValue) {
            keys2[index] = key;
            values2[index] = newValue;
            if (++this.size > this.resizeThreshold) {
                this.increaseCapacity();
            }
        } else {
            keys2[index] = null;
            values2[index] = missingValue;
            --this.size;
            this.compactChain(index);
        }
        return newValue;
    }

    @Override
    public Long put(K key, Long value) {
        return this.valueOrNull(this.put(key, (long)value));
    }

    @Override
    public long put(K key, long value) {
        long oldValue;
        Objects.requireNonNull(key);
        long missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int mask = values2.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (oldValue = values2[index]) && !Objects.equals(keys2[index], key)) {
            ++index;
            index &= mask;
        }
        if (missingValue == oldValue) {
            ++this.size;
            keys2[index] = key;
        }
        values2[index] = value;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return oldValue;
    }

    @Override
    public Long putIfAbsent(K key, Long value) {
        return this.valueOrNull(this.putIfAbsent(key, (long)value));
    }

    @Override
    public long putIfAbsent(K key, long value) {
        long oldValue;
        Objects.requireNonNull(key);
        long missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int mask = values2.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (oldValue = values2[index])) {
            if (Objects.equals(keys2[index], key)) {
                return oldValue;
            }
            ++index;
            index &= mask;
        }
        keys2[index] = key;
        values2[index] = value;
        if (++this.size > this.resizeThreshold) {
            this.increaseCapacity();
        }
        return missingValue;
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove(key, (Long)value);
    }

    public boolean remove(Object key, long value) {
        long existingValue;
        long missingValue = this.missingValue;
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int mask = values2.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (existingValue = values2[index])) {
            if (Objects.equals(keys2[index], key)) {
                if (value != existingValue) break;
                keys2[index] = null;
                values2[index] = missingValue;
                --this.size;
                this.compactChain(index);
                return true;
            }
            ++index;
            index &= mask;
        }
        return false;
    }

    @Override
    public Long remove(Object key) {
        return this.valueOrNull(this.removeKey(key));
    }

    public long removeKey(K key) {
        long value;
        Objects.requireNonNull(key);
        long missingValue = this.missingValue;
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int mask = values2.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (value = values2[index])) {
            if (Objects.equals(keys2[index], key)) {
                keys2[index] = null;
                values2[index] = missingValue;
                --this.size;
                this.compactChain(index);
                break;
            }
            ++index;
            index &= mask;
        }
        return value;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.keys, null);
            Arrays.fill(this.values, this.missingValue);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    @Override
    public void putAll(Map<? extends K, ? extends Long> map) {
        for (Map.Entry<K, Long> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Object2LongHashMap<? extends K> map) {
        long missingValue = map.missingValue;
        K[] keys2 = map.keys;
        long[] values2 = map.values;
        int length = values2.length;
        int remaining = map.size;
        for (int index = 0; remaining > 0 && index < length; ++index) {
            long value = values2[index];
            if (missingValue == value) continue;
            this.put(keys2[index], value);
            --remaining;
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getKey()).append('=').append(entryIterator.getLongValue());
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        long missingValue = this.missingValue;
        long thatMissingValue = o instanceof Object2LongHashMap ? ((Object2LongHashMap)o).missingValue : missingValue;
        int length = values2.length;
        for (int i = 0; i < length; ++i) {
            long thisValue = values2[i];
            if (missingValue == thisValue) continue;
            Object thatValueObject = that.get(keys2[i]);
            if (!(thatValueObject instanceof Long)) {
                return false;
            }
            long thatValue = (Long)thatValueObject;
            if (thatMissingValue != thatValue && thisValue == thatValue) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int length = values2.length;
        for (int i = 0; i < length; ++i) {
            long value = values2[i];
            if (this.missingValue == value) continue;
            result += keys2[i].hashCode() ^ Long.hashCode(value);
        }
        return result;
    }

    @Override
    public long replace(K key, long value) {
        long existingValue;
        Objects.requireNonNull(key);
        long missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int mask = values2.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (existingValue = values2[index])) {
            if (Objects.equals(keys2[index], key)) {
                values2[index] = value;
                return existingValue;
            }
            ++index;
            index &= mask;
        }
        return missingValue;
    }

    @Override
    public boolean replace(K key, long oldValue, long newValue) {
        long existingValue;
        Objects.requireNonNull(key);
        long missingValue = this.missingValue;
        if (missingValue == newValue) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int mask = values2.length - 1;
        int index = Hashing.hash(key, mask);
        while (missingValue != (existingValue = values2[index])) {
            if (Objects.equals(keys2[index], key)) {
                if (oldValue != existingValue) break;
                values2[index] = newValue;
                return true;
            }
            ++index;
            index &= mask;
        }
        return false;
    }

    public void replaceAllLong(ObjectLongToLongFunction<? super K> function) {
        Objects.requireNonNull(function);
        long missingValue = this.missingValue;
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int length = values2.length;
        int remaining = this.size;
        for (int index = 0; remaining > 0 && index < length; ++index) {
            long oldValue = values2[index];
            if (missingValue == oldValue) continue;
            long newVal = function.apply(keys2[index], oldValue);
            if (missingValue == newVal) {
                throw new IllegalArgumentException("cannot accept missingValue");
            }
            values2[index] = newVal;
            --remaining;
        }
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super Long> action) {
        this.forEachLong(action::accept);
    }

    public void forEachLong(ObjLongConsumer<? super K> action) {
        Objects.requireNonNull(action);
        long missingValue = this.missingValue;
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int length = values2.length;
        int remaining = this.size;
        for (int index = 0; remaining > 0 && index < length; ++index) {
            long oldValue = values2[index];
            if (missingValue == oldValue) continue;
            action.accept(keys2[index], oldValue);
            --remaining;
        }
    }

    private void increaseCapacity() {
        int newCapacity = this.values.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int mask = newCapacity - 1;
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        Object[] tempKeys = new Object[newCapacity];
        long[] tempValues = new long[newCapacity];
        Arrays.fill(tempValues, this.missingValue);
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int size = values2.length;
        for (int i = 0; i < size; ++i) {
            long value = values2[i];
            if (this.missingValue == value) continue;
            K key = keys2[i];
            int index = Hashing.hash(key, mask);
            while (this.missingValue != tempValues[index]) {
                ++index;
                index &= mask;
            }
            tempKeys[index] = key;
            tempValues[index] = value;
        }
        this.keys = tempKeys;
        this.values = tempValues;
    }

    private void compactChain(int deleteIndex) {
        K[] keys2 = this.keys;
        long[] values2 = this.values;
        int mask = values2.length - 1;
        int index = deleteIndex;
        while (true) {
            ++index;
            long value = values2[index &= mask];
            if (this.missingValue == value) break;
            K key = keys2[index];
            int hash = Hashing.hash(key, mask);
            if ((index >= hash || hash > deleteIndex && deleteIndex > index) && (hash > deleteIndex || deleteIndex > index)) continue;
            keys2[deleteIndex] = key;
            values2[deleteIndex] = value;
            keys2[index] = null;
            values2[index] = this.missingValue;
            deleteIndex = index;
        }
    }

    private Long valueOrNull(long value) {
        return value == this.missingValue ? null : Long.valueOf(value);
    }

    public final class EntryIterator
    extends AbstractIterator<Map.Entry<K, Long>>
    implements Map.Entry<K, Long> {
        @Override
        public Map.Entry<K, Long> next() {
            this.findNext();
            if (Object2LongHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<K, Long> allocateDuplicateEntry() {
            return new MapEntry(this.getKey(), this.getLongValue());
        }

        @Override
        public K getKey() {
            return Object2LongHashMap.this.keys[this.position()];
        }

        public long getLongValue() {
            return Object2LongHashMap.this.values[this.position()];
        }

        @Override
        public Long getValue() {
            return this.getLongValue();
        }

        @Override
        public Long setValue(Long value) {
            return this.setValue((long)value);
        }

        @Override
        public long setValue(long value) {
            if (Object2LongHashMap.this.missingValue == value) {
                throw new IllegalArgumentException("cannot accept missingValue");
            }
            int pos = this.position();
            long oldValue = Object2LongHashMap.this.values[pos];
            ((Object2LongHashMap)Object2LongHashMap.this).values[pos] = value;
            return oldValue;
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ Long.hashCode(this.getLongValue());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Objects.equals(this.getKey(), e.getKey()) && e.getValue() instanceof Long && this.getLongValue() == ((Long)e.getValue()).longValue();
        }

        public final class MapEntry
        implements Map.Entry<K, Long> {
            private final K k;
            private long v;

            public MapEntry(K k, long v) {
                this.k = k;
                this.v = v;
            }

            @Override
            public K getKey() {
                return this.k;
            }

            @Override
            public Long getValue() {
                return this.v;
            }

            @Override
            public Long setValue(Long value) {
                Long oldValue = Object2LongHashMap.this.put(this.k, value);
                this.v = value;
                return oldValue;
            }

            @Override
            public int hashCode() {
                return this.getKey().hashCode() ^ Long.hashCode(this.v);
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return Objects.equals(this.getKey(), e.getKey()) && e.getValue() instanceof Long && this.v == (Long)e.getValue();
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class KeyIterator
    extends AbstractIterator<K> {
        @Override
        public K next() {
            this.findNext();
            return Object2LongHashMap.this.keys[this.position()];
        }
    }

    public final class ValueIterator
    extends AbstractIterator<Long> {
        @Override
        public Long next() {
            return this.nextLong();
        }

        public long nextLong() {
            this.findNext();
            return Object2LongHashMap.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        private int posCounter;
        private int stopCounter;
        private int remaining;
        private boolean isPositionValid = false;

        AbstractIterator() {
        }

        protected final int position() {
            return this.posCounter & Object2LongHashMap.this.values.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long missingValue = Object2LongHashMap.this.missingValue;
            long[] values2 = Object2LongHashMap.this.values;
            int mask = values2.length - 1;
            for (int i = this.posCounter - 1; i >= this.stopCounter; --i) {
                int index = i & mask;
                if (missingValue == values2[index]) continue;
                this.posCounter = i;
                this.isPositionValid = true;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.position();
            ((Object2LongHashMap)Object2LongHashMap.this).values[position] = Object2LongHashMap.this.missingValue;
            ((Object2LongHashMap)Object2LongHashMap.this).keys[position] = null;
            --Object2LongHashMap.this.size;
            Object2LongHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }

        final void reset() {
            int capacity;
            this.remaining = Object2LongHashMap.this.size;
            long[] values2 = Object2LongHashMap.this.values;
            int i = capacity = values2.length;
            if (Object2LongHashMap.this.missingValue != values2[capacity - 1]) {
                for (i = 0; i < capacity && Object2LongHashMap.this.missingValue != values2[i]; ++i) {
                }
            }
            this.stopCounter = i;
            this.posCounter = i + capacity;
            this.isPositionValid = false;
        }
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<K, Long>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Object2LongHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Object2LongHashMap.this.size();
        }

        @Override
        public void clear() {
            Object2LongHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Long value = Object2LongHashMap.this.get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }

        public boolean removeIfLong(ObjLongPredicate<? super K> filter) {
            boolean removed = false;
            EntryIterator iterator2 = this.iterator();
            while (iterator2.hasNext()) {
                iterator2.findNext();
                if (!filter.test(iterator2.getKey(), iterator2.getLongValue())) continue;
                iterator2.remove();
                removed = true;
            }
            return removed;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = a.length >= Object2LongHashMap.this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), Object2LongHashMap.this.size);
            EntryIterator it = this.iterator();
            for (int i = 0; i < array.length; ++i) {
                if (!it.hasNext()) {
                    array[i] = null;
                    break;
                }
                it.next();
                array[i] = it.allocateDuplicateEntry();
            }
            return array;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Long> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Object2LongHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Object2LongHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Object2LongHashMap.this.containsValue(o);
        }

        public boolean contains(long value) {
            return Object2LongHashMap.this.containsValue(value);
        }

        @Override
        public void clear() {
            Object2LongHashMap.this.clear();
        }

        public boolean removeIfLong(LongPredicate filter) {
            boolean removed = false;
            ValueIterator iterator2 = this.iterator();
            while (iterator2.hasNext()) {
                if (!filter.test(iterator2.nextLong())) continue;
                iterator2.remove();
                removed = true;
            }
            return removed;
        }
    }

    public final class KeySet
    extends AbstractSet<K> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Object2LongHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Object2LongHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Object2LongHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return Object2LongHashMap.this.missingValue != Object2LongHashMap.this.removeKey(o);
        }

        @Override
        public void clear() {
            Object2LongHashMap.this.clear();
        }
    }
}

