/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.nio.channels.ClosedByInterruptException;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;

public class AgentRunner
implements Runnable,
AutoCloseable {
    public static final Thread TOMBSTONE = new Thread();
    public static final int RETRY_CLOSE_TIMEOUT_MS = 5000;
    private volatile boolean isRunning = true;
    private volatile boolean isClosed = false;
    private final AtomicCounter errorCounter;
    private final ErrorHandler errorHandler;
    private final IdleStrategy idleStrategy;
    private final Agent agent;
    private final AtomicReference<Thread> thread = new AtomicReference();

    public AgentRunner(IdleStrategy idleStrategy, ErrorHandler errorHandler, AtomicCounter errorCounter, Agent agent) {
        Objects.requireNonNull(idleStrategy, "idleStrategy");
        Objects.requireNonNull(errorHandler, "errorHandler");
        Objects.requireNonNull(agent, "agent");
        this.idleStrategy = idleStrategy;
        this.errorHandler = errorHandler;
        this.errorCounter = errorCounter;
        this.agent = agent;
    }

    public static Thread startOnThread(AgentRunner runner) {
        return AgentRunner.startOnThread(runner, Thread::new);
    }

    public static Thread startOnThread(AgentRunner runner, ThreadFactory threadFactory) {
        Thread thread2 = threadFactory.newThread(runner);
        thread2.setName(runner.agent().roleName());
        thread2.start();
        return thread2;
    }

    public Agent agent() {
        return this.agent;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Thread thread() {
        return this.thread.get();
    }

    @Override
    public void run() {
        block8: {
            try {
                block9: {
                    if (!this.thread.compareAndSet(null, Thread.currentThread())) break block8;
                    try {
                        this.agent.onStart();
                    }
                    catch (Throwable t2) {
                        this.isRunning = false;
                        this.errorHandler.onError(t2);
                        if (!(t2 instanceof Error)) break block9;
                        throw (Error)t2;
                    }
                }
                this.workLoop(this.idleStrategy, this.agent);
                try {
                    this.agent.onClose();
                }
                catch (Throwable t3) {
                    this.errorHandler.onError(t3);
                    if (t3 instanceof Error) {
                        throw (Error)t3;
                    }
                }
            }
            finally {
                this.isClosed = true;
            }
        }
    }

    @Override
    public final void close() {
        this.close(5000, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void close(int retryCloseTimeoutMs, Consumer<Thread> closeFailAction) {
        this.isRunning = false;
        Thread thread2 = this.thread.getAndSet(TOMBSTONE);
        if (null == thread2) {
            try {
                this.agent.onClose();
                return;
            }
            catch (Throwable t2) {
                this.errorHandler.onError(t2);
                if (!(t2 instanceof Error)) return;
                throw (Error)t2;
            }
            finally {
                this.isClosed = true;
            }
        } else {
            if (TOMBSTONE == thread2) return;
            try {
                while (true) {
                    if (this.isClosed) {
                        return;
                    }
                    thread2.join(retryCloseTimeoutMs);
                    if (!thread2.isAlive() || this.isClosed) {
                        return;
                    }
                    this.failAction(closeFailAction, thread2, "timeout, retrying...");
                    if (thread2.isInterrupted()) continue;
                    thread2.interrupt();
                }
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
                this.failAction(closeFailAction, thread2, "thread interrupt");
                if (this.isClosed || thread2.isInterrupted()) return;
                thread2.interrupt();
                Thread.yield();
                return;
            }
        }
    }

    private void failAction(Consumer<Thread> closeFailAction, Thread thread2, String message) {
        if (null == closeFailAction) {
            System.err.println(this.agent.roleName() + " failed to close due to " + message);
        } else {
            closeFailAction.accept(thread2);
        }
    }

    private void workLoop(IdleStrategy idleStrategy, Agent agent) {
        while (this.isRunning) {
            this.doWork(idleStrategy, agent);
        }
    }

    private void doWork(IdleStrategy idleStrategy, Agent agent) {
        block7: {
            try {
                int workCount = agent.doWork();
                idleStrategy.idle(workCount);
                if (workCount <= 0 && Thread.currentThread().isInterrupted()) {
                    this.isRunning = false;
                }
            }
            catch (InterruptedException | ClosedByInterruptException ignore) {
                this.isRunning = false;
                Thread.currentThread().interrupt();
            }
            catch (AgentTerminationException ex) {
                this.isRunning = false;
                this.handleError(ex);
            }
            catch (Throwable t2) {
                if (Thread.currentThread().isInterrupted()) {
                    this.isRunning = false;
                }
                this.handleError(t2);
                if (this.isRunning && Thread.currentThread().isInterrupted()) {
                    this.isRunning = false;
                }
                if (!(t2 instanceof Error)) break block7;
                throw (Error)t2;
            }
        }
    }

    private void handleError(Throwable throwable) {
        if (null != this.errorCounter && this.isRunning && !this.errorCounter.isClosed()) {
            this.errorCounter.increment();
        }
        this.errorHandler.onError(throwable);
    }
}

