/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.checker;

import com.google.api.expr.v1alpha1.CheckedExpr;
import com.google.api.expr.v1alpha1.Constant;
import com.google.api.expr.v1alpha1.Decl;
import com.google.api.expr.v1alpha1.Expr;
import com.google.api.expr.v1alpha1.Reference;
import com.google.api.expr.v1alpha1.SourceInfo;
import com.google.api.expr.v1alpha1.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.projectnessie.cel.checker.CheckerEnv;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.checker.Mapping;
import org.projectnessie.cel.checker.Standard;
import org.projectnessie.cel.checker.TypeErrors;
import org.projectnessie.cel.checker.Types;
import org.projectnessie.cel.common.Location;
import org.projectnessie.cel.common.Source;
import org.projectnessie.cel.common.containers.Container;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.ref.FieldType;
import org.projectnessie.cel.parser.Parser;

public final class Checker {
    public static final List<Decl> StandardDeclarations = Standard.makeStandardDeclarations();
    private CheckerEnv env;
    private final TypeErrors errors;
    private Mapping mappings;
    private int freeTypeVarCounter;
    private final SourceInfo sourceInfo;
    private final Map<Long, Type> types = new HashMap<Long, Type>();
    private final Map<Long, Reference> references = new HashMap<Long, Reference>();

    private Checker(CheckerEnv env, TypeErrors errors, Mapping mappings, int freeTypeVarCounter, SourceInfo sourceInfo) {
        this.env = env;
        this.errors = errors;
        this.mappings = mappings;
        this.freeTypeVarCounter = freeTypeVarCounter;
        this.sourceInfo = sourceInfo;
    }

    public static CheckResult Check(Parser.ParseResult parsedExpr, Source source2, CheckerEnv env) {
        TypeErrors errors = new TypeErrors(source2);
        Checker c = new Checker(env, errors, Mapping.newMapping(), 0, parsedExpr.getSourceInfo());
        Expr.Builder b = parsedExpr.getExpr().toBuilder();
        c.check(b);
        Expr e = b.build();
        HashMap<Long, Type> m4 = new HashMap<Long, Type>();
        c.types.forEach((k, v) -> m4.put((Long)k, Types.substitute(c.mappings, v, true)));
        CheckedExpr checkedExpr = CheckedExpr.newBuilder().setExpr(e).setSourceInfo(parsedExpr.getSourceInfo()).putAllTypeMap(m4).putAllReferenceMap(c.references).build();
        return new CheckResult(checkedExpr, errors);
    }

    void check(Expr.Builder e) {
        switch (e.getExprKindCase()) {
            case CONST_EXPR: {
                Constant literal = e.getConstExpr();
                switch (literal.getConstantKindCase()) {
                    case BOOL_VALUE: {
                        this.checkBoolLiteral(e);
                        return;
                    }
                    case BYTES_VALUE: {
                        this.checkBytesLiteral(e);
                        return;
                    }
                    case DOUBLE_VALUE: {
                        this.checkDoubleLiteral(e);
                        return;
                    }
                    case INT64_VALUE: {
                        this.checkInt64Literal(e);
                        return;
                    }
                    case NULL_VALUE: {
                        this.checkNullLiteral(e);
                        return;
                    }
                    case STRING_VALUE: {
                        this.checkStringLiteral(e);
                        return;
                    }
                    case UINT64_VALUE: {
                        this.checkUint64Literal(e);
                        return;
                    }
                }
                throw new IllegalArgumentException(String.format("Unrecognized ast type: %s", e.getClass().getName()));
            }
            case IDENT_EXPR: {
                this.checkIdent(e);
                return;
            }
            case SELECT_EXPR: {
                this.checkSelect(e);
                return;
            }
            case CALL_EXPR: {
                this.checkCall(e);
                return;
            }
            case LIST_EXPR: {
                this.checkCreateList(e);
                return;
            }
            case STRUCT_EXPR: {
                this.checkCreateStruct(e);
                return;
            }
            case COMPREHENSION_EXPR: {
                this.checkComprehension(e);
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized ast type: %s", e.getClass().getName()));
    }

    void checkInt64Literal(Expr.Builder e) {
        this.setType(e, Decls.Int);
    }

    void checkUint64Literal(Expr.Builder e) {
        this.setType(e, Decls.Uint);
    }

    void checkStringLiteral(Expr.Builder e) {
        this.setType(e, Decls.String);
    }

    void checkBytesLiteral(Expr.Builder e) {
        this.setType(e, Decls.Bytes);
    }

    void checkDoubleLiteral(Expr.Builder e) {
        this.setType(e, Decls.Double);
    }

    void checkBoolLiteral(Expr.Builder e) {
        this.setType(e, Decls.Bool);
    }

    void checkNullLiteral(Expr.Builder e) {
        this.setType(e, Decls.Null);
    }

    void checkIdent(Expr.Builder e) {
        Expr.Ident.Builder identExpr = e.getIdentExprBuilder();
        Decl ident = this.env.lookupIdent(identExpr.getName());
        if (ident != null) {
            this.setType(e, ident.getIdent().getType());
            this.setReference(e, Checker.newIdentReference(ident.getName(), ident.getIdent().getValue()));
            identExpr.setName(ident.getName());
            return;
        }
        this.setType(e, Decls.Error);
        this.errors.undeclaredReference(this.location(e), this.env.container.name(), identExpr.getName());
    }

    void checkSelect(Expr.Builder e) {
        Decl ident;
        Expr.Select.Builder sel = e.getSelectExprBuilder();
        String qname2 = Container.toQualifiedName(e.build());
        if (qname2 != null && (ident = this.env.lookupIdent(qname2)) != null) {
            if (sel.getTestOnly()) {
                this.errors.expressionDoesNotSelectField(this.location(e));
                this.setType(e, Decls.Bool);
                return;
            }
            this.setType(e, ident.getIdent().getType());
            this.setReference(e, Checker.newIdentReference(ident.getName(), ident.getIdent().getValue()));
            String identName = ident.getName();
            e.getIdentExprBuilder().setName(identName);
            return;
        }
        this.check(sel.getOperandBuilder());
        Type targetType = this.getType(sel.getOperandBuilder());
        Type resultType = Decls.Error;
        switch (Types.kindOf(targetType)) {
            case kindMap: {
                Type.MapType mapType = targetType.getMapType();
                resultType = mapType.getValueType();
                break;
            }
            case kindObject: {
                FieldType fieldType = this.lookupFieldType(this.location(e), targetType.getMessageType(), sel.getField());
                if (fieldType == null) break;
                resultType = fieldType.type;
                break;
            }
            case kindTypeParam: {
                this.isAssignable(Decls.Dyn, targetType);
                resultType = Decls.Dyn;
                break;
            }
            default: {
                if (Types.isDynOrError(targetType)) {
                    resultType = Decls.Dyn;
                    break;
                }
                this.errors.typeDoesNotSupportFieldSelection(this.location(e), targetType);
            }
        }
        if (sel.getTestOnly()) {
            resultType = Decls.Bool;
        }
        this.setType(e, resultType);
    }

    void checkCall(Expr.Builder e) {
        String maybeQualifiedName;
        Decl fn;
        Expr.Call.Builder call = e.getCallExprBuilder();
        List<Expr.Builder> args = call.getArgsBuilderList();
        String fnName = call.getFunction();
        for (Expr.Builder arg : args) {
            this.check(arg);
        }
        if (call.getTarget() == Expr.getDefaultInstance()) {
            Decl fn2 = this.env.lookupFunction(fnName);
            if (fn2 == null) {
                this.errors.undeclaredReference(this.location(e), this.env.container.name(), fnName);
                this.setType(e, Decls.Error);
                return;
            }
            call.setFunction(fn2.getName());
            this.resolveOverloadOrError(this.location(e), e, fn2, null, args);
            return;
        }
        Expr.Builder target = call.getTargetBuilder();
        String qualifiedPrefix = Container.toQualifiedName(target.build());
        if (qualifiedPrefix != null && (fn = this.env.lookupFunction(maybeQualifiedName = qualifiedPrefix + "." + fnName)) != null) {
            call.clearTarget().setFunction(fn.getName());
            this.resolveOverloadOrError(this.location(e), e, fn, null, args);
            return;
        }
        this.check(target);
        Decl fn3 = this.env.lookupFunction(fnName);
        if (fn3 != null) {
            this.resolveOverloadOrError(this.location(e), e, fn3, target, args);
            return;
        }
        this.errors.undeclaredReference(this.location(e), this.env.container.name(), fnName);
    }

    void resolveOverloadOrError(Location loc, Expr.Builder e, Decl fn, Expr.Builder target, List<Expr.Builder> args) {
        OverloadResolution resolution = this.resolveOverload(loc, fn, target, args);
        if (resolution == null) {
            this.setType(e, Decls.Error);
            return;
        }
        this.setType(e, resolution.type);
        this.setReference(e, resolution.reference);
    }

    OverloadResolution resolveOverload(Location loc, Decl fn, Expr.Builder target, List<Expr.Builder> args) {
        ArrayList<Type> argTypes = new ArrayList<Type>();
        if (target != null) {
            Type argType = this.getType(target);
            if (argType == null) {
                throw new Err.ErrException("Could not resolve type for target '%s'", target);
            }
            argTypes.add(argType);
        }
        for (int i = 0; i < args.size(); ++i) {
            Expr.Builder arg = args.get(i);
            Type argType = this.getType(arg);
            if (argType == null) {
                throw new Err.ErrException("Could not resolve type for argument %d '%s'", i, arg);
            }
            argTypes.add(argType);
        }
        Type resultType = null;
        Reference checkedRef = null;
        for (Decl.FunctionDecl.Overload overload : fn.getFunction().getOverloadsList()) {
            List<Type> candidateArgTypes;
            if (target == null && overload.getIsInstanceFunction() || target != null && !overload.getIsInstanceFunction()) continue;
            Type overloadType = Decls.newFunctionType(overload.getResultType(), overload.getParamsList());
            if (overload.getTypeParamsCount() > 0) {
                Mapping substitutions = Mapping.newMapping();
                for (String typePar : overload.getTypeParamsList()) {
                    substitutions.add(Decls.newTypeParamType(typePar), this.newTypeVar());
                }
                overloadType = Types.substitute(substitutions, overloadType, false);
            }
            if (!this.isAssignableList(argTypes, candidateArgTypes = overloadType.getFunction().getArgTypesList())) continue;
            checkedRef = checkedRef == null ? Checker.newFunctionReference(Collections.singletonList(overload.getOverloadId())) : checkedRef.toBuilder().addOverloadId(overload.getOverloadId()).build();
            Type fnResultType = Types.substitute(this.mappings, overloadType.getFunction().getResultType(), false);
            if (resultType == null) {
                resultType = fnResultType;
                continue;
            }
            if (Types.isDyn(resultType) || fnResultType.equals(resultType)) continue;
            resultType = Decls.Dyn;
        }
        if (resultType == null) {
            this.errors.noMatchingOverload(loc, fn.getName(), argTypes, target != null);
            return null;
        }
        return Checker.newResolution(checkedRef, resultType);
    }

    void checkCreateList(Expr.Builder e) {
        Expr.CreateList.Builder create = e.getListExprBuilder();
        Type elemType = null;
        for (int i = 0; i < create.getElementsBuilderList().size(); ++i) {
            Expr.Builder el = create.getElementsBuilderList().get(i);
            this.check(el);
            elemType = this.joinTypes(this.location(el), elemType, this.getType(el));
        }
        if (elemType == null) {
            elemType = this.newTypeVar();
        }
        this.setType(e, Decls.newListType(elemType));
    }

    void checkCreateStruct(Expr.Builder e) {
        Expr.CreateStruct.Builder str = e.getStructExprBuilder();
        if (!str.getMessageName().isEmpty()) {
            this.checkCreateMessage(e);
        } else {
            this.checkCreateMap(e);
        }
    }

    void checkCreateMap(Expr.Builder e) {
        Expr.CreateStruct.Builder mapVal = e.getStructExprBuilder();
        Type keyType = null;
        Type valueType = null;
        for (Expr.CreateStruct.Entry.Builder ent : mapVal.getEntriesBuilderList()) {
            Expr.Builder key = ent.getMapKeyBuilder();
            this.check(key);
            keyType = this.joinTypes(this.location(key), keyType, this.getType(key));
            Expr.Builder val = ent.getValueBuilder();
            this.check(val);
            valueType = this.joinTypes(this.location(val), valueType, this.getType(val));
        }
        if (keyType == null) {
            keyType = this.newTypeVar();
            valueType = this.newTypeVar();
        }
        this.setType(e, Decls.newMapType(keyType, valueType));
    }

    void checkCreateMessage(Expr.Builder e) {
        Expr.CreateStruct.Builder msgVal = e.getStructExprBuilder();
        Type messageType = Decls.Error;
        Decl decl = this.env.lookupIdent(msgVal.getMessageName());
        if (decl == null) {
            this.errors.undeclaredReference(this.location(e), this.env.container.name(), msgVal.getMessageName());
            return;
        }
        msgVal.setMessageName(decl.getName());
        this.setReference(e, Checker.newIdentReference(decl.getName(), null));
        Decl.IdentDecl ident = decl.getIdent();
        Types.Kind identKind = Types.kindOf(ident.getType());
        if (identKind != Types.Kind.kindError) {
            if (identKind != Types.Kind.kindType) {
                this.errors.notAType(this.location(e), ident.getType());
            } else {
                messageType = ident.getType().getType();
                if (Types.kindOf(messageType) != Types.Kind.kindObject) {
                    this.errors.notAMessageType(this.location(e), messageType);
                    messageType = Decls.Error;
                }
            }
        }
        if (CheckerEnv.isObjectWellKnownType(messageType)) {
            this.setType(e, CheckerEnv.getObjectWellKnownType(messageType));
        } else {
            this.setType(e, messageType);
        }
        for (Expr.CreateStruct.Entry.Builder ent : msgVal.getEntriesBuilderList()) {
            String field = ent.getFieldKey();
            Expr.Builder value = ent.getValueBuilder();
            this.check(value);
            Type fieldType = Decls.Error;
            FieldType t2 = this.lookupFieldType(this.locationByID(ent.getId()), messageType.getMessageType(), field);
            if (t2 != null) {
                fieldType = t2.type;
            }
            if (this.isAssignable(fieldType, this.getType(value))) continue;
            this.errors.fieldTypeMismatch(this.locationByID(ent.getId()), field, fieldType, this.getType(value));
        }
    }

    void checkComprehension(Expr.Builder e) {
        Type varType;
        Expr.Comprehension.Builder comp = e.getComprehensionExprBuilder();
        this.check(comp.getIterRangeBuilder());
        this.check(comp.getAccuInitBuilder());
        Type accuType = this.getType(comp.getAccuInitBuilder());
        Type rangeType = this.getType(comp.getIterRangeBuilder());
        switch (Types.kindOf(rangeType)) {
            case kindList: {
                varType = rangeType.getListType().getElemType();
                break;
            }
            case kindMap: {
                varType = rangeType.getMapType().getKeyType();
                break;
            }
            case kindTypeParam: 
            case kindDyn: 
            case kindError: {
                this.isAssignable(Decls.Dyn, rangeType);
                varType = Decls.Dyn;
                break;
            }
            default: {
                this.errors.notAComprehensionRange(this.location(comp.getIterRangeBuilder()), rangeType);
                varType = Decls.Error;
            }
        }
        this.env = this.env.enterScope();
        this.env.add(Decls.newVar(comp.getAccuVar(), accuType));
        this.env = this.env.enterScope();
        this.env.add(Decls.newVar(comp.getIterVar(), varType));
        this.check(comp.getLoopConditionBuilder());
        this.assertType(comp.getLoopConditionBuilder(), Decls.Bool);
        this.check(comp.getLoopStepBuilder());
        this.assertType(comp.getLoopStepBuilder(), accuType);
        this.env = this.env.exitScope();
        this.check(comp.getResultBuilder());
        this.env = this.env.exitScope();
        this.setType(e, this.getType(comp.getResultBuilder()));
    }

    Type joinTypes(Location loc, Type previous, Type current) {
        if (previous == null) {
            return current;
        }
        if (this.isAssignable(previous, current)) {
            return Types.mostGeneral(previous, current);
        }
        if (this.dynAggregateLiteralElementTypesEnabled()) {
            return Decls.Dyn;
        }
        this.errors.typeMismatch(loc, previous, current);
        return Decls.Error;
    }

    boolean dynAggregateLiteralElementTypesEnabled() {
        return this.env.aggLitElemType == 0;
    }

    Type newTypeVar() {
        int id = this.freeTypeVarCounter++;
        return Decls.newTypeParamType(String.format("_var%d", id));
    }

    boolean isAssignable(Type t1, Type t2) {
        Mapping subs = Types.isAssignable(this.mappings, t1, t2);
        if (subs != null) {
            this.mappings = subs;
            return true;
        }
        return false;
    }

    boolean isAssignableList(List<Type> l1, List<Type> l2) {
        Mapping subs = Types.isAssignableList(this.mappings, l1, l2);
        if (subs != null) {
            this.mappings = subs;
            return true;
        }
        return false;
    }

    FieldType lookupFieldType(Location l, String messageType, String fieldName) {
        if (this.env.provider.findType(messageType) == null) {
            this.errors.unexpectedFailedResolution(l, messageType);
            return null;
        }
        FieldType ft = this.env.provider.findFieldType(messageType, fieldName);
        if (ft != null) {
            return ft;
        }
        this.errors.undefinedField(l, fieldName);
        return null;
    }

    void setType(Expr.Builder e, Type t2) {
        Type old = this.types.get(e.getId());
        if (old != null && !old.equals(t2)) {
            throw new IllegalStateException(String.format("(Incompatible) Type already exists for expression: %s(%d) old:%s, new:%s", e, e.getId(), old, t2));
        }
        this.types.put(e.getId(), t2);
    }

    Type getType(Expr.Builder e) {
        return this.types.get(e.getId());
    }

    void setReference(Expr.Builder e, Reference r) {
        Reference old = this.references.get(e.getId());
        if (old != null && !old.equals(r)) {
            throw new IllegalStateException(String.format("Reference already exists for expression: %s(%d) old:%s, new:%s", e, e.getId(), old, r));
        }
        this.references.put(e.getId(), r);
    }

    void assertType(Expr.Builder e, Type t2) {
        if (!this.isAssignable(t2, this.getType(e))) {
            this.errors.typeMismatch(this.location(e), t2, this.getType(e));
        }
    }

    static OverloadResolution newResolution(Reference checkedRef, Type t2) {
        return new OverloadResolution(checkedRef, t2);
    }

    Location location(Expr.Builder e) {
        return this.locationByID(e.getId());
    }

    Location locationByID(long id) {
        Map<Long, Integer> positions = this.sourceInfo.getPositionsMap();
        int line = 1;
        Integer offset = positions.get(id);
        if (offset != null) {
            int col = offset;
            for (Integer lineOffset : this.sourceInfo.getLineOffsetsList()) {
                if (lineOffset >= offset) break;
                ++line;
                col = offset - lineOffset;
            }
            return Location.newLocation(line, col);
        }
        return Location.NoLocation;
    }

    static Reference newIdentReference(String name, Constant value) {
        Reference.Builder refBuilder = Reference.newBuilder().setName(name);
        if (value != null && value.getConstantKindCase() != Constant.ConstantKindCase.CONSTANTKIND_NOT_SET) {
            refBuilder = refBuilder.setValue(value);
        }
        return refBuilder.build();
    }

    static Reference newFunctionReference(List<String> overloads) {
        return Reference.newBuilder().addAllOverloadId(overloads).build();
    }

    public static final class CheckResult {
        private final CheckedExpr expr;
        private final TypeErrors errors;

        private CheckResult(CheckedExpr expr, TypeErrors errors) {
            this.expr = expr;
            this.errors = errors;
        }

        public CheckedExpr getCheckedExpr() {
            return this.expr;
        }

        public TypeErrors getErrors() {
            return this.errors;
        }

        public boolean hasErrors() {
            return this.errors.hasErrors();
        }

        public String toString() {
            return "CheckResult{expr=" + this.expr + ", errors=" + this.errors + '}';
        }
    }

    static final class OverloadResolution {
        final Reference reference;
        final Type type;

        public OverloadResolution(Reference reference, Type type) {
            this.reference = reference;
            this.type = type;
        }
    }
}

