/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.checker;

import com.google.api.expr.v1alpha1.CheckedExpr;
import com.google.api.expr.v1alpha1.Expr;
import com.google.api.expr.v1alpha1.Reference;
import com.google.api.expr.v1alpha1.Type;
import org.projectnessie.cel.checker.Types;
import org.projectnessie.cel.common.debug.Debug;

public final class Printer {
    public static String print(Expr e, CheckedExpr checks) {
        SemanticAdorner a = new SemanticAdorner(checks);
        return Debug.toAdornedDebugString(e, a);
    }

    static final class SemanticAdorner
    implements Debug.Adorner {
        private final CheckedExpr checks;

        SemanticAdorner(CheckedExpr checks) {
            this.checks = checks;
        }

        @Override
        public String getMetadata(Object elem) {
            if (!(elem instanceof Expr)) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            Expr e = (Expr)elem;
            Type t2 = this.checks.getTypeMapMap().get(e.getId());
            if (t2 != null) {
                result.append("~");
                result.append(Types.formatCheckedType(t2));
            }
            switch (e.getExprKindCase()) {
                case IDENT_EXPR: 
                case CALL_EXPR: 
                case STRUCT_EXPR: 
                case SELECT_EXPR: {
                    Reference ref = this.checks.getReferenceMapMap().get(e.getId());
                    if (ref == null) break;
                    if (ref.getOverloadIdCount() == 0) {
                        result.append("^").append(ref.getName());
                        break;
                    }
                    for (int i = 0; i < ref.getOverloadIdCount(); ++i) {
                        if (i == 0) {
                            result.append("^");
                        } else {
                            result.append("|");
                        }
                        result.append(ref.getOverloadId(i));
                    }
                    break;
                }
            }
            return result.toString();
        }
    }
}

