/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.checker;

import com.google.api.expr.v1alpha1.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.checker.Mapping;
import org.projectnessie.cel.checker.TypeErrors;

public final class Types {
    public static String formatCheckedType(Type t2) {
        if (t2 == null) {
            return "(type not known)";
        }
        switch (Types.kindOf(t2)) {
            case kindDyn: {
                return "dyn";
            }
            case kindNull: {
                return "null";
            }
            case kindPrimitive: {
                switch (t2.getPrimitive()) {
                    case UINT64: {
                        return "uint";
                    }
                    case INT64: {
                        return "int";
                    }
                    case BOOL: {
                        return "bool";
                    }
                    case BYTES: {
                        return "bytes";
                    }
                    case DOUBLE: {
                        return "double";
                    }
                    case STRING: {
                        return "string";
                    }
                }
                return t2.getPrimitive().toString().toLowerCase(Locale.ROOT).trim();
            }
            case kindWellKnown: {
                switch (t2.getWellKnown()) {
                    case ANY: {
                        return "any";
                    }
                    case DURATION: {
                        return "duration";
                    }
                    case TIMESTAMP: {
                        return "timestamp";
                    }
                }
            }
            case kindError: {
                return "!error!";
            }
        }
        StringBuilder sb = new StringBuilder();
        Types.formatCheckedType(sb, t2);
        return sb.toString();
    }

    static void formatCheckedType(StringBuilder sb, Type t2) {
        switch (Types.kindOf(t2)) {
            case kindDyn: {
                sb.append("dyn");
                return;
            }
            case kindFunction: {
                TypeErrors.formatFunction(sb, t2.getFunction().getResultType(), t2.getFunction().getArgTypesList(), false);
                return;
            }
            case kindList: {
                sb.append("list(");
                Types.formatCheckedType(sb, t2.getListType().getElemType());
                sb.append(')');
                return;
            }
            case kindObject: {
                sb.append(t2.getMessageType());
                return;
            }
            case kindMap: {
                sb.append("map(");
                Types.formatCheckedType(sb, t2.getMapType().getKeyType());
                sb.append(", ");
                Types.formatCheckedType(sb, t2.getMapType().getValueType());
                sb.append(')');
                return;
            }
            case kindNull: {
                sb.append("null");
                return;
            }
            case kindPrimitive: {
                Types.formatCheckedTypePrimitive(sb, t2.getPrimitive());
                return;
            }
            case kindType: {
                if (t2.getType() == Type.getDefaultInstance()) {
                    sb.append("type");
                    return;
                }
                sb.append("type(");
                Types.formatCheckedType(sb, t2.getType());
                sb.append(')');
                return;
            }
            case kindWellKnown: {
                switch (t2.getWellKnown()) {
                    case ANY: {
                        sb.append("any");
                        return;
                    }
                    case DURATION: {
                        sb.append("duration");
                        return;
                    }
                    case TIMESTAMP: {
                        sb.append("timestamp");
                        return;
                    }
                }
            }
            case kindWrapper: {
                sb.append("wrapper(");
                Types.formatCheckedTypePrimitive(sb, t2.getWrapper());
                sb.append(')');
                return;
            }
            case kindError: {
                sb.append("!error!");
                return;
            }
        }
        String tStr = t2.toString();
        for (int i = 0; i < tStr.length(); ++i) {
            char c = tStr.charAt(i);
            if (c == '\n') continue;
            sb.append(c);
        }
    }

    private static void formatCheckedTypePrimitive(StringBuilder sb, Type.PrimitiveType t2) {
        switch (t2) {
            case UINT64: {
                sb.append("uint");
                return;
            }
            case INT64: {
                sb.append("int");
                return;
            }
            case BOOL: {
                sb.append("bool");
                return;
            }
            case BYTES: {
                sb.append("bytes");
                return;
            }
            case DOUBLE: {
                sb.append("double");
                return;
            }
            case STRING: {
                sb.append("string");
                return;
            }
        }
        sb.append(t2.toString().toLowerCase(Locale.ROOT).trim());
    }

    static boolean isDyn(Type t2) {
        switch (Types.kindOf(t2)) {
            case kindDyn: {
                return true;
            }
            case kindWellKnown: {
                return t2.getWellKnown() == Type.WellKnownType.ANY;
            }
        }
        return false;
    }

    static boolean isDynOrError(Type t2) {
        if (Types.kindOf(t2) == Kind.kindError) {
            return true;
        }
        return Types.isDyn(t2);
    }

    static boolean isEqualOrLessSpecific(Type t1, Type t2) {
        Kind kind1 = Types.kindOf(t1);
        Kind kind2 = Types.kindOf(t2);
        if (Types.isDyn(t1) || kind1 == Kind.kindTypeParam) {
            return true;
        }
        if (Types.isDyn(t2) || kind2 == Kind.kindTypeParam) {
            return false;
        }
        if (kind1 != kind2) {
            return false;
        }
        switch (kind1) {
            case kindAbstract: {
                Type.AbstractType a1 = t1.getAbstractType();
                Type.AbstractType a2 = t2.getAbstractType();
                if (!a1.getName().equals(a2.getName()) || a1.getParameterTypesCount() != a2.getParameterTypesCount()) {
                    return false;
                }
                for (int i = 0; i < a1.getParameterTypesList().size(); ++i) {
                    Type p1 = a1.getParameterTypes(i);
                    if (Types.isEqualOrLessSpecific(p1, a2.getParameterTypes(i))) continue;
                    return false;
                }
                return true;
            }
            case kindFunction: {
                Type.FunctionType fn1 = t1.getFunction();
                Type.FunctionType fn2 = t2.getFunction();
                if (fn1.getArgTypesCount() != fn2.getArgTypesCount()) {
                    return false;
                }
                if (!Types.isEqualOrLessSpecific(fn1.getResultType(), fn2.getResultType())) {
                    return false;
                }
                for (int i = 0; i < fn1.getArgTypesList().size(); ++i) {
                    Type a1 = fn1.getArgTypes(i);
                    if (Types.isEqualOrLessSpecific(a1, fn2.getArgTypes(i))) continue;
                    return false;
                }
                return true;
            }
            case kindList: {
                return Types.isEqualOrLessSpecific(t1.getListType().getElemType(), t2.getListType().getElemType());
            }
            case kindMap: {
                Type.MapType m1 = t1.getMapType();
                Type.MapType m22 = t2.getMapType();
                return Types.isEqualOrLessSpecific(m1.getKeyType(), m22.getKeyType()) && Types.isEqualOrLessSpecific(m1.getValueType(), m22.getValueType());
            }
            case kindType: {
                return true;
            }
        }
        return t1.equals(t2);
    }

    static boolean internalIsAssignable(Mapping m4, Type t1, Type t2) {
        if (t1.equals(t2)) {
            return true;
        }
        Kind kind1 = Types.kindOf(t1);
        Kind kind2 = Types.kindOf(t2);
        if (kind2 == Kind.kindTypeParam) {
            Type t2Sub = m4.find(t2);
            if (t2Sub != null) {
                if (Types.internalIsAssignable(m4, t1, t2Sub)) {
                    m4.add(t2, Types.mostGeneral(t1, t2Sub));
                    return true;
                }
                return false;
            }
            if (Types.notReferencedIn(m4, t2, t1)) {
                m4.add(t2, t1);
                return true;
            }
        }
        if (kind1 == Kind.kindTypeParam) {
            Type t1Sub = m4.find(t1);
            if (t1Sub != null) {
                if (Types.internalIsAssignable(m4, t1Sub, t2)) {
                    m4.add(t1, Types.mostGeneral(t1Sub, t2));
                    return true;
                }
                return false;
            }
            if (Types.notReferencedIn(m4, t1, t2)) {
                m4.add(t1, t2);
                return true;
            }
        }
        if (Types.isDynOrError(t1) || Types.isDynOrError(t2)) {
            return true;
        }
        switch (kind1) {
            case kindNull: {
                return Types.internalIsAssignableNull(t2);
            }
            case kindPrimitive: {
                return Types.internalIsAssignablePrimitive(t1.getPrimitive(), t2);
            }
            case kindWrapper: {
                return Types.internalIsAssignable(m4, Decls.newPrimitiveType(t1.getWrapper()), t2);
            }
        }
        if (kind1 != kind2) {
            return false;
        }
        switch (kind1) {
            case kindAbstract: {
                return Types.internalIsAssignableAbstractType(m4, t1.getAbstractType(), t2.getAbstractType());
            }
            case kindFunction: {
                return Types.internalIsAssignableFunction(m4, t1.getFunction(), t2.getFunction());
            }
            case kindList: {
                return Types.internalIsAssignable(m4, t1.getListType().getElemType(), t2.getListType().getElemType());
            }
            case kindMap: {
                return Types.internalIsAssignableMap(m4, t1.getMapType(), t2.getMapType());
            }
            case kindObject: {
                return t1.getMessageType().equals(t2.getMessageType());
            }
            case kindType: {
                return true;
            }
            case kindWellKnown: {
                return t1.getWellKnown() == t2.getWellKnown();
            }
        }
        return false;
    }

    static boolean internalIsAssignableAbstractType(Mapping m4, Type.AbstractType a1, Type.AbstractType a2) {
        if (!a1.getName().equals(a2.getName())) {
            return false;
        }
        return Types.internalIsAssignableList(m4, a1.getParameterTypesList(), a2.getParameterTypesList());
    }

    static boolean internalIsAssignableFunction(Mapping m4, Type.FunctionType f1, Type.FunctionType f2) {
        List<Type> f1ArgTypes = Types.flattenFunctionTypes(f1);
        List<Type> f2ArgTypes = Types.flattenFunctionTypes(f2);
        return Types.internalIsAssignableList(m4, f1ArgTypes, f2ArgTypes);
    }

    static boolean internalIsAssignableList(Mapping m4, List<Type> l1, List<Type> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            Type t1 = l1.get(i);
            if (Types.internalIsAssignable(m4, t1, l2.get(i))) continue;
            return false;
        }
        return true;
    }

    static boolean internalIsAssignableMap(Mapping m4, Type.MapType m1, Type.MapType m22) {
        return Types.internalIsAssignableList(m4, Arrays.asList(m1.getKeyType(), m1.getValueType()), Arrays.asList(m22.getKeyType(), m22.getValueType()));
    }

    static boolean internalIsAssignableNull(Type t2) {
        switch (Types.kindOf(t2)) {
            case kindNull: 
            case kindWellKnown: 
            case kindObject: 
            case kindWrapper: 
            case kindAbstract: {
                return true;
            }
        }
        return false;
    }

    static boolean internalIsAssignablePrimitive(Type.PrimitiveType p, Type target) {
        switch (Types.kindOf(target)) {
            case kindPrimitive: {
                return p == target.getPrimitive();
            }
            case kindWrapper: {
                return p == target.getWrapper();
            }
        }
        return false;
    }

    static Mapping isAssignable(Mapping m4, Type t1, Type t2) {
        Mapping mCopy = m4.copy();
        if (Types.internalIsAssignable(mCopy, t1, t2)) {
            return mCopy;
        }
        return null;
    }

    static Mapping isAssignableList(Mapping m4, List<Type> l1, List<Type> l2) {
        Mapping mCopy = m4.copy();
        if (Types.internalIsAssignableList(mCopy, l1, l2)) {
            return mCopy;
        }
        return null;
    }

    static Kind kindOf(Type t2) {
        if (t2 == null || t2.getTypeKindCase() == Type.TypeKindCase.TYPEKIND_NOT_SET) {
            return Kind.kindUnknown;
        }
        switch (t2.getTypeKindCase()) {
            case ERROR: {
                return Kind.kindError;
            }
            case FUNCTION: {
                return Kind.kindFunction;
            }
            case DYN: {
                return Kind.kindDyn;
            }
            case PRIMITIVE: {
                return Kind.kindPrimitive;
            }
            case WELL_KNOWN: {
                return Kind.kindWellKnown;
            }
            case WRAPPER: {
                return Kind.kindWrapper;
            }
            case NULL: {
                return Kind.kindNull;
            }
            case TYPE: {
                return Kind.kindType;
            }
            case LIST_TYPE: {
                return Kind.kindList;
            }
            case MAP_TYPE: {
                return Kind.kindMap;
            }
            case MESSAGE_TYPE: {
                return Kind.kindObject;
            }
            case TYPE_PARAM: {
                return Kind.kindTypeParam;
            }
        }
        return Kind.kindUnknown;
    }

    static Type mostGeneral(Type t1, Type t2) {
        if (Types.isEqualOrLessSpecific(t1, t2)) {
            return t1;
        }
        return t2;
    }

    static boolean notReferencedIn(Mapping m4, Type t2, Type withinType) {
        if (t2.equals(withinType)) {
            return false;
        }
        Kind withinKind = Types.kindOf(withinType);
        switch (withinKind) {
            case kindTypeParam: {
                Type wtSub = m4.find(withinType);
                if (wtSub == null) {
                    return true;
                }
                return Types.notReferencedIn(m4, t2, wtSub);
            }
            case kindAbstract: {
                for (Type pt : withinType.getAbstractType().getParameterTypesList()) {
                    if (Types.notReferencedIn(m4, t2, pt)) continue;
                    return false;
                }
                return true;
            }
            case kindFunction: {
                Type.FunctionType fn = withinType.getFunction();
                List<Type> types = Types.flattenFunctionTypes(fn);
                for (Type a : types) {
                    if (Types.notReferencedIn(m4, t2, a)) continue;
                    return false;
                }
                return true;
            }
            case kindList: {
                return Types.notReferencedIn(m4, t2, withinType.getListType().getElemType());
            }
            case kindMap: {
                Type.MapType mt = withinType.getMapType();
                return Types.notReferencedIn(m4, t2, mt.getKeyType()) && Types.notReferencedIn(m4, t2, mt.getValueType());
            }
            case kindWrapper: {
                return Types.notReferencedIn(m4, t2, Decls.newPrimitiveType(withinType.getWrapper()));
            }
        }
        return true;
    }

    static Type substitute(Mapping m4, Type t2, boolean typeParamToDyn) {
        Type tSub = m4.find(t2);
        if (tSub != null) {
            return Types.substitute(m4, tSub, typeParamToDyn);
        }
        Kind kind = Types.kindOf(t2);
        if (typeParamToDyn && kind == Kind.kindTypeParam) {
            return Decls.Dyn;
        }
        switch (kind) {
            case kindAbstract: {
                Type.AbstractType at = t2.getAbstractType();
                ArrayList<Type> params = new ArrayList<Type>(at.getParameterTypesCount());
                for (Type p : at.getParameterTypesList()) {
                    params.add(Types.substitute(m4, p, typeParamToDyn));
                }
                return Decls.newAbstractType(at.getName(), params);
            }
            case kindFunction: {
                Type.FunctionType fn = t2.getFunction();
                Type rt = Types.substitute(m4, fn.getResultType(), typeParamToDyn);
                ArrayList<Type> args = new ArrayList<Type>(fn.getArgTypesCount());
                for (Type a : fn.getArgTypesList()) {
                    args.add(Types.substitute(m4, a, typeParamToDyn));
                }
                return Decls.newFunctionType(rt, args);
            }
            case kindList: {
                return Decls.newListType(Types.substitute(m4, t2.getListType().getElemType(), typeParamToDyn));
            }
            case kindMap: {
                Type.MapType mt = t2.getMapType();
                return Decls.newMapType(Types.substitute(m4, mt.getKeyType(), typeParamToDyn), Types.substitute(m4, mt.getValueType(), typeParamToDyn));
            }
            case kindType: {
                if (t2.getType() != Type.getDefaultInstance()) {
                    return Decls.newTypeType(Types.substitute(m4, t2.getType(), typeParamToDyn));
                }
                return t2;
            }
        }
        return t2;
    }

    static String typeKey(Type t2) {
        return Types.formatCheckedType(t2);
    }

    static List<Type> flattenFunctionTypes(Type.FunctionType f) {
        List<Type> argTypes = f.getArgTypesList();
        if (argTypes.isEmpty()) {
            return Collections.singletonList(f.getResultType());
        }
        ArrayList<Type> flattened = new ArrayList<Type>(argTypes.size() + 1);
        flattened.addAll(argTypes);
        flattened.add(f.getResultType());
        return flattened;
    }

    static enum Kind {
        kindUnknown,
        kindError,
        kindFunction,
        kindDyn,
        kindPrimitive,
        kindWellKnown,
        kindWrapper,
        kindNull,
        kindAbstract,
        kindType,
        kindList,
        kindMap,
        kindObject,
        kindTypeParam;

    }
}

