/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common;

import java.util.Objects;
import org.projectnessie.cel.common.Location;

final class SourceLocation
implements Location {
    private final int line;
    private final int column;

    public SourceLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    @Override
    public int compareTo(Location o) {
        int r = Integer.compare(this.line, o.line());
        if (r == 0) {
            r = Integer.compare(this.column, o.column());
        }
        return r;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        return this.line == that.line && this.column == that.column;
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }

    public String toString() {
        return "line=" + this.line + ", column=" + this.column;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public int column() {
        return this.column;
    }
}

