/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.operators;

import java.util.HashMap;
import java.util.Map;

public enum Operator {
    Conditional("_?_:_", 8, null),
    LogicalAnd("_&&_", 6, "&&"),
    LogicalOr("_||_", 7, "||"),
    LogicalNot("!_", 2, "!"),
    Equals("_==_", 5, "=="),
    NotEquals("_!=_", 5, "!="),
    Less("_<_", 5, "<"),
    LessEquals("_<=_", 5, "<="),
    Greater("_>_", 5, ">"),
    GreaterEquals("_>=_", 5, ">="),
    Add("_+_", 4, "+"),
    Subtract("_-_", 4, "-"),
    Multiply("_*_", 3, "*"),
    Divide("_/_", 3, "/"),
    Modulo("_%_", 3, "%"),
    Negate("-_", 2, "-"),
    Index("_[_]", 1, null),
    Has("has"),
    All("all"),
    Exists("exists"),
    ExistsOne("exists_one"),
    Map("map"),
    Filter("filter"),
    NotStrictlyFalse("@not_strictly_false"),
    In("@in", 5, "in"),
    OldNotStrictlyFalse("__not_strictly_false__"),
    OldIn("_in_", 5, "in");

    private static final Map<String, Operator> operators;
    private static final Map<String, Operator> operatorsById;
    public final String id;
    public final String reverse;
    public final int precedence;

    private Operator(String id) {
        this(id, 0, null);
    }

    private Operator(String id, int precedence, String reverse) {
        this.id = id;
        this.precedence = precedence;
        this.reverse = reverse;
    }

    public static Operator byId(String id) {
        return operatorsById.get(id);
    }

    public static Operator find(String text) {
        return operators.get(text);
    }

    public static String findReverse(String id) {
        Operator op = Operator.byId(id);
        return op != null ? op.reverse : null;
    }

    public static String findReverseBinaryOperator(String id) {
        Operator op = Operator.byId(id);
        if (op == null || op == LogicalNot || op == Negate) {
            return null;
        }
        return op.reverse;
    }

    public static int precedence(String id) {
        Operator op = Operator.byId(id);
        return op != null ? op.precedence : 0;
    }

    static {
        HashMap<String, Operator> m4 = new HashMap<String, Operator>();
        m4.put("+", Add);
        m4.put("/", Divide);
        m4.put("==", Equals);
        m4.put(">", Greater);
        m4.put(">=", GreaterEquals);
        m4.put("in", In);
        m4.put("<", Less);
        m4.put("<=", LessEquals);
        m4.put("%", Modulo);
        m4.put("*", Multiply);
        m4.put("!=", NotEquals);
        m4.put("-", Subtract);
        operators = m4;
        m4 = new HashMap();
        for (Operator op : Operator.values()) {
            m4.put(op.id, op);
        }
        operatorsById = m4;
    }
}

