/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types;

import com.google.protobuf.Any;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Value;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.projectnessie.cel.common.types.BoolT;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.TypeT;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.UintT;
import org.projectnessie.cel.common.types.ref.BaseVal;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Adder;
import org.projectnessie.cel.common.types.traits.Comparer;
import org.projectnessie.cel.common.types.traits.Divider;
import org.projectnessie.cel.common.types.traits.Multiplier;
import org.projectnessie.cel.common.types.traits.Negater;
import org.projectnessie.cel.common.types.traits.Subtractor;
import org.projectnessie.cel.common.types.traits.Trait;

public final class DoubleT
extends BaseVal
implements Adder,
Comparer,
Divider,
Multiplier,
Negater,
Subtractor {
    public static final Type DoubleType = TypeT.newTypeValue(TypeEnum.Double, Trait.AdderType, Trait.ComparerType, Trait.DividerType, Trait.MultiplierType, Trait.NegatorType, Trait.SubtractorType);
    private final double d;
    private static final BigInteger MAX_UINT64 = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);

    public static DoubleT doubleOf(double d) {
        return new DoubleT(d);
    }

    private DoubleT(double d) {
        this.d = d;
    }

    @Override
    public double doubleValue() {
        return this.d;
    }

    @Override
    public Val add(Val other) {
        if (!(other instanceof DoubleT)) {
            return Err.noSuchOverload(this, "add", other);
        }
        return DoubleT.doubleOf(this.d + ((DoubleT)other).d);
    }

    @Override
    public <T> T convertToNative(Class<T> typeDesc) {
        if (typeDesc == Double.class || typeDesc == Double.TYPE || typeDesc == Object.class) {
            return (T)Double.valueOf(this.d);
        }
        if (typeDesc == Float.class || typeDesc == Float.TYPE) {
            return (T)Float.valueOf((float)this.d);
        }
        if (typeDesc == Any.class) {
            return (T)Any.pack(DoubleValue.of(this.d));
        }
        if (typeDesc == DoubleValue.class) {
            return (T)DoubleValue.of(this.d);
        }
        if (typeDesc == FloatValue.class) {
            return (T)FloatValue.of((float)this.d);
        }
        if (typeDesc == Val.class || typeDesc == DoubleT.class) {
            return (T)this;
        }
        if (typeDesc == Value.class) {
            return (T)Value.newBuilder().setNumberValue(this.d).build();
        }
        throw new RuntimeException(String.format("native type conversion error from '%s' to '%s'", DoubleType, typeDesc.getName()));
    }

    @Override
    public Val convertToType(Type typeValue) {
        switch (typeValue.typeEnum()) {
            case Int: {
                if (!Double.isFinite(this.d)) {
                    return Err.rangeError(this.d, "int");
                }
                long r = (long)this.d;
                if (r == Long.MIN_VALUE || r == Long.MAX_VALUE) {
                    return Err.rangeError(this.d, "int");
                }
                return IntT.intOf(r);
            }
            case Uint: {
                if (!Double.isFinite(this.d)) {
                    return Err.rangeError(this.d, "uint");
                }
                BigDecimal dec = new BigDecimal(this.d);
                BigInteger bi = dec.toBigInteger();
                if (this.d < 0.0 || bi.compareTo(MAX_UINT64) > 0) {
                    return Err.rangeError(this.d, "uint");
                }
                return UintT.uintOf(bi.longValue());
            }
            case Double: {
                return this;
            }
            case String: {
                return StringT.stringOf(Double.toString(this.d));
            }
            case Type: {
                return DoubleType;
            }
        }
        return Err.newTypeConversionError(DoubleType, typeValue);
    }

    @Override
    public Val divide(Val other) {
        if (!(other instanceof DoubleT)) {
            return Err.noSuchOverload(this, "divide", other);
        }
        return DoubleT.doubleOf(this.d / ((DoubleT)other).d);
    }

    @Override
    public Val compare(Val other) {
        switch (other.type().typeEnum()) {
            case Int: 
            case Uint: 
            case Double: {
                Val converted = other.convertToType(this.type());
                if (converted.type().typeEnum() == TypeEnum.Err) {
                    return converted;
                }
                double od = ((DoubleT)converted).d;
                if (this.d == od) {
                    return IntT.IntZero;
                }
                return IntT.intOfCompare(Double.compare(this.d, od));
            }
        }
        return Err.noSuchOverload(this, "compare", other);
    }

    @Override
    public Val equal(Val other) {
        switch (other.type().typeEnum()) {
            case Int: 
            case Uint: 
            case Double: 
            case String: {
                Val converted = other.convertToType(this.type());
                if (converted.type().typeEnum() == TypeEnum.Err) {
                    return converted;
                }
                double o = ((DoubleT)converted).d;
                return Types.boolOf(this.d == o);
            }
            case Null: 
            case Bytes: 
            case List: 
            case Map: {
                return BoolT.False;
            }
        }
        return Err.noSuchOverload(this, "equal", other);
    }

    @Override
    public Val multiply(Val other) {
        if (!(other instanceof DoubleT)) {
            return Err.noSuchOverload(this, "multiply", other);
        }
        return DoubleT.doubleOf(this.d * ((DoubleT)other).d);
    }

    @Override
    public Val negate() {
        return DoubleT.doubleOf(-this.d);
    }

    @Override
    public Val subtract(Val other) {
        if (!(other instanceof DoubleT)) {
            return Err.noSuchOverload(this, "subtract", other);
        }
        return DoubleT.doubleOf(this.d - ((DoubleT)other).d);
    }

    @Override
    public Type type() {
        return DoubleType;
    }

    @Override
    public Object value() {
        return this.d;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Val)) {
            return false;
        }
        return this.equal((Val)o).booleanValue();
    }

    @Override
    public int hashCode() {
        return (int)this.d;
    }
}

