/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types;

import com.google.protobuf.Any;
import com.google.protobuf.Duration;
import com.google.protobuf.Value;
import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.projectnessie.cel.common.types.BoolT;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.Overflow;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.TimestampT;
import org.projectnessie.cel.common.types.TypeT;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.ref.BaseVal;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Adder;
import org.projectnessie.cel.common.types.traits.Comparer;
import org.projectnessie.cel.common.types.traits.Negater;
import org.projectnessie.cel.common.types.traits.Receiver;
import org.projectnessie.cel.common.types.traits.Subtractor;
import org.projectnessie.cel.common.types.traits.Trait;

public final class DurationT
extends BaseVal
implements Adder,
Comparer,
Negater,
Receiver,
Subtractor {
    public static final Type DurationType = TypeT.newTypeValue(TypeEnum.Duration, Trait.AdderType, Trait.ComparerType, Trait.NegatorType, Trait.ReceiverType, Trait.SubtractorType);
    public static final long minDurationSeconds = -9223372036L;
    public static final long maxDurationSeconds = 9223372035L;
    private static final Map<String, Function<java.time.Duration, Val>> durationZeroArgOverloads = new HashMap<String, Function<java.time.Duration, Val>>();
    private final java.time.Duration d;

    public static DurationT durationOf(String s2) {
        java.time.Duration dur;
        block5: {
            try {
                dur = java.time.Duration.parse("PT" + s2);
            }
            catch (DateTimeParseException e) {
                try {
                    dur = java.time.Duration.parse("P" + s2);
                }
                catch (DateTimeParseException e2) {
                    if (s2.endsWith("ns")) {
                        dur = java.time.Duration.ofNanos(Long.parseLong(s2.substring(0, s2.length() - 2)));
                        break block5;
                    }
                    throw new DateTimeException("Cannot parse duration '" + s2 + "'", e2);
                }
            }
        }
        return DurationT.durationOf(dur);
    }

    public static DurationT durationOf(Duration d) {
        return new DurationT(java.time.Duration.ofSeconds(d.getSeconds(), d.getNanos()));
    }

    public static DurationT durationOf(java.time.Duration d) {
        return new DurationT(d);
    }

    private DurationT(java.time.Duration d) {
        this.d = d;
    }

    public Val rangeCheck() {
        if (this.d.getSeconds() < -9223372036L || this.d.getSeconds() > 9223372035L) {
            return Err.errDurationOutOfRange;
        }
        return this;
    }

    @Override
    public Val add(Val other) {
        switch (other.type().typeEnum()) {
            case Duration: {
                try {
                    return DurationT.durationOf(Overflow.addDurationChecked(this.d, ((DurationT)other).d));
                }
                catch (Overflow.OverflowException e) {
                    return Err.errDurationOverflow;
                }
            }
            case Timestamp: {
                try {
                    return TimestampT.timestampOf(Overflow.addTimeDurationChecked((ZonedDateTime)other.value(), this.d));
                }
                catch (Overflow.OverflowException e) {
                    return Err.errDurationOverflow;
                }
            }
        }
        return Err.noSuchOverload(this, "add", other);
    }

    @Override
    public Val compare(Val other) {
        if (!(other instanceof DurationT)) {
            return Err.noSuchOverload(this, "compare", other);
        }
        java.time.Duration o = ((DurationT)other).d;
        return IntT.intOfCompare(this.d.compareTo(o));
    }

    @Override
    public <T> T convertToNative(Class<T> typeDesc) {
        if (java.time.Duration.class.isAssignableFrom(typeDesc)) {
            return (T)this.d;
        }
        if (Duration.class == typeDesc || typeDesc == Object.class) {
            return (T)this.pbVal();
        }
        if (Any.class == typeDesc) {
            return (T)Any.pack(this.pbVal());
        }
        if (Long.class == typeDesc) {
            return (T)Long.valueOf(this.toJavaLong());
        }
        if (String.class == typeDesc) {
            return (T)this.toPbString();
        }
        if (typeDesc == Val.class || typeDesc == DurationT.class) {
            return (T)this;
        }
        if (typeDesc == Value.class) {
            return (T)Value.newBuilder().setStringValue(this.toPbString()).build();
        }
        throw new RuntimeException(String.format("native type conversion error from '%s' to '%s'", DurationType, typeDesc.getName()));
    }

    private Duration pbVal() {
        return Duration.newBuilder().setSeconds(this.d.getSeconds()).setNanos(this.d.getNano()).build();
    }

    private long toJavaLong() {
        return TimeUnit.SECONDS.toNanos(this.d.getSeconds()) + (long)this.d.getNano();
    }

    private String toPbString() {
        long nanos = TimeUnit.NANOSECONDS.toMicros(this.d.getNano());
        if (nanos == 0L) {
            return String.format("%ds", this.d.getSeconds());
        }
        return String.format("%d.%06ds", this.d.getSeconds(), TimeUnit.NANOSECONDS.toMicros(this.d.getNano()));
    }

    @Override
    public Val convertToType(Type typeValue) {
        switch (typeValue.typeEnum()) {
            case String: {
                return StringT.stringOf(this.toPbString());
            }
            case Int: {
                return IntT.intOf(this.toJavaLong());
            }
            case Duration: {
                return this;
            }
            case Type: {
                return DurationType;
            }
        }
        return Err.newTypeConversionError(DurationType, typeValue);
    }

    @Override
    public Val equal(Val other) {
        switch (other.type().typeEnum()) {
            case Duration: {
                return Types.boolOf(this.d.equals(((DurationT)other).d));
            }
            case Null: {
                return BoolT.False;
            }
        }
        return Err.noSuchOverload(this, "equal", other);
    }

    @Override
    public Val negate() {
        try {
            return DurationT.durationOf(Overflow.negateDurationChecked(this.d));
        }
        catch (Overflow.OverflowException e) {
            return Err.errDurationOverflow;
        }
    }

    @Override
    public Val receive(String function, String overload, Val ... args) {
        Function<java.time.Duration, Val> f;
        if (args.length == 0 && (f = durationZeroArgOverloads.get(function)) != null) {
            return f.apply(this.d);
        }
        return Err.noSuchOverload((Val)this, function, overload, args);
    }

    @Override
    public Val subtract(Val other) {
        if (!(other instanceof DurationT)) {
            return Err.noSuchOverload(this, "subtract", other);
        }
        try {
            return DurationT.durationOf(Overflow.subtractDurationChecked(this.d, ((DurationT)other).d));
        }
        catch (Overflow.OverflowException e) {
            return Err.errDurationOverflow;
        }
    }

    @Override
    public Type type() {
        return DurationType;
    }

    @Override
    public Object value() {
        return this.d;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationT durationT = (DurationT)o;
        return Objects.equals(this.d, durationT.d);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.d);
    }

    public static Val timeGetHours(java.time.Duration duration) {
        return IntT.intOf(TimeUnit.SECONDS.toHours(duration.getSeconds()));
    }

    public static Val timeGetMinutes(java.time.Duration duration) {
        return IntT.intOf(TimeUnit.SECONDS.toMinutes(duration.getSeconds()));
    }

    public static Val timeGetSeconds(java.time.Duration duration) {
        return IntT.intOf(duration.getSeconds());
    }

    public static Val timeGetMilliseconds(java.time.Duration duration) {
        return IntT.intOf(TimeUnit.NANOSECONDS.toMillis(duration.getNano()));
    }

    static {
        durationZeroArgOverloads.put("getHours", DurationT::timeGetHours);
        durationZeroArgOverloads.put("getMinutes", DurationT::timeGetMinutes);
        durationZeroArgOverloads.put("getSeconds", DurationT::timeGetSeconds);
        durationZeroArgOverloads.put("getMilliseconds", DurationT::timeGetMilliseconds);
    }
}

