/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types;

import com.google.protobuf.Any;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.Value;
import java.time.Instant;
import org.projectnessie.cel.common.types.BoolT;
import org.projectnessie.cel.common.types.DoubleT;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.Overflow;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.TimestampT;
import org.projectnessie.cel.common.types.TypeT;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.UintT;
import org.projectnessie.cel.common.types.ref.BaseVal;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Adder;
import org.projectnessie.cel.common.types.traits.Comparer;
import org.projectnessie.cel.common.types.traits.Divider;
import org.projectnessie.cel.common.types.traits.Modder;
import org.projectnessie.cel.common.types.traits.Multiplier;
import org.projectnessie.cel.common.types.traits.Negater;
import org.projectnessie.cel.common.types.traits.Subtractor;
import org.projectnessie.cel.common.types.traits.Trait;

public final class IntT
extends BaseVal
implements Adder,
Comparer,
Divider,
Modder,
Multiplier,
Negater,
Subtractor {
    public static final Type IntType = TypeT.newTypeValue(TypeEnum.Int, Trait.AdderType, Trait.ComparerType, Trait.DividerType, Trait.ModderType, Trait.MultiplierType, Trait.NegatorType, Trait.SubtractorType);
    public static final IntT IntZero = new IntT(0L);
    public static final IntT IntOne = new IntT(1L);
    public static final IntT IntNegOne = new IntT(-1L);
    public static final long maxIntJSON = 0x1FFFFFFFFFFFFFL;
    public static final long minIntJSON = -9007199254740991L;
    private final long i;

    private IntT(long i) {
        this.i = i;
    }

    public static IntT intOfCompare(int compareToResult) {
        if (compareToResult < 0) {
            return IntNegOne;
        }
        if (compareToResult > 0) {
            return IntOne;
        }
        return IntZero;
    }

    public static IntT intOf(long i) {
        if (i == 0L) {
            return IntZero;
        }
        if (i == 1L) {
            return IntOne;
        }
        if (i == -1L) {
            return IntNegOne;
        }
        return new IntT(i);
    }

    @Override
    public long intValue() {
        return this.i;
    }

    @Override
    public double doubleValue() {
        return this.i;
    }

    @Override
    public <T> T convertToNative(Class<T> typeDesc) {
        if (typeDesc == Long.class || typeDesc == Long.TYPE || typeDesc == Object.class) {
            return (T)Long.valueOf(this.i);
        }
        if (typeDesc == Integer.class || typeDesc == Integer.TYPE || typeDesc == Enum.class) {
            if (this.i < Integer.MIN_VALUE || this.i > Integer.MAX_VALUE) {
                Err.throwErrorAsIllegalStateException(Err.rangeError(this.i, "Java int"));
            }
            return (T)Integer.valueOf((int)this.i);
        }
        if (typeDesc == Any.class) {
            return (T)Any.pack(Int64Value.of(this.i));
        }
        if (typeDesc == Int64Value.class) {
            return (T)Int64Value.of(this.i);
        }
        if (typeDesc == Int32Value.class) {
            return (T)Int32Value.of((int)this.i);
        }
        if (typeDesc == Val.class || typeDesc == IntT.class) {
            return (T)this;
        }
        if (typeDesc == Value.class) {
            if (this.i >= -9007199254740991L && this.i <= 0x1FFFFFFFFFFFFFL) {
                return (T)Value.newBuilder().setNumberValue(this.i).build();
            }
            return (T)Value.newBuilder().setStringValue(Long.toString(this.i)).build();
        }
        throw new RuntimeException(String.format("native type conversion error from '%s' to '%s'", IntType, typeDesc.getName()));
    }

    @Override
    public Val convertToType(Type typeValue) {
        switch (typeValue.typeEnum()) {
            case Int: {
                return this;
            }
            case Uint: {
                if (this.i < 0L) {
                    return Err.rangeError(this.i, "uint");
                }
                return UintT.uintOf(this.i);
            }
            case Double: {
                return DoubleT.doubleOf(this.i);
            }
            case String: {
                return StringT.stringOf(Long.toString(this.i));
            }
            case Timestamp: {
                if (this.i < -62135596800L || this.i > 253402300799L) {
                    return Err.errTimestampOverflow;
                }
                return TimestampT.timestampOf(Instant.ofEpochSecond(this.i).atZone(TimestampT.ZoneIdZ));
            }
            case Type: {
                return IntType;
            }
        }
        return Err.newTypeConversionError(IntType, typeValue);
    }

    @Override
    public Val compare(Val other) {
        switch (other.type().typeEnum()) {
            case Double: {
                DoubleT cmp = (DoubleT)this.convertToType(DoubleT.DoubleType);
                return cmp.compare(other);
            }
            case Uint: {
                if (this.i < 0L) {
                    return IntNegOne;
                }
                if (other.intValue() < 0L) {
                    return IntNegOne;
                }
                return IntT.intOfCompare(Long.compareUnsigned(this.i, other.intValue()));
            }
            case Int: {
                Val converted = other.convertToType(this.type());
                if (converted.type().typeEnum() == TypeEnum.Err) {
                    return converted;
                }
                return IntT.intOfCompare(Long.compare(this.i, converted.intValue()));
            }
        }
        return Err.noSuchOverload(this, "compare", other);
    }

    @Override
    public Val equal(Val other) {
        switch (other.type().typeEnum()) {
            case Double: {
                DoubleT cmp = (DoubleT)this.convertToType(DoubleT.DoubleType);
                return cmp.equal(other);
            }
            case Uint: {
                if (other.intValue() < 0L) {
                    return BoolT.False;
                }
            }
            case Int: 
            case String: {
                Val converted = other.convertToType(this.type());
                if (converted.type().typeEnum() == TypeEnum.Err) {
                    return converted;
                }
                return Types.boolOf(this.i == converted.intValue());
            }
            case Null: 
            case Bytes: 
            case List: 
            case Map: {
                return BoolT.False;
            }
        }
        return Err.noSuchOverload(this, "equal", other);
    }

    @Override
    public Val divide(Val other) {
        if (!(other instanceof IntT)) {
            return Err.noSuchOverload(this, "divide", other);
        }
        long otherInt = ((IntT)other).i;
        if (otherInt == 0L) {
            return Err.divideByZero();
        }
        try {
            return IntT.intOf(Overflow.divideInt64Checked(this.i, ((IntT)other).i));
        }
        catch (Overflow.OverflowException e) {
            return Err.errIntOverflow;
        }
    }

    @Override
    public Val modulo(Val other) {
        if (!(other instanceof IntT)) {
            return Err.noSuchOverload(this, "modulo", other);
        }
        long otherInt = ((IntT)other).i;
        if (otherInt == 0L) {
            return Err.modulusByZero();
        }
        try {
            return IntT.intOf(Overflow.moduloInt64Checked(this.i, ((IntT)other).i));
        }
        catch (Overflow.OverflowException e) {
            return Err.errIntOverflow;
        }
    }

    @Override
    public Val multiply(Val other) {
        if (!(other instanceof IntT)) {
            return Err.noSuchOverload(this, "multiply", other);
        }
        try {
            return IntT.intOf(Overflow.multiplyInt64Checked(this.i, ((IntT)other).i));
        }
        catch (Overflow.OverflowException e) {
            return Err.errIntOverflow;
        }
    }

    @Override
    public Val negate() {
        try {
            return IntT.intOf(Overflow.negateInt64Checked(this.i));
        }
        catch (Overflow.OverflowException e) {
            return Err.errIntOverflow;
        }
    }

    @Override
    public Val add(Val other) {
        if (!(other instanceof IntT)) {
            return Err.noSuchOverload(this, "add", other);
        }
        try {
            return IntT.intOf(Overflow.addInt64Checked(this.i, ((IntT)other).i));
        }
        catch (Overflow.OverflowException e) {
            return Err.errIntOverflow;
        }
    }

    @Override
    public Val subtract(Val other) {
        if (!(other instanceof IntT)) {
            return Err.noSuchOverload(this, "subtract", other);
        }
        try {
            return IntT.intOf(Overflow.subtractInt64Checked(this.i, ((IntT)other).i));
        }
        catch (Overflow.OverflowException e) {
            return Err.errIntOverflow;
        }
    }

    @Override
    public Type type() {
        return IntType;
    }

    @Override
    public Object value() {
        return this.i;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Val)) {
            return false;
        }
        return this.equal((Val)o).booleanValue();
    }

    @Override
    public int hashCode() {
        return (int)this.i;
    }
}

