/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types;

import java.math.BigInteger;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;

public final class Overflow {
    public static final OverflowException overflowException = new OverflowException();

    public static long addInt64Checked(long x, long y) {
        if (y > 0L && x > Long.MAX_VALUE - y || y < 0L && x < Long.MIN_VALUE - y) {
            throw overflowException;
        }
        return x + y;
    }

    public static long subtractInt64Checked(long x, long y) {
        if (y < 0L && x > Long.MAX_VALUE + y || y > 0L && x < Long.MIN_VALUE + y) {
            throw overflowException;
        }
        return x - y;
    }

    public static long negateInt64Checked(long x) {
        if (x == Long.MIN_VALUE) {
            throw overflowException;
        }
        return -x;
    }

    public static long multiplyInt64Checked(long x, long y) {
        if (x == -1L && y == Long.MIN_VALUE || y == -1L && x == Long.MIN_VALUE || x > 0L && y > 0L && x > Long.MAX_VALUE / y || x > 0L && y < 0L && y < Long.MIN_VALUE / x || x < 0L && y > 0L && x < Long.MIN_VALUE / y || x < 0L && y < 0L && y < Long.MAX_VALUE / x) {
            throw overflowException;
        }
        return x * y;
    }

    public static long divideInt64Checked(long x, long y) {
        if (x == Long.MIN_VALUE && y == -1L) {
            throw overflowException;
        }
        return x / y;
    }

    public static long moduloInt64Checked(long x, long y) {
        if (x == Long.MIN_VALUE && y == -1L) {
            throw overflowException;
        }
        return x % y;
    }

    public static long addUint64Checked(long x, long y) {
        long xU = x >>> 32;
        long xL = x & 0xFFFFFFFFL;
        long yU = y >>> 32;
        long yL = y & 0xFFFFFFFFL;
        long rL = xL + yL;
        long rU = xU + yU;
        if (rL > 0xFFFFFFFFL) {
            ++rU;
        }
        if (rU > 0xFFFFFFFFL) {
            throw overflowException;
        }
        return rU << 32 | rL & 0xFFFFFFFFL;
    }

    public static long subtractUint64Checked(long x, long y) {
        long xU = x >>> 32;
        long xL = x & 0xFFFFFFFFL;
        long yU = y >>> 32;
        long yL = y & 0xFFFFFFFFL;
        long rU = xU - yU;
        long rL = xL - yL;
        if (rL < 0L) {
            --rU;
        }
        if (rU < 0L) {
            throw overflowException;
        }
        return rU << 32 | rL & 0xFFFFFFFFL;
    }

    public static long multiplyUint64Checked(long x, long y) {
        BigInteger r = BigInteger.valueOf(x).multiply(BigInteger.valueOf(y));
        if (r.bitLength() > 64) {
            throw overflowException;
        }
        return r.longValue();
    }

    public static Duration addDurationChecked(Duration x, Duration y) {
        try {
            return x.plus(y);
        }
        catch (ArithmeticException e) {
            throw overflowException;
        }
    }

    public static Duration subtractDurationChecked(Duration x, Duration y) {
        try {
            return x.minus(y);
        }
        catch (ArithmeticException e) {
            throw overflowException;
        }
    }

    public static Duration negateDurationChecked(Duration x) {
        try {
            return x.negated();
        }
        catch (ArithmeticException e) {
            throw overflowException;
        }
    }

    public static ZonedDateTime addTimeDurationChecked(ZonedDateTime x, Duration y) {
        try {
            return Overflow.checkTimeOverflow(x.plus(y));
        }
        catch (ArithmeticException e) {
            throw overflowException;
        }
    }

    public static Duration subtractTimeChecked(ZonedDateTime x, ZonedDateTime y) {
        try {
            Duration d = Duration.ofSeconds(x.toEpochSecond());
            d = d.plus((long)x.get(ChronoField.NANO_OF_SECOND), ChronoUnit.NANOS);
            d = d.minus(y.toEpochSecond(), ChronoUnit.SECONDS);
            d = d.minus(y.get(ChronoField.NANO_OF_SECOND), ChronoUnit.NANOS);
            return d;
        }
        catch (ArithmeticException e) {
            throw overflowException;
        }
    }

    public static ZonedDateTime subtractTimeDurationChecked(ZonedDateTime x, Duration y) {
        try {
            return Overflow.checkTimeOverflow(x.minus(y));
        }
        catch (ArithmeticException e) {
            throw overflowException;
        }
    }

    public static ZonedDateTime checkTimeOverflow(ZonedDateTime x) {
        long s2 = x.toEpochSecond();
        if (s2 < -62135596800L || s2 > 253402300799L) {
            throw overflowException;
        }
        return x;
    }

    public static final class OverflowException
    extends RuntimeException {
        OverflowException() {
            super("overflow", null, false, false);
        }
    }
}

