/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types;

import com.google.protobuf.Any;
import com.google.protobuf.StringValue;
import com.google.protobuf.Value;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.projectnessie.cel.common.types.BoolT;
import org.projectnessie.cel.common.types.BytesT;
import org.projectnessie.cel.common.types.DoubleT;
import org.projectnessie.cel.common.types.DurationT;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.TimestampT;
import org.projectnessie.cel.common.types.TypeT;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.UintT;
import org.projectnessie.cel.common.types.ref.BaseVal;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Adder;
import org.projectnessie.cel.common.types.traits.Comparer;
import org.projectnessie.cel.common.types.traits.Matcher;
import org.projectnessie.cel.common.types.traits.Receiver;
import org.projectnessie.cel.common.types.traits.Sizer;
import org.projectnessie.cel.common.types.traits.Trait;

public final class StringT
extends BaseVal
implements Adder,
Comparer,
Matcher,
Receiver,
Sizer {
    public static final Type StringType = TypeT.newTypeValue(TypeEnum.String, Trait.AdderType, Trait.ComparerType, Trait.MatcherType, Trait.ReceiverType, Trait.SizerType);
    private static final Map<String, BiFunction<String, Val, Val>> stringOneArgOverloads = new HashMap<String, BiFunction<String, Val, Val>>();
    private final String s;

    public static StringT stringOf(String s2) {
        return new StringT(s2);
    }

    private StringT(String s2) {
        this.s = s2;
    }

    @Override
    public Val add(Val other) {
        if (!(other instanceof StringT)) {
            return Err.noSuchOverload(this, "add", other);
        }
        return new StringT(this.s + ((StringT)other).s);
    }

    @Override
    public <T> T convertToNative(Class<T> typeDesc) {
        if (typeDesc == String.class || typeDesc == Object.class) {
            return (T)this.s;
        }
        if (typeDesc == byte[].class) {
            return (T)this.s.getBytes(StandardCharsets.UTF_8);
        }
        if (typeDesc == Any.class) {
            return (T)Any.pack(StringValue.of(this.s));
        }
        if (typeDesc == StringValue.class) {
            return (T)StringValue.of(this.s);
        }
        if (typeDesc == Val.class || typeDesc == StringT.class) {
            return (T)this;
        }
        if (typeDesc == Value.class) {
            return (T)Value.newBuilder().setStringValue(this.s).build();
        }
        throw new RuntimeException(String.format("native type conversion error from '%s' to '%s'", StringType, typeDesc.getName()));
    }

    @Override
    public Val convertToType(Type typeVal) {
        try {
            switch (typeVal.typeEnum()) {
                case Int: {
                    return IntT.intOf(Long.parseLong(this.s));
                }
                case Uint: {
                    return UintT.uintOf(Long.parseUnsignedLong(this.s));
                }
                case Double: {
                    return DoubleT.doubleOf(Double.parseDouble(this.s));
                }
                case Bool: {
                    if ("true".equalsIgnoreCase(this.s)) {
                        return BoolT.True;
                    }
                    if (!"false".equalsIgnoreCase(this.s)) break;
                    return BoolT.False;
                }
                case Bytes: {
                    return BytesT.bytesOf(this.s.getBytes(StandardCharsets.UTF_8));
                }
                case Duration: {
                    return DurationT.durationOf(this.s).rangeCheck();
                }
                case Timestamp: {
                    return TimestampT.timestampOf(this.s).rangeCheck();
                }
                case String: {
                    return this;
                }
                case Type: {
                    return StringType;
                }
            }
            return Err.newTypeConversionError(StringType, typeVal);
        }
        catch (Exception e) {
            return Err.newErr(e, "error during type conversion from '%s' to %s: %s", StringType, typeVal, e.toString());
        }
    }

    @Override
    public Val compare(Val other) {
        switch (other.type().typeEnum()) {
            case String: {
                return IntT.intOfCompare(this.s.compareTo(((StringT)other).s));
            }
            case Null: {
                return BoolT.False;
            }
        }
        return Err.noSuchOverload(this, "compare", other);
    }

    @Override
    public Val equal(Val other) {
        switch (other.type().typeEnum()) {
            case String: {
                return Types.boolOf(this.s.equals(((StringT)other).s));
            }
            case Int: 
            case Uint: 
            case Double: 
            case Bool: {
                return Types.boolOf(this.s.equals(((StringT)other.convertToType((Type)StringT.StringType)).s));
            }
            case Null: {
                return BoolT.False;
            }
        }
        return Err.noSuchOverload(this, "equal", other);
    }

    @Override
    public Val match(Val pattern) {
        if (!(pattern instanceof StringT)) {
            return Err.noSuchOverload(this, "match", pattern);
        }
        try {
            Pattern p = Pattern.compile(((StringT)pattern).s);
            java.util.regex.Matcher m4 = p.matcher(this.s);
            return Types.boolOf(m4.find());
        }
        catch (Exception e) {
            return Err.newErr(e, "%s", e.getMessage());
        }
    }

    @Override
    public Val receive(String function, String overload, Val ... args) {
        BiFunction<String, Val, Val> f;
        if (args.length == 1 && (f = stringOneArgOverloads.get(function)) != null) {
            return f.apply(this.s, args[0]);
        }
        return Err.noSuchOverload((Val)this, function, overload, args);
    }

    @Override
    public Val size() {
        return IntT.intOf(this.s.codePointCount(0, this.s.length()));
    }

    @Override
    public Type type() {
        return StringType;
    }

    @Override
    public Object value() {
        return this.s;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringT stringT = (StringT)o;
        return Objects.equals(this.s, stringT.s);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.s);
    }

    static Val stringContains(String s2, Val sub) {
        if (!(sub instanceof StringT)) {
            return Err.noSuchOverload(StringType, "contains", sub);
        }
        return Types.boolOf(s2.contains(((StringT)sub).s));
    }

    static Val stringEndsWith(String s2, Val suf) {
        if (!(suf instanceof StringT)) {
            return Err.noSuchOverload(StringType, "endsWith", suf);
        }
        return Types.boolOf(s2.endsWith(((StringT)suf).s));
    }

    static Val stringStartsWith(String s2, Val pre) {
        if (!(pre instanceof StringT)) {
            return Err.noSuchOverload(StringType, "startsWith", pre);
        }
        return Types.boolOf(s2.startsWith(((StringT)pre).s));
    }

    static {
        stringOneArgOverloads.put("contains", StringT::stringContains);
        stringOneArgOverloads.put("endsWith", StringT::stringEndsWith);
        stringOneArgOverloads.put("startsWith", StringT::stringStartsWith);
    }
}

