/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types;

import com.google.protobuf.Any;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import java.math.BigInteger;
import org.projectnessie.cel.common.ULong;
import org.projectnessie.cel.common.types.BoolT;
import org.projectnessie.cel.common.types.DoubleT;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.Overflow;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.TypeT;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.ref.BaseVal;
import org.projectnessie.cel.common.types.ref.Type;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Adder;
import org.projectnessie.cel.common.types.traits.Comparer;
import org.projectnessie.cel.common.types.traits.Divider;
import org.projectnessie.cel.common.types.traits.Modder;
import org.projectnessie.cel.common.types.traits.Multiplier;
import org.projectnessie.cel.common.types.traits.Subtractor;
import org.projectnessie.cel.common.types.traits.Trait;

public final class UintT
extends BaseVal
implements Adder,
Comparer,
Divider,
Modder,
Multiplier,
Subtractor {
    public static final Type UintType = TypeT.newTypeValue(TypeEnum.Uint, Trait.AdderType, Trait.ComparerType, Trait.DividerType, Trait.ModderType, Trait.MultiplierType, Trait.SubtractorType);
    public static final UintT UintZero = new UintT(0L);
    private final long i;

    public static UintT uintOf(ULong i) {
        return UintT.uintOf(i.longValue());
    }

    public static UintT uintOf(long i) {
        if (i == 0L) {
            return UintZero;
        }
        return new UintT(i);
    }

    private UintT(long i) {
        this.i = i;
    }

    @Override
    public long intValue() {
        return this.i;
    }

    @Override
    public double doubleValue() {
        return this.i;
    }

    @Override
    public <T> T convertToNative(Class<T> typeDesc) {
        if (typeDesc == Long.class || typeDesc == Long.TYPE || typeDesc == Object.class) {
            return (T)Long.valueOf(this.i);
        }
        if (typeDesc == Integer.class || typeDesc == Integer.TYPE) {
            if (this.i < Integer.MIN_VALUE || this.i > Integer.MAX_VALUE) {
                Err.throwErrorAsIllegalStateException(Err.rangeError(this.i, "Java int"));
            }
            return (T)Integer.valueOf((int)this.i);
        }
        if (typeDesc == ULong.class) {
            return (T)ULong.valueOf(this.i);
        }
        if (typeDesc == Any.class) {
            return (T)Any.pack(UInt64Value.of(this.i));
        }
        if (typeDesc == UInt64Value.class) {
            return (T)UInt64Value.of(this.i);
        }
        if (typeDesc == UInt32Value.class) {
            return (T)UInt32Value.of((int)this.i);
        }
        if (typeDesc == Val.class || typeDesc == UintT.class) {
            return (T)this;
        }
        if (typeDesc == Value.class) {
            if (this.i <= 0x1FFFFFFFFFFFFFL) {
                return (T)Value.newBuilder().setNumberValue(this.i).build();
            }
            return (T)Value.newBuilder().setStringValue(Long.toUnsignedString(this.i)).build();
        }
        throw new RuntimeException(String.format("native type conversion error from '%s' to '%s'", UintType, typeDesc.getName()));
    }

    @Override
    public Val convertToType(Type typeValue) {
        switch (typeValue.typeEnum()) {
            case Int: {
                if (this.i < 0L) {
                    return Err.rangeError(Long.toUnsignedString(this.i), "int");
                }
                return IntT.intOf(this.i);
            }
            case Uint: {
                return this;
            }
            case Double: {
                if (this.i < 0L) {
                    return DoubleT.doubleOf(new BigInteger(Long.toUnsignedString(this.i)).doubleValue());
                }
                return DoubleT.doubleOf(this.i);
            }
            case String: {
                return StringT.stringOf(Long.toUnsignedString(this.i));
            }
            case Type: {
                return UintType;
            }
        }
        return Err.newTypeConversionError(UintType, typeValue);
    }

    @Override
    public Val compare(Val other) {
        switch (other.type().typeEnum()) {
            case Int: {
                if (other.type().typeEnum() == TypeEnum.Err) {
                    return other;
                }
                if (other.intValue() < 0L) {
                    return IntT.IntOne;
                }
                if (this.i < 0L) {
                    return IntT.IntOne;
                }
                return IntT.intOfCompare(Long.compareUnsigned(this.i, other.intValue()));
            }
            case Double: {
                if (other.type().typeEnum() == TypeEnum.Err) {
                    return other;
                }
                if (other.doubleValue() < 0.0) {
                    return IntT.IntOne;
                }
                DoubleT cmp = (DoubleT)this.convertToType(DoubleT.DoubleType);
                return cmp.compare(other);
            }
            case Uint: {
                Val converted = other.convertToType(this.type());
                if (converted.type().typeEnum() == TypeEnum.Err) {
                    return converted;
                }
                return IntT.intOfCompare(Long.compareUnsigned(this.i, ((UintT)converted).i));
            }
        }
        return Err.noSuchOverload(this, "compare", other);
    }

    @Override
    public Val equal(Val other) {
        switch (other.type().typeEnum()) {
            case Int: {
                if (other.type().typeEnum() == TypeEnum.Err) {
                    return other;
                }
                if (other.intValue() < 0L) {
                    return BoolT.False;
                }
                if (this.i < 0L) {
                    return BoolT.False;
                }
                return Types.boolOf(this.i == other.intValue());
            }
            case Double: {
                return other.equal(this);
            }
            case Uint: 
            case String: {
                Val converted = other.convertToType(this.type());
                if (converted.type().typeEnum() == TypeEnum.Err) {
                    return converted;
                }
                return Types.boolOf(this.i == converted.intValue());
            }
            case Null: 
            case Bytes: 
            case List: 
            case Map: {
                return BoolT.False;
            }
        }
        return Err.noSuchOverload(this, "equal", other);
    }

    @Override
    public Val divide(Val other) {
        if (other.type() != UintType) {
            return Err.noSuchOverload(this, "divide", other);
        }
        long otherInt = ((UintT)other).i;
        if (otherInt == 0L) {
            return Err.divideByZero();
        }
        return UintT.uintOf(this.i / otherInt);
    }

    @Override
    public Val modulo(Val other) {
        if (other.type() != UintType) {
            return Err.noSuchOverload(this, "modulo", other);
        }
        long otherInt = ((UintT)other).i;
        if (otherInt == 0L) {
            return Err.modulusByZero();
        }
        return UintT.uintOf(this.i % otherInt);
    }

    @Override
    public Val multiply(Val other) {
        if (other.type() != UintType) {
            return Err.noSuchOverload(this, "multiply", other);
        }
        try {
            return UintT.uintOf(Overflow.multiplyUint64Checked(this.i, ((UintT)other).i));
        }
        catch (Overflow.OverflowException e) {
            return Err.errUintOverflow;
        }
    }

    @Override
    public Val add(Val other) {
        if (other.type() != UintType) {
            return Err.noSuchOverload(this, "add", other);
        }
        try {
            return UintT.uintOf(Overflow.addUint64Checked(this.i, ((UintT)other).i));
        }
        catch (Overflow.OverflowException e) {
            return Err.errUintOverflow;
        }
    }

    @Override
    public Val subtract(Val other) {
        if (other.type() != UintType) {
            return Err.noSuchOverload(this, "subtract", other);
        }
        try {
            return UintT.uintOf(Overflow.subtractUint64Checked(this.i, ((UintT)other).i));
        }
        catch (Overflow.OverflowException e) {
            return Err.errUintOverflow;
        }
    }

    @Override
    public Type type() {
        return UintType;
    }

    @Override
    public Object value() {
        return this.i;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Val)) {
            return false;
        }
        return this.equal((Val)o).booleanValue();
    }

    @Override
    public int hashCode() {
        return (int)this.i;
    }

    @Override
    public String toString() {
        return String.format("%s{%s}", this.type().typeName(), Long.toUnsignedString(this.i));
    }
}

