/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.common.types.pb;

import com.google.protobuf.Any;
import com.google.protobuf.BoolValue;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DoubleValue;
import com.google.protobuf.Duration;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.FloatValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.Int64Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ListValue;
import com.google.protobuf.Message;
import com.google.protobuf.NullValue;
import com.google.protobuf.StringValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Timestamp;
import com.google.protobuf.UInt32Value;
import com.google.protobuf.UInt64Value;
import com.google.protobuf.Value;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.projectnessie.cel.common.ULong;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.TimestampT;
import org.projectnessie.cel.common.types.pb.Db;
import org.projectnessie.cel.common.types.pb.Description;
import org.projectnessie.cel.common.types.pb.FieldDescription;
import org.projectnessie.cel.common.types.ref.TypeDescription;

public final class PbTypeDescription
extends Description
implements TypeDescription {
    private final String typeName;
    private final Descriptors.Descriptor desc;
    private final Map<String, FieldDescription> fieldMap;
    private Class<?> reflectType;
    private Message zeroMsg;
    private static final Map<Class<?>, Function<Message, Object>> MessageToObjectExact = new IdentityHashMap();
    private static final Map<String, Message> zeroValueMap;

    private PbTypeDescription(String typeName, Descriptors.Descriptor desc, Map<String, FieldDescription> fieldMap, Class<?> reflectType, Message zeroMsg) {
        this.typeName = typeName;
        this.desc = desc;
        this.fieldMap = fieldMap;
        this.reflectType = reflectType;
        this.zeroMsg = zeroMsg;
    }

    void updateReflectType(Message zeroMsg) {
        this.zeroMsg = zeroMsg;
        this.reflectType = zeroMsg.getClass();
    }

    public static PbTypeDescription newTypeDescription(String typeName, Descriptors.Descriptor desc) {
        DynamicMessage msgZero = DynamicMessage.getDefaultInstance(desc);
        HashMap<String, FieldDescription> fieldMap = new HashMap<String, FieldDescription>();
        List<Descriptors.FieldDescriptor> fields = desc.getFields();
        for (Descriptors.FieldDescriptor f : fields) {
            fieldMap.put(f.getName(), FieldDescription.newFieldDescription(f));
        }
        return new PbTypeDescription(typeName, desc, fieldMap, PbTypeDescription.reflectTypeOf(msgZero), PbTypeDescription.zeroValueOf(msgZero));
    }

    public Map<String, FieldDescription> fieldMap() {
        return this.fieldMap;
    }

    public FieldDescription fieldByName(String name) {
        return this.fieldMap.get(name);
    }

    public Object maybeUnwrap(Db db, Object m4) {
        Message msg = (Message)m4;
        try {
            if (this.reflectType == Any.class) {
                ByteString realValue;
                String realTypeUrl;
                if (msg instanceof DynamicMessage) {
                    DynamicMessage dyn = (DynamicMessage)msg;
                    Descriptors.Descriptor dynDesc = dyn.getDescriptorForType();
                    Descriptors.FieldDescriptor fTypeUrl = dynDesc.findFieldByName("type_url");
                    Descriptors.FieldDescriptor fValue = dynDesc.findFieldByName("value");
                    realTypeUrl = (String)dyn.getField(fTypeUrl);
                    realValue = (ByteString)dyn.getField(fValue);
                } else if (msg instanceof Any) {
                    Any any = (Any)msg;
                    realTypeUrl = any.getTypeUrl();
                    realValue = any.getValue();
                } else {
                    return Err.anyWithEmptyType();
                }
                String realTypeName = PbTypeDescription.typeNameFromUrl(realTypeUrl);
                if (realTypeName.isEmpty() || realTypeName.equals(this.typeName)) {
                    return Err.anyWithEmptyType();
                }
                PbTypeDescription realTypeDescriptor = db.describeType(realTypeName);
                Message realMsg = realTypeDescriptor.zeroMsg.getParserForType().parseFrom(realValue);
                return realTypeDescriptor.maybeUnwrap(db, realMsg);
            }
            if (!(this.zeroMsg instanceof DynamicMessage)) {
                if (msg instanceof Any) {
                    Any any = (Any)msg;
                    msg = this.zeroMsg.getParserForType().parseFrom(any.getValue());
                } else if (msg instanceof DynamicMessage) {
                    DynamicMessage dyn = (DynamicMessage)msg;
                    msg = this.zeroMsg.getParserForType().parseFrom(dyn.toByteString());
                }
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
        return PbTypeDescription.unwrap(db, this, msg);
    }

    @Override
    public String name() {
        return this.desc.getFullName();
    }

    public Message.Builder newMessageBuilder() {
        return this.zeroMsg.newBuilderForType();
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.desc;
    }

    @Override
    public Class<?> reflectType() {
        return this.reflectType;
    }

    @Override
    public Message zero() {
        return this.zeroMsg;
    }

    public String toString() {
        return "PbTypeDescription{name: '" + this.typeName + '\'' + ", fieldMap: " + this.fieldMap + ", reflectType: " + this.reflectType + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PbTypeDescription that = (PbTypeDescription)o;
        return Objects.equals(this.typeName, that.typeName) && Objects.equals(this.desc, that.desc);
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.desc);
    }

    static Object unwrap(Db db, Description desc, Message msg) {
        Function<Message, Object> conv = MessageToObjectExact.get(msg.getClass());
        if (conv != null) {
            return conv.apply(msg);
        }
        if (msg instanceof Any) {
            Any v = (Any)msg;
            DynamicMessage dyn = DynamicMessage.newBuilder(v).build();
            return PbTypeDescription.unwrapDynamic(db, desc, dyn);
        }
        if (msg instanceof DynamicMessage) {
            return PbTypeDescription.unwrapDynamic(db, desc, msg);
        }
        if (msg instanceof Value) {
            Value v = (Value)msg;
            switch (v.getKindCase()) {
                case BOOL_VALUE: {
                    return v.getBoolValue();
                }
                case LIST_VALUE: {
                    return v.getListValue();
                }
                case NULL_VALUE: {
                    return v.getNullValue();
                }
                case NUMBER_VALUE: {
                    return v.getNumberValue();
                }
                case STRING_VALUE: {
                    return v.getStringValue();
                }
                case STRUCT_VALUE: {
                    return v.getStructValue();
                }
            }
            return NullValue.NULL_VALUE;
        }
        return msg;
    }

    private static java.time.Duration asJavaDuration(Duration d) {
        return java.time.Duration.ofSeconds(d.getSeconds(), d.getNanos());
    }

    private static ZonedDateTime asJavaTimestamp(Timestamp t2) {
        return ZonedDateTime.of(LocalDateTime.ofEpochSecond(t2.getSeconds(), t2.getNanos(), ZoneOffset.UTC), TimestampT.ZoneIdZ);
    }

    static Object unwrapDynamic(Db db, Description desc, Message refMsg) {
        String typeName;
        Message msg = refMsg;
        if (!msg.isInitialized()) {
            msg = desc.zero();
        }
        switch (typeName = refMsg.getDescriptorForType().getFullName()) {
            case "google.protobuf.Any": {
                return PbTypeDescription.unwrapDynamicAny(db, desc, refMsg);
            }
            case "google.protobuf.BoolValue": 
            case "google.protobuf.BytesValue": 
            case "google.protobuf.DoubleValue": 
            case "google.protobuf.FloatValue": 
            case "google.protobuf.Int32Value": 
            case "google.protobuf.Int64Value": 
            case "google.protobuf.StringValue": {
                if (msg == msg.getDefaultInstanceForType()) {
                    return NullValue.NULL_VALUE;
                }
                Descriptors.FieldDescriptor valueField = msg.getDescriptorForType().findFieldByName("value");
                return msg.getField(valueField);
            }
            case "google.protobuf.UInt32Value": 
            case "google.protobuf.UInt64Value": {
                if (msg == msg.getDefaultInstanceForType()) {
                    return NullValue.NULL_VALUE;
                }
                Descriptors.FieldDescriptor valueField = msg.getDescriptorForType().findFieldByName("value");
                Number value = (Number)msg.getField(valueField);
                return ULong.valueOf(value.longValue());
            }
            case "google.protobuf.Duration": {
                return PbTypeDescription.asJavaDuration(Duration.newBuilder().mergeFrom(msg).build());
            }
            case "google.protobuf.ListValue": {
                return ListValue.newBuilder().mergeFrom(msg).build();
            }
            case "google.protobuf.NullValue": {
                return NullValue.NULL_VALUE;
            }
            case "google.protobuf.Struct": {
                return Struct.newBuilder().mergeFrom(msg).build();
            }
            case "google.protobuf.Timestamp": {
                return PbTypeDescription.asJavaTimestamp(Timestamp.newBuilder().mergeFrom(msg).build());
            }
            case "google.protobuf.Value": {
                Value.Builder unwrapped = Value.newBuilder();
                unwrapped.mergeFrom(msg);
                return PbTypeDescription.unwrap(db, desc, Value.newBuilder().mergeFrom(msg).build());
            }
        }
        return msg;
    }

    private static Object unwrapDynamicAny(Db db, Description desc, Message refMsg) {
        DynamicMessage dyn = (DynamicMessage)refMsg;
        Any any = Any.newBuilder().mergeFrom(dyn).build();
        String typeUrl = any.getTypeUrl();
        if (typeUrl.isEmpty()) {
            return Err.anyWithEmptyType();
        }
        String innerTypeName = PbTypeDescription.typeNameFromUrl(typeUrl);
        PbTypeDescription innerType = db.describeType(innerTypeName);
        if (innerType == null) {
            return refMsg;
        }
        try {
            Class<?> msgClass = innerType.reflectType();
            Object unwrapped = any.unpack(msgClass);
            return PbTypeDescription.unwrapDynamic(db, desc, unwrapped);
        }
        catch (Exception e) {
            return refMsg;
        }
    }

    public static String typeNameFromMessage(Message message) {
        if (message instanceof DynamicMessage) {
            DynamicMessage dyn = (DynamicMessage)message;
            Descriptors.Descriptor dynDesc = dyn.getDescriptorForType();
            if (dynDesc.getFullName().equals("google.protobuf.Any")) {
                Descriptors.FieldDescriptor f = dynDesc.findFieldByName("type_url");
                String typeUrl = (String)dyn.getField(f);
                return PbTypeDescription.typeNameFromUrl(typeUrl);
            }
        } else if (message instanceof Any) {
            Any any = (Any)message;
            String typeUrl = any.getTypeUrl();
            return PbTypeDescription.typeNameFromUrl(typeUrl);
        }
        return message.getDescriptorForType().getFullName();
    }

    public static String typeNameFromUrl(String typeUrl) {
        return typeUrl.substring(typeUrl.indexOf(47) + 1);
    }

    static Class<?> reflectTypeOf(Object val) {
        if (val instanceof Message) {
            val = PbTypeDescription.zeroValueOf((Message)val);
        }
        return val.getClass();
    }

    static Message zeroValueOf(Message msg) {
        if (msg == null) {
            return null;
        }
        String typeName = msg.getDescriptorForType().getFullName();
        return zeroValueMap.getOrDefault(typeName, msg);
    }

    static {
        MessageToObjectExact.put(BoolValue.class, msg -> ((BoolValue)msg).getValue());
        MessageToObjectExact.put(BytesValue.class, msg -> ((BytesValue)msg).getValue());
        MessageToObjectExact.put(DoubleValue.class, msg -> ((DoubleValue)msg).getValue());
        MessageToObjectExact.put(FloatValue.class, msg -> Float.valueOf(((FloatValue)msg).getValue()));
        MessageToObjectExact.put(Int32Value.class, msg -> ((Int32Value)msg).getValue());
        MessageToObjectExact.put(Int64Value.class, msg -> ((Int64Value)msg).getValue());
        MessageToObjectExact.put(StringValue.class, msg -> ((StringValue)msg).getValue());
        MessageToObjectExact.put(UInt32Value.class, msg -> ULong.valueOf(((UInt32Value)msg).getValue()));
        MessageToObjectExact.put(UInt64Value.class, msg -> ULong.valueOf(((UInt64Value)msg).getValue()));
        MessageToObjectExact.put(Duration.class, msg -> PbTypeDescription.asJavaDuration((Duration)msg));
        MessageToObjectExact.put(Timestamp.class, msg -> PbTypeDescription.asJavaTimestamp((Timestamp)msg));
        zeroValueMap = new HashMap<String, Message>();
        zeroValueMap.put("google.protobuf.Any", Any.getDefaultInstance());
        zeroValueMap.put("google.protobuf.Duration", Duration.getDefaultInstance());
        zeroValueMap.put("google.protobuf.ListValue", ListValue.getDefaultInstance());
        zeroValueMap.put("google.protobuf.Struct", Struct.getDefaultInstance());
        zeroValueMap.put("google.protobuf.Value", Value.getDefaultInstance());
        zeroValueMap.put("google.protobuf.Timestamp", Timestamp.getDefaultInstance());
        zeroValueMap.put("google.protobuf.BoolValue", BoolValue.getDefaultInstance());
        zeroValueMap.put("google.protobuf.BytesValue", BytesValue.getDefaultInstance());
        zeroValueMap.put("google.protobuf.DoubleValue", DoubleValue.getDefaultInstance());
        zeroValueMap.put("google.protobuf.FloatValue", FloatValue.getDefaultInstance());
        zeroValueMap.put("google.protobuf.Int32Value", Int32Value.getDefaultInstance());
        zeroValueMap.put("google.protobuf.Int64Value", Int64Value.getDefaultInstance());
        zeroValueMap.put("google.protobuf.StringValue", StringValue.getDefaultInstance());
        zeroValueMap.put("google.protobuf.UInt32Value", UInt32Value.getDefaultInstance());
        zeroValueMap.put("google.protobuf.UInt64Value", UInt64Value.getDefaultInstance());
    }
}

