/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.extension;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.ListT;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.extension.QuadFunction;
import org.projectnessie.cel.extension.TriFunction;
import org.projectnessie.cel.interpreter.functions.BinaryOp;
import org.projectnessie.cel.interpreter.functions.FunctionOp;
import org.projectnessie.cel.interpreter.functions.UnaryOp;

public final class Guards {
    private Guards() {
    }

    public static BinaryOp callInStrIntOutStr(BiFunction<String, Integer, String> func) {
        return (lhs, rhs) -> {
            try {
                return StringT.stringOf((String)func.apply((String)lhs.value(), Guards.getIntValue((IntT)rhs)));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static FunctionOp callInStrIntIntOutStr(TriFunction<String, Integer, Integer, String> func) {
        return values2 -> {
            try {
                return StringT.stringOf((String)func.apply((String)values2[0].value(), Guards.getIntValue((IntT)values2[1]), Guards.getIntValue((IntT)values2[2])));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static BinaryOp callInStrStrOutInt(BiFunction<String, String, Integer> func) {
        return (lhs, rhs) -> {
            try {
                return IntT.intOf(((Integer)func.apply((String)lhs.value(), (String)rhs.value())).intValue());
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static FunctionOp callInStrStrIntOutInt(TriFunction<String, String, Integer, Integer> func) {
        return values2 -> {
            try {
                return IntT.intOf(((Integer)func.apply((String)values2[0].value(), (String)values2[1].value(), Guards.getIntValue((IntT)values2[2]))).intValue());
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static BinaryOp callInStrStrOutStrArr(BiFunction<String, String, String[]> func) {
        return (lhs, rhs) -> {
            try {
                return ListT.newStringArrayList((String[])func.apply((String)lhs.value(), (String)rhs.value()));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static FunctionOp callInStrStrIntOutStrArr(TriFunction<String, String, Integer, String[]> func) {
        return values2 -> {
            try {
                return ListT.newStringArrayList((String[])func.apply((String)values2[0].value(), (String)values2[1].value(), Guards.getIntValue((IntT)values2[2])));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static FunctionOp callInStrStrStrOutStr(TriFunction<String, String, String, String> func) {
        return values2 -> {
            try {
                return StringT.stringOf((String)func.apply((String)values2[0].value(), (String)values2[1].value(), (String)values2[2].value()));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static FunctionOp callInStrStrStrIntOutStr(QuadFunction<String, String, String, Integer, String> func) {
        return values2 -> {
            try {
                return StringT.stringOf((String)func.apply((String)values2[0].value(), (String)values2[1].value(), (String)values2[2].value(), Guards.getIntValue((IntT)values2[3])));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static UnaryOp callInStrOutStr(UnaryOperator<String> func) {
        return val -> {
            try {
                return StringT.stringOf((String)func.apply((String)val.value()));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static UnaryOp callInStrArrayOutStr(Function<String[], String> func) {
        return val -> {
            try {
                Object[] objects = (Object[])val.value();
                return StringT.stringOf((String)func.apply((String[])Arrays.copyOf(objects, objects.length, String[].class)));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    public static BinaryOp callInStrArrayStrOutStr(BiFunction<String[], String, String> func) {
        return (lhs, rhs) -> {
            try {
                Object[] objects = (Object[])lhs.value();
                return StringT.stringOf((String)func.apply((String[])Arrays.copyOf(objects, objects.length, String[].class), (String)rhs.value()));
            }
            catch (RuntimeException e) {
                return Err.newErr(e, "%s", e.getMessage());
            }
        };
    }

    private static int getIntValue(IntT value) {
        Long longValue = (Long)value.value();
        if (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE) {
            throw new RuntimeException(String.format("Integer %d value overflow", longValue));
        }
        return longValue.intValue();
    }
}

