/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.interpreter;

import com.google.api.expr.v1alpha1.Type;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.projectnessie.cel.common.ULong;
import org.projectnessie.cel.common.containers.Container;
import org.projectnessie.cel.common.types.BoolT;
import org.projectnessie.cel.common.types.DoubleT;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.NullT;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.UintT;
import org.projectnessie.cel.common.types.UnknownT;
import org.projectnessie.cel.common.types.ref.FieldType;
import org.projectnessie.cel.common.types.ref.TypeAdapter;
import org.projectnessie.cel.common.types.ref.TypeProvider;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Indexer;
import org.projectnessie.cel.common.types.traits.Mapper;
import org.projectnessie.cel.interpreter.Activation;
import org.projectnessie.cel.interpreter.AttributePattern;
import org.projectnessie.cel.interpreter.Coster;
import org.projectnessie.cel.interpreter.Interpretable;
import org.projectnessie.cel.interpreter.ResolvedValue;

public interface AttributeFactory {
    public NamespacedAttribute absoluteAttribute(long var1, String ... var3);

    public Attribute conditionalAttribute(long var1, Interpretable var3, Attribute var4, Attribute var5);

    public Attribute maybeAttribute(long var1, String var3);

    public Attribute relativeAttribute(long var1, Interpretable var3);

    public Qualifier newQualifier(Type var1, long var2, Object var4);

    public static AttributeFactory newAttributeFactory(Container cont, TypeAdapter a, TypeProvider p) {
        return new AttrFactory(cont, a, p);
    }

    public static Qualifier newQualifierStatic(TypeAdapter adapter, long id, Object v) {
        if (v instanceof Attribute) {
            return new AttrQualifier(id, (Attribute)v);
        }
        Class<?> c = v.getClass();
        if (v instanceof Val) {
            Val val = (Val)v;
            switch (val.type().typeEnum()) {
                case String: {
                    return new StringQualifier(id, (String)val.value(), val, adapter);
                }
                case Double: {
                    return new DoubleQualifier(id, (Double)val.value(), val, adapter);
                }
                case Int: {
                    return new IntQualifier(id, val.intValue(), val, adapter);
                }
                case Uint: {
                    return new UintQualifier(id, val.intValue(), val, adapter);
                }
                case Bool: {
                    return new BoolQualifier(id, val.booleanValue(), val, adapter);
                }
                case Null: {
                    return new NullQualifier(id, val, adapter);
                }
            }
        }
        if (c == String.class) {
            return new StringQualifier(id, (String)v, StringT.stringOf((String)v), adapter);
        }
        if (c == ULong.class) {
            long l = ((ULong)v).longValue();
            return new UintQualifier(id, l, UintT.uintOf(l), adapter);
        }
        if (c == Byte.class || c == Short.class || c == Integer.class || c == Long.class) {
            long i = ((Number)v).longValue();
            return new IntQualifier(id, i, IntT.intOf(i), adapter);
        }
        if (c == Double.class) {
            double b = (Double)v;
            return new DoubleQualifier(id, b, DoubleT.doubleOf(b), adapter);
        }
        if (c == Boolean.class) {
            boolean b = (Boolean)v;
            return new BoolQualifier(id, b, Types.boolOf(b), adapter);
        }
        throw new IllegalStateException(String.format("invalid qualifier type: %s", v.getClass().getName()));
    }

    public static Val refResolve(TypeAdapter adapter, Val idx, Object obj) {
        Val celVal = adapter.nativeToValue(obj);
        if (celVal instanceof Mapper) {
            Mapper mapper = (Mapper)celVal;
            Val elem = mapper.find(idx);
            if (elem == null) {
                return Err.noSuchKey(idx);
            }
            return elem;
        }
        if (celVal instanceof Indexer) {
            Indexer indexer = (Indexer)((Object)celVal);
            return indexer.get(idx);
        }
        if (UnknownT.isUnknown(celVal)) {
            return celVal;
        }
        Err.throwErrorAsIllegalStateException(celVal);
        return Err.noSuchOverload(celVal, "ref-resolve", null);
    }

    public static final class AttrFactory
    implements AttributeFactory {
        private final Container container;
        private final TypeAdapter adapter;
        private final TypeProvider provider;

        AttrFactory(Container container, TypeAdapter adapter, TypeProvider provider) {
            this.container = container;
            this.adapter = adapter;
            this.provider = provider;
        }

        @Override
        public NamespacedAttribute absoluteAttribute(long id, String ... names) {
            return new AbsoluteAttribute(id, names, new ArrayList<Qualifier>(), this.adapter, this.provider, this);
        }

        @Override
        public Attribute conditionalAttribute(long id, Interpretable expr, Attribute t2, Attribute f) {
            return new ConditionalAttribute(id, expr, t2, f, this.adapter, this);
        }

        @Override
        public Attribute maybeAttribute(long id, String name) {
            ArrayList<NamespacedAttribute> attrs = new ArrayList<NamespacedAttribute>();
            attrs.add(this.absoluteAttribute(id, this.container.resolveCandidateNames(name)));
            return new MaybeAttribute(id, attrs, this.adapter, this.provider, this);
        }

        @Override
        public Attribute relativeAttribute(long id, Interpretable operand) {
            return new RelativeAttribute(id, operand, new ArrayList<Qualifier>(), this.adapter, this);
        }

        @Override
        public Qualifier newQualifier(Type objType, long qualID, Object val) {
            if (val instanceof String) {
                FieldType ft;
                String str = (String)val;
                if (objType != null && !objType.getMessageType().isEmpty() && (ft = this.provider.findFieldType(objType.getMessageType(), str)) != null && ft.isSet != null && ft.getFrom != null) {
                    return new FieldQualifier(qualID, str, ft, this.adapter);
                }
            }
            return AttributeFactory.newQualifierStatic(this.adapter, qualID, val);
        }

        public String toString() {
            return "AttrFactory{container=" + this.container + ", adapter=" + this.adapter + ", provider=" + this.provider + '}';
        }
    }

    public static interface Attribute
    extends Qualifier {
        public Attribute addQualifier(Qualifier var1);

        public Object resolve(Activation var1);
    }

    public static final class AttrQualifier
    implements Coster,
    Attribute {
        final long id;
        final Attribute attribute;

        AttrQualifier(long id, Attribute attribute) {
            this.id = id;
            this.attribute = attribute;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.estimateCost(this.attribute);
        }

        @Override
        public Attribute addQualifier(Qualifier q) {
            return this.attribute.addQualifier(q);
        }

        @Override
        public Object resolve(Activation a) {
            return this.attribute.resolve(a);
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            return this.attribute.qualify(vars, obj);
        }

        public String toString() {
            return "AttrQualifier{id=" + this.id + ", attribute=" + this.attribute + '}';
        }
    }

    public static final class StringQualifier
    implements Coster,
    ConstantQualifierEquator,
    AttributePattern.QualifierValueEquator {
        final long id;
        final String value;
        final Val celValue;
        final TypeAdapter adapter;

        StringQualifier(long id, String value, Val celValue, TypeAdapter adapter) {
            this.id = id;
            this.value = value;
            this.celValue = celValue;
            this.adapter = adapter;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            String s2 = this.value;
            if (obj instanceof Map) {
                Map m4 = (Map)obj;
                if ((obj = m4.get(s2)) == null) {
                    if (m4.containsKey(s2)) {
                        return NullT.NullValue;
                    }
                    throw Err.noSuchKeyException(s2);
                }
            } else {
                if (UnknownT.isUnknown(obj)) {
                    return obj;
                }
                return AttributeFactory.refResolve(this.adapter, this.celValue, obj);
            }
            return obj;
        }

        @Override
        public Val value() {
            return this.celValue;
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.None;
        }

        @Override
        public boolean qualifierValueEquals(Object value) {
            if (value instanceof String) {
                return this.value.equals(value);
            }
            return false;
        }

        public String toString() {
            return "StringQualifier{id=" + this.id + ", value='" + this.value + '\'' + ", celValue=" + this.celValue + ", adapter=" + this.adapter + '}';
        }
    }

    public static final class DoubleQualifier
    implements Coster,
    ConstantQualifierEquator {
        final long id;
        final double value;
        final Val celValue;
        final TypeAdapter adapter;

        DoubleQualifier(long id, double value, Val celValue, TypeAdapter adapter) {
            this.id = id;
            this.value = value;
            this.celValue = celValue;
            this.adapter = adapter;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            double i = this.value;
            if (obj instanceof Map) {
                Map m4 = (Map)obj;
                if ((obj = m4.get(i)) == null) {
                    obj = m4.get((int)i);
                }
                if (obj == null) {
                    if (m4.containsKey(i) || m4.containsKey((int)i)) {
                        return null;
                    }
                    throw Err.noSuchKeyException(i);
                }
                return obj;
            }
            if (obj.getClass().isArray()) {
                int l = Array.getLength(obj);
                if (i < 0.0 || i >= (double)l) {
                    throw Err.indexOutOfBoundsException(i);
                }
                obj = Array.get(obj, (int)i);
                return obj;
            }
            if (obj instanceof List) {
                List list = (List)obj;
                int l = list.size();
                if (i < 0.0 || i >= (double)l) {
                    throw Err.indexOutOfBoundsException(i);
                }
                obj = list.get((int)i);
                return obj;
            }
            if (UnknownT.isUnknown(obj)) {
                return obj;
            }
            return AttributeFactory.refResolve(this.adapter, this.celValue, obj);
        }

        @Override
        public Val value() {
            return this.celValue;
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.None;
        }

        @Override
        public boolean qualifierValueEquals(Object value) {
            if (value instanceof ULong) {
                return false;
            }
            if (value instanceof Number) {
                return this.value == ((Number)value).doubleValue();
            }
            return false;
        }

        public String toString() {
            return "DoubleQualifier{id=" + this.id + ", value=" + this.value + ", celValue=" + this.celValue + ", adapter=" + this.adapter + '}';
        }
    }

    public static final class IntQualifier
    implements Coster,
    ConstantQualifierEquator {
        final long id;
        final long value;
        final Val celValue;
        final TypeAdapter adapter;

        IntQualifier(long id, long value, Val celValue, TypeAdapter adapter) {
            this.id = id;
            this.value = value;
            this.celValue = celValue;
            this.adapter = adapter;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            long i = this.value;
            if (obj instanceof Map) {
                Map m4 = (Map)obj;
                if ((obj = m4.get(i)) == null) {
                    obj = m4.get((int)i);
                }
                if (obj == null) {
                    if (m4.containsKey(i) || m4.containsKey((int)i)) {
                        return null;
                    }
                    throw Err.noSuchKeyException(i);
                }
                return obj;
            }
            if (obj.getClass().isArray()) {
                int l = Array.getLength(obj);
                if (i < 0L || i >= (long)l) {
                    throw Err.indexOutOfBoundsException(i);
                }
                obj = Array.get(obj, (int)i);
                return obj;
            }
            if (obj instanceof List) {
                List list = (List)obj;
                int l = list.size();
                if (i < 0L || i >= (long)l) {
                    throw Err.indexOutOfBoundsException(i);
                }
                obj = list.get((int)i);
                return obj;
            }
            if (UnknownT.isUnknown(obj)) {
                return obj;
            }
            return AttributeFactory.refResolve(this.adapter, this.celValue, obj);
        }

        @Override
        public Val value() {
            return this.celValue;
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.None;
        }

        @Override
        public boolean qualifierValueEquals(Object value) {
            if (value instanceof ULong) {
                return false;
            }
            if (value instanceof Number) {
                return this.value == ((Number)value).longValue();
            }
            return false;
        }

        public String toString() {
            return "IntQualifier{id=" + this.id + ", value=" + this.value + ", celValue=" + this.celValue + ", adapter=" + this.adapter + '}';
        }
    }

    public static final class UintQualifier
    implements Coster,
    ConstantQualifierEquator {
        final long id;
        final long value;
        final Val celValue;
        final TypeAdapter adapter;

        UintQualifier(long id, long value, Val celValue, TypeAdapter adapter) {
            this.id = id;
            this.value = value;
            this.celValue = celValue;
            this.adapter = adapter;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            long i = this.value;
            if (obj instanceof Map) {
                Map m4 = (Map)obj;
                if ((obj = m4.get(ULong.valueOf(i))) == null) {
                    throw Err.noSuchKeyException(i);
                }
                return obj;
            }
            if (obj.getClass().isArray()) {
                int l = Array.getLength(obj);
                if (i < 0L && i >= (long)l) {
                    throw Err.indexOutOfBoundsException(i);
                }
                obj = Array.get(obj, (int)i);
                return obj;
            }
            if (UnknownT.isUnknown(obj)) {
                return obj;
            }
            return AttributeFactory.refResolve(this.adapter, this.celValue, obj);
        }

        @Override
        public Val value() {
            return this.celValue;
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.None;
        }

        @Override
        public boolean qualifierValueEquals(Object value) {
            if (value instanceof ULong) {
                return this.value == ((ULong)value).longValue();
            }
            return false;
        }

        public String toString() {
            return "UintQualifier{id=" + this.id + ", value=" + this.value + ", celValue=" + this.celValue + ", adapter=" + this.adapter + '}';
        }
    }

    public static final class BoolQualifier
    implements Coster,
    ConstantQualifierEquator {
        final long id;
        final boolean value;
        final Val celValue;
        final TypeAdapter adapter;

        BoolQualifier(long id, boolean value, Val celValue, TypeAdapter adapter) {
            this.id = id;
            this.value = value;
            this.celValue = celValue;
            this.adapter = adapter;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            boolean b = this.value;
            if (obj instanceof Map) {
                Map m4 = (Map)obj;
                if ((obj = m4.get(b)) == null) {
                    if (m4.containsKey(b)) {
                        return null;
                    }
                    throw Err.noSuchKeyException(b);
                }
            } else {
                if (UnknownT.isUnknown(obj)) {
                    return obj;
                }
                return AttributeFactory.refResolve(this.adapter, this.celValue, obj);
            }
            return obj;
        }

        @Override
        public Val value() {
            return this.celValue;
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.None;
        }

        @Override
        public boolean qualifierValueEquals(Object value) {
            if (value instanceof Boolean) {
                return this.value == (Boolean)value;
            }
            return false;
        }

        public String toString() {
            return "BoolQualifier{id=" + this.id + ", value=" + this.value + ", celValue=" + this.celValue + ", adapter=" + this.adapter + '}';
        }
    }

    public static final class NullQualifier
    implements Coster,
    ConstantQualifierEquator {
        final long id;
        final Val celValue;
        final TypeAdapter adapter;

        NullQualifier(long id, Val celValue, TypeAdapter adapter) {
            this.id = id;
            this.celValue = celValue;
            this.adapter = adapter;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            return null;
        }

        @Override
        public Val value() {
            return NullT.NullValue;
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.None;
        }

        @Override
        public boolean qualifierValueEquals(Object value) {
            return value == null || value == NullT.NullValue;
        }

        public String toString() {
            return "NullQualifier{id=" + this.id + ", celValue=" + this.celValue + ", adapter=" + this.adapter + '}';
        }
    }

    public static final class FieldQualifier
    implements Coster,
    ConstantQualifierEquator {
        final long id;
        final String name;
        final FieldType fieldType;
        final TypeAdapter adapter;

        FieldQualifier(long id, String name, FieldType fieldType, TypeAdapter adapter) {
            this.id = id;
            this.name = name;
            this.fieldType = fieldType;
            this.adapter = adapter;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            if (obj instanceof Val) {
                obj = ((Val)obj).value();
            }
            return this.fieldType.getFrom.getFrom(obj);
        }

        @Override
        public Val value() {
            return StringT.stringOf(this.name);
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.None;
        }

        @Override
        public boolean qualifierValueEquals(Object value) {
            if (value instanceof String) {
                return this.name.equals(value);
            }
            return false;
        }

        public String toString() {
            return "FieldQualifier{id=" + this.id + ", name='" + this.name + '\'' + ", fieldType=" + this.fieldType + ", adapter=" + this.adapter + '}';
        }
    }

    public static final class RelativeAttribute
    implements Coster,
    Qualifier,
    Attribute {
        final long id;
        final Interpretable operand;
        final List<Qualifier> qualifiers;
        final TypeAdapter adapter;
        final AttributeFactory fac;

        RelativeAttribute(long id, Interpretable operand, List<Qualifier> qualifiers, TypeAdapter adapter, AttributeFactory fac) {
            this.id = id;
            this.operand = operand;
            this.qualifiers = qualifiers;
            this.adapter = adapter;
            this.fac = fac;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public Coster.Cost cost() {
            Coster.Cost c = Coster.Cost.estimateCost(this.operand);
            long min2 = c.min;
            long max = c.max;
            for (Qualifier qual : this.qualifiers) {
                Coster.Cost q = Coster.Cost.estimateCost(qual);
                min2 += q.min;
                max += q.max;
            }
            return Coster.costOf(min2, max);
        }

        @Override
        public Attribute addQualifier(Qualifier qual) {
            this.qualifiers.add(qual);
            return this;
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            Object val = this.resolve(vars);
            if (UnknownT.isUnknown(val)) {
                return val;
            }
            Qualifier qual = this.fac.newQualifier(null, this.id, val);
            return qual.qualify(vars, obj);
        }

        @Override
        public Object resolve(Activation vars) {
            Val v = this.operand.eval(vars);
            if (Err.isError(v)) {
                throw new Err.ErrException("message: %s", v);
            }
            if (UnknownT.isUnknown(v)) {
                return v;
            }
            Object obj = v;
            for (Qualifier qual : this.qualifiers) {
                if (obj == null) {
                    throw Err.noSuchAttributeException(this);
                }
                if (!((obj = qual.qualify(vars, obj)) instanceof Err)) continue;
                return obj;
            }
            if (obj == null) {
                throw Err.noSuchAttributeException(this);
            }
            return obj;
        }

        public String toString() {
            return String.format("id: %d, operand: %s", this.id, this.operand);
        }
    }

    public static final class MaybeAttribute
    implements Coster,
    Attribute,
    Qualifier {
        final long id;
        final List<NamespacedAttribute> attrs;
        final TypeAdapter adapter;
        final TypeProvider provider;
        final AttributeFactory fac;

        MaybeAttribute(long id, List<NamespacedAttribute> attrs, TypeAdapter adapter, TypeProvider provider, AttributeFactory fac) {
            this.id = id;
            this.attrs = attrs;
            this.adapter = adapter;
            this.provider = provider;
            this.fac = fac;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public Coster.Cost cost() {
            long min2 = Long.MAX_VALUE;
            long max = 0L;
            for (NamespacedAttribute a : this.attrs) {
                Coster.Cost ac = Coster.Cost.estimateCost(a);
                min2 = Long.min(min2, ac.min);
                max = Long.max(max, ac.max);
            }
            return Coster.costOf(min2, max);
        }

        @Override
        public Attribute addQualifier(Qualifier qual) {
            ConstantQualifier cq;
            Object cqv;
            String str = "";
            boolean isStr = false;
            if (qual instanceof ConstantQualifier && (cqv = (cq = (ConstantQualifier)qual).value().value()) instanceof String) {
                str = (String)cqv;
                isStr = true;
            }
            String[] augmentedNames = new String[]{};
            for (NamespacedAttribute attr : this.attrs) {
                if (isStr && attr.qualifiers().isEmpty()) {
                    String[] candidateVars = attr.candidateVariableNames();
                    augmentedNames = new String[candidateVars.length];
                    for (int i = 0; i < candidateVars.length; ++i) {
                        String name = candidateVars[i];
                        augmentedNames[i] = String.format("%s.%s", name, str);
                    }
                }
                attr.addQualifier(qual);
            }
            if (this.attrs.isEmpty()) {
                this.attrs.add(this.fac.absoluteAttribute(qual.id(), augmentedNames));
            } else {
                this.attrs.add(0, this.fac.absoluteAttribute(qual.id(), augmentedNames));
            }
            return this;
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            Object val = this.resolve(vars);
            if (UnknownT.isUnknown(val)) {
                return val;
            }
            Qualifier qual = this.fac.newQualifier(null, this.id, val);
            return qual.qualify(vars, obj);
        }

        @Override
        public Object resolve(Activation vars) {
            for (NamespacedAttribute attr : this.attrs) {
                try {
                    return attr.tryResolve(vars);
                }
                catch (Err.ErrException errException) {
                }
            }
            throw Err.noSuchAttributeException(this);
        }

        public String toString() {
            return String.format("id: %s, attributes: %s", this.id, this.attrs);
        }
    }

    public static final class ConditionalAttribute
    implements Qualifier,
    Attribute,
    Coster {
        final long id;
        final Interpretable expr;
        final Attribute truthy;
        final Attribute falsy;
        final TypeAdapter adapter;
        final AttributeFactory fac;

        ConditionalAttribute(long id, Interpretable expr, Attribute truthy, Attribute falsy, TypeAdapter adapter, AttributeFactory fac) {
            this.id = id;
            this.expr = expr;
            this.truthy = truthy;
            this.falsy = falsy;
            this.adapter = adapter;
            this.fac = fac;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public Coster.Cost cost() {
            Coster.Cost t2 = Coster.Cost.estimateCost(this.truthy);
            Coster.Cost f = Coster.Cost.estimateCost(this.falsy);
            Coster.Cost e = Coster.Cost.estimateCost(this.expr);
            return Coster.costOf(e.min + Math.min(t2.min, f.min), e.max + Math.max(t2.max, f.max));
        }

        @Override
        public Attribute addQualifier(Qualifier qual) {
            this.truthy.addQualifier(qual);
            this.falsy.addQualifier(qual);
            return this;
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            Object val = this.resolve(vars);
            if (UnknownT.isUnknown(val)) {
                return val;
            }
            Qualifier qual = this.fac.newQualifier(null, this.id, val);
            return qual.qualify(vars, obj);
        }

        @Override
        public Object resolve(Activation vars) {
            Val val = this.expr.eval(vars);
            if (val == null) {
                throw Err.noSuchAttributeException(this);
            }
            if (Err.isError(val)) {
                throw new Err.ErrException("message: %s", val);
            }
            if (val == BoolT.True) {
                return this.truthy.resolve(vars);
            }
            if (val == BoolT.False) {
                return this.falsy.resolve(vars);
            }
            if (UnknownT.isUnknown(val)) {
                return val;
            }
            return Err.maybeNoSuchOverloadErr(val);
        }

        public String toString() {
            return String.format("id: %d, truthy attribute: %s, falsy attribute: %s", this.id, this.truthy, this.falsy);
        }
    }

    public static final class AbsoluteAttribute
    implements Qualifier,
    NamespacedAttribute,
    Coster {
        final long id;
        final String[] namespaceNames;
        final List<Qualifier> qualifiers;
        final TypeAdapter adapter;
        final TypeProvider provider;
        final AttributeFactory fac;

        AbsoluteAttribute(long id, String[] namespaceNames, List<Qualifier> qualifiers, TypeAdapter adapter, TypeProvider provider, AttributeFactory fac) {
            this.id = id;
            this.namespaceNames = Objects.requireNonNull(namespaceNames);
            this.qualifiers = Objects.requireNonNull(qualifiers);
            this.adapter = Objects.requireNonNull(adapter);
            this.provider = Objects.requireNonNull(provider);
            this.fac = Objects.requireNonNull(fac);
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public Coster.Cost cost() {
            long min2 = 0L;
            long max = 0L;
            for (Qualifier q : this.qualifiers) {
                Coster.Cost qc = Coster.Cost.estimateCost(q);
                min2 += qc.min;
                max += qc.max;
            }
            return Coster.costOf(++min2, ++max);
        }

        @Override
        public Attribute addQualifier(Qualifier q) {
            this.qualifiers.add(q);
            return this;
        }

        @Override
        public String[] candidateVariableNames() {
            return this.namespaceNames;
        }

        @Override
        public List<Qualifier> qualifiers() {
            return this.qualifiers;
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            Object val = this.resolve(vars);
            if (UnknownT.isUnknown(val)) {
                return val;
            }
            Qualifier qual = this.fac.newQualifier(null, this.id, val);
            return qual.qualify(vars, obj);
        }

        @Override
        public Object resolve(Activation vars) {
            return this.tryResolve(vars);
        }

        @Override
        public Object tryResolve(Activation vars) {
            for (String nm : this.namespaceNames) {
                ResolvedValue obj = vars.resolveName(nm);
                if (obj.present()) {
                    Object op = obj.value();
                    for (Qualifier qual : this.qualifiers) {
                        Object op2 = qual.qualify(vars, op);
                        if (op2 instanceof Err) {
                            return op2;
                        }
                        if (op2 == null) break;
                        op = op2;
                    }
                    return op;
                }
                Val typ = this.provider.findIdent(nm);
                if (typ == null) continue;
                if (this.qualifiers.isEmpty()) {
                    return typ;
                }
                throw Err.noSuchAttributeException(this);
            }
            throw Err.noSuchAttributeException(this);
        }

        public String toString() {
            return "id: " + this.id + ", names: " + Arrays.toString(this.namespaceNames);
        }
    }

    public static interface NamespacedAttribute
    extends Attribute {
        public String[] candidateVariableNames();

        public List<Qualifier> qualifiers();

        public Object tryResolve(Activation var1);
    }

    public static interface ConstantQualifierEquator
    extends AttributePattern.QualifierValueEquator,
    ConstantQualifier {
    }

    public static interface ConstantQualifier
    extends Qualifier {
        public Val value();
    }

    public static interface Qualifier {
        public long id();

        public Object qualify(Activation var1, Object var2);
    }
}

