/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.interpreter;

import org.agrona.collections.Long2ObjectHashMap;
import org.projectnessie.cel.common.types.ref.Val;

public interface EvalState {
    public long[] ids();

    public Val value(long var1);

    public void setValue(long var1, Val var3);

    public void reset();

    public static EvalState newEvalState() {
        return new EvalStateImpl();
    }

    public static final class EvalStateImpl
    implements EvalState {
        private final Long2ObjectHashMap<Val> values = new Long2ObjectHashMap();

        @Override
        public long[] ids() {
            return this.values.keySet().stream().mapToLong(l -> l).toArray();
        }

        @Override
        public Val value(long id) {
            return this.values.get(id);
        }

        @Override
        public void setValue(long id, Val v) {
            this.values.put(id, v);
        }

        @Override
        public void reset() {
            this.values.clear();
        }
    }
}

