/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.interpreter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.projectnessie.cel.common.operators.Operator;
import org.projectnessie.cel.common.types.BoolT;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.IterableT;
import org.projectnessie.cel.common.types.IteratorT;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.UnknownT;
import org.projectnessie.cel.common.types.Util;
import org.projectnessie.cel.common.types.ref.FieldType;
import org.projectnessie.cel.common.types.ref.TypeAdapter;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.TypeProvider;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Container;
import org.projectnessie.cel.common.types.traits.FieldTester;
import org.projectnessie.cel.common.types.traits.Negater;
import org.projectnessie.cel.common.types.traits.Receiver;
import org.projectnessie.cel.common.types.traits.Trait;
import org.projectnessie.cel.interpreter.Activation;
import org.projectnessie.cel.interpreter.AttributeFactory;
import org.projectnessie.cel.interpreter.Coster;
import org.projectnessie.cel.interpreter.InterpretableDecorator;
import org.projectnessie.cel.interpreter.functions.BinaryOp;
import org.projectnessie.cel.interpreter.functions.FunctionOp;
import org.projectnessie.cel.interpreter.functions.UnaryOp;

public interface Interpretable {
    public long id();

    public Val eval(Activation var1);

    public static InterpretableConst newConstValue(long id, Val val) {
        return new EvalConst(id, val);
    }

    public static Coster.Cost calShortCircuitBinaryOpsCost(Interpretable lhs, Interpretable rhs) {
        Coster.Cost l = Coster.Cost.estimateCost(lhs);
        Coster.Cost r = Coster.Cost.estimateCost(rhs);
        return Coster.costOf(l.min, l.max + r.max + 1L);
    }

    public static Coster.Cost sumOfCost(Interpretable[] interps) {
        long min2 = 0L;
        long max = 0L;
        for (Interpretable in : interps) {
            Coster.Cost t2 = Coster.Cost.estimateCost(in);
            min2 += t2.min;
            max += t2.max;
        }
        return Coster.costOf(min2, max);
    }

    public static Coster.Cost calExhaustiveBinaryOpsCost(Interpretable lhs, Interpretable rhs) {
        Coster.Cost l = Coster.Cost.estimateCost(lhs);
        Coster.Cost r = Coster.Cost.estimateCost(rhs);
        return Coster.Cost.OneOne.add(l).add(r);
    }

    public static final class EvalConst
    extends AbstractEval
    implements InterpretableConst,
    Coster {
        private final Val val;

        EvalConst(long id, Val val) {
            super(id);
            this.val = val;
        }

        @Override
        public Val eval(Activation activation) {
            return this.val;
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.None;
        }

        @Override
        public Val value() {
            return this.val;
        }

        @Override
        public String toString() {
            return "EvalConst{id=" + this.id + ", val=" + this.val + '}';
        }
    }

    public static final class EvalAttr
    extends AbstractEval
    implements InterpretableAttribute,
    Coster,
    AttributeFactory.Qualifier,
    AttributeFactory.Attribute {
        private final TypeAdapter adapter;
        private AttributeFactory.Attribute attr;

        EvalAttr(TypeAdapter adapter, AttributeFactory.Attribute attr) {
            super(attr.id());
            this.adapter = Objects.requireNonNull(adapter);
            this.attr = Objects.requireNonNull(attr);
        }

        @Override
        public AttributeFactory.Attribute addQualifier(AttributeFactory.Qualifier qualifier) {
            this.attr = this.attr.addQualifier(qualifier);
            return this.attr;
        }

        @Override
        public AttributeFactory.Attribute attr() {
            return this.attr;
        }

        @Override
        public TypeAdapter adapter() {
            return this.adapter;
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.estimateCost(this.attr);
        }

        @Override
        public Val eval(Activation ctx) {
            try {
                Object v = this.attr.resolve(ctx);
                return this.adapter.nativeToValue(v);
            }
            catch (Exception e) {
                return Err.newErr(e, e.toString(), new Object[0]);
            }
        }

        @Override
        public Object qualify(Activation ctx, Object obj) {
            return this.attr.qualify(ctx, obj);
        }

        @Override
        public Object resolve(Activation ctx) {
            return this.attr.resolve(ctx);
        }

        @Override
        public String toString() {
            return "EvalAttr{id=" + this.id + ", attr=" + this.attr + '}';
        }
    }

    public static final class EvalExhaustiveFold
    extends AbstractEval
    implements Coster {
        private final String accuVar;
        private final String iterVar;
        private final Interpretable iterRange;
        private final Interpretable accu;
        private final Interpretable cond;
        private final Interpretable step;
        private final Interpretable result;

        EvalExhaustiveFold(long id, Interpretable accu, String accuVar, Interpretable iterRange, String iterVar, Interpretable cond, Interpretable step, Interpretable result) {
            super(id);
            this.accuVar = accuVar;
            this.iterVar = iterVar;
            this.iterRange = iterRange;
            this.accu = accu;
            this.cond = cond;
            this.step = step;
            this.result = result;
        }

        @Override
        public Val eval(Activation ctx) {
            Val foldRange = this.iterRange.eval(ctx);
            if (!foldRange.type().hasTrait(Trait.IterableType)) {
                return Err.valOrErr(foldRange, "got '%s', expected iterable type", foldRange.getClass().getName());
            }
            Activation.VarActivation accuCtx = new Activation.VarActivation();
            accuCtx.parent = ctx;
            accuCtx.name = this.accuVar;
            accuCtx.val = this.accu.eval(ctx);
            Activation.VarActivation iterCtx = new Activation.VarActivation();
            iterCtx.parent = accuCtx;
            iterCtx.name = this.iterVar;
            IteratorT it = ((IterableT)((Object)foldRange)).iterator();
            while (it.hasNext() == BoolT.True) {
                iterCtx.val = it.next();
                this.cond.eval(iterCtx);
                accuCtx.val = this.step.eval(iterCtx);
            }
            return this.result.eval(accuCtx);
        }

        @Override
        public Coster.Cost cost() {
            Coster.Cost i = Coster.Cost.estimateCost(this.iterRange);
            Val foldRange = this.iterRange.eval(Activation.emptyActivation());
            if (!foldRange.type().hasTrait(Trait.IterableType)) {
                return Coster.Cost.Unknown;
            }
            long rangeCnt = 0L;
            IteratorT it = ((IterableT)((Object)foldRange)).iterator();
            while (it.hasNext() == BoolT.True) {
                it.next();
                ++rangeCnt;
            }
            Coster.Cost a = Coster.Cost.estimateCost(this.accu);
            Coster.Cost c = Coster.Cost.estimateCost(this.cond);
            Coster.Cost s2 = Coster.Cost.estimateCost(this.step);
            Coster.Cost r = Coster.Cost.estimateCost(this.result);
            return i.add(a).add(c.multiply(rangeCnt)).add(s2.multiply(rangeCnt)).add(r);
        }

        @Override
        public String toString() {
            return "EvalExhaustiveFold{id=" + this.id + ", accuVar='" + this.accuVar + '\'' + ", iterVar='" + this.iterVar + '\'' + ", iterRange=" + this.iterRange + ", accu=" + this.accu + ", cond=" + this.cond + ", step=" + this.step + ", result=" + this.result + '}';
        }
    }

    public static final class EvalExhaustiveConditional
    extends AbstractEval
    implements Coster {
        private final TypeAdapter adapter;
        private final AttributeFactory.ConditionalAttribute attr;

        EvalExhaustiveConditional(long id, TypeAdapter adapter, AttributeFactory.ConditionalAttribute attr) {
            super(id);
            this.adapter = Objects.requireNonNull(adapter);
            this.attr = Objects.requireNonNull(attr);
        }

        @Override
        public Val eval(Activation ctx) {
            Val cVal = this.attr.expr.eval(ctx);
            Object tVal = this.attr.truthy.resolve(ctx);
            Object fVal = this.attr.falsy.resolve(ctx);
            if (cVal == BoolT.True) {
                return this.adapter.nativeToValue(tVal);
            }
            if (cVal == BoolT.False) {
                return this.adapter.nativeToValue(fVal);
            }
            return Err.noSuchOverload(null, Operator.Conditional.id, cVal);
        }

        @Override
        public Coster.Cost cost() {
            return this.attr.cost();
        }

        @Override
        public String toString() {
            return "EvalExhaustiveConditional{id=" + this.id + ", attr=" + this.attr + '}';
        }
    }

    public static final class EvalExhaustiveAnd
    extends AbstractEvalLhsRhs {
        EvalExhaustiveAnd(long id, Interpretable lhs, Interpretable rhs) {
            super(id, lhs, rhs);
        }

        @Override
        public Val eval(Activation ctx) {
            Val lVal = this.lhs.eval(ctx);
            Val rVal = this.rhs.eval(ctx);
            if (lVal == BoolT.False || rVal == BoolT.False) {
                return BoolT.False;
            }
            if (lVal == BoolT.True && rVal == BoolT.True) {
                return BoolT.True;
            }
            if (UnknownT.isUnknown(lVal)) {
                return lVal;
            }
            if (UnknownT.isUnknown(rVal)) {
                return rVal;
            }
            if (Err.isError(lVal)) {
                return lVal;
            }
            return Err.noSuchOverload(lVal, Operator.LogicalAnd.id, rVal);
        }

        @Override
        public Coster.Cost cost() {
            return Interpretable.calExhaustiveBinaryOpsCost(this.lhs, this.rhs);
        }

        @Override
        public String toString() {
            return "EvalExhaustiveAnd{id=" + this.id + ", lhs=" + this.lhs + ", rhs=" + this.rhs + '}';
        }
    }

    public static final class EvalExhaustiveOr
    extends AbstractEvalLhsRhs {
        EvalExhaustiveOr(long id, Interpretable lhs, Interpretable rhs) {
            super(id, lhs, rhs);
        }

        @Override
        public Val eval(Activation ctx) {
            Val lVal = this.lhs.eval(ctx);
            Val rVal = this.rhs.eval(ctx);
            if (lVal == BoolT.True || rVal == BoolT.True) {
                return BoolT.True;
            }
            if (lVal == BoolT.False && rVal == BoolT.False) {
                return BoolT.False;
            }
            if (UnknownT.isUnknown(lVal)) {
                return lVal;
            }
            if (UnknownT.isUnknown(rVal)) {
                return rVal;
            }
            if (Err.isError(lVal)) {
                return lVal;
            }
            return Err.noSuchOverload(lVal, Operator.LogicalOr.id, rVal);
        }

        @Override
        public Coster.Cost cost() {
            return Interpretable.calExhaustiveBinaryOpsCost(this.lhs, this.rhs);
        }

        @Override
        public String toString() {
            return "EvalExhaustiveOr{id=" + this.id + ", lhs=" + this.lhs + ", rhs=" + this.rhs + '}';
        }
    }

    public static final class EvalWatchConst
    implements InterpretableConst,
    Coster {
        private final InterpretableConst c;
        private final InterpretableDecorator.EvalObserver observer;

        EvalWatchConst(InterpretableConst c, InterpretableDecorator.EvalObserver observer) {
            this.c = Objects.requireNonNull(c);
            this.observer = Objects.requireNonNull(observer);
        }

        @Override
        public long id() {
            return this.c.id();
        }

        @Override
        public Val eval(Activation activation) {
            Val val = this.value();
            this.observer.observe(this.id(), val);
            return val;
        }

        @Override
        public Val value() {
            return this.c.value();
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.estimateCost(this.c);
        }

        public String toString() {
            return "EvalWatchConst{" + this.c + '}';
        }
    }

    public static final class EvalWatchQual
    extends AbstractEvalWatch<AttributeFactory.Qualifier> {
        public EvalWatchQual(AttributeFactory.Qualifier delegate, InterpretableDecorator.EvalObserver observer, TypeAdapter adapter) {
            super(delegate, observer, adapter);
        }

        @Override
        public Val eval(Activation activation) {
            throw new UnsupportedOperationException("WTF?");
        }

        @Override
        public String toString() {
            return "EvalWatchQual{" + this.delegate + '}';
        }
    }

    public static final class EvalWatchConstQual
    extends AbstractEvalWatch<AttributeFactory.ConstantQualifier>
    implements AttributeFactory.ConstantQualifier,
    Coster {
        EvalWatchConstQual(AttributeFactory.ConstantQualifier delegate, InterpretableDecorator.EvalObserver observer, TypeAdapter adapter) {
            super(delegate, observer, adapter);
        }

        @Override
        public Val eval(Activation activation) {
            throw new UnsupportedOperationException("WTF?");
        }

        @Override
        public Val value() {
            return ((AttributeFactory.ConstantQualifier)this.delegate).value();
        }

        @Override
        public String toString() {
            return "EvalWatchConstQual{" + this.delegate + '}';
        }
    }

    public static final class EvalWatchConstQualEquat
    extends AbstractEvalWatch<AttributeFactory.ConstantQualifierEquator>
    implements AttributeFactory.ConstantQualifierEquator {
        EvalWatchConstQualEquat(AttributeFactory.ConstantQualifierEquator delegate, InterpretableDecorator.EvalObserver observer, TypeAdapter adapter) {
            super(delegate, observer, adapter);
        }

        @Override
        public Val eval(Activation activation) {
            throw new UnsupportedOperationException("WTF?");
        }

        @Override
        public Val value() {
            return ((AttributeFactory.ConstantQualifierEquator)this.delegate).value();
        }

        @Override
        public boolean qualifierValueEquals(Object value) {
            return ((AttributeFactory.ConstantQualifierEquator)this.delegate).qualifierValueEquals(value);
        }

        @Override
        public String toString() {
            return "EvalWatchConstQualEquat{" + this.delegate + '}';
        }
    }

    public static abstract class AbstractEvalWatch<T extends AttributeFactory.Qualifier>
    extends AbstractEval
    implements Coster,
    AttributeFactory.Qualifier {
        protected final T delegate;
        protected final InterpretableDecorator.EvalObserver observer;
        protected final TypeAdapter adapter;

        AbstractEvalWatch(T delegate, InterpretableDecorator.EvalObserver observer, TypeAdapter adapter) {
            super(delegate.id());
            this.delegate = delegate;
            this.observer = Objects.requireNonNull(observer);
            this.adapter = Objects.requireNonNull(adapter);
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            Object out = this.delegate.qualify(vars, obj);
            Val val = out != null ? this.adapter.nativeToValue(out) : Err.newErr(String.format("qualify failed, vars=%s, obj=%s", vars, obj), new Object[0]);
            this.observer.observe(this.id(), val);
            return out;
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.estimateCost(this.delegate);
        }
    }

    public static final class EvalWatchAttr
    implements Coster,
    InterpretableAttribute,
    AttributeFactory.Attribute {
        private final InterpretableAttribute attr;
        private final InterpretableDecorator.EvalObserver observer;

        public EvalWatchAttr(InterpretableAttribute attr, InterpretableDecorator.EvalObserver observer) {
            this.attr = Objects.requireNonNull(attr);
            this.observer = Objects.requireNonNull(observer);
        }

        @Override
        public long id() {
            return this.attr.id();
        }

        @Override
        public AttributeFactory.Attribute addQualifier(AttributeFactory.Qualifier q) {
            if (q instanceof AttributeFactory.ConstantQualifierEquator) {
                AttributeFactory.ConstantQualifierEquator cq = (AttributeFactory.ConstantQualifierEquator)q;
                q = new EvalWatchConstQualEquat(cq, this.observer, this.attr.adapter());
            } else if (q instanceof AttributeFactory.ConstantQualifier) {
                AttributeFactory.ConstantQualifier cq = (AttributeFactory.ConstantQualifier)q;
                q = new EvalWatchConstQual(cq, this.observer, this.attr.adapter());
            } else {
                q = new EvalWatchQual(q, this.observer, this.attr.adapter());
            }
            this.attr.addQualifier(q);
            return this;
        }

        @Override
        public AttributeFactory.Attribute attr() {
            return this.attr.attr();
        }

        @Override
        public TypeAdapter adapter() {
            return this.attr.adapter();
        }

        @Override
        public Object qualify(Activation vars, Object obj) {
            return this.attr.qualify(vars, obj);
        }

        @Override
        public Object resolve(Activation act) {
            return this.attr.resolve(act);
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.estimateCost(this.attr);
        }

        @Override
        public Val eval(Activation ctx) {
            Val val = this.attr.eval(ctx);
            this.observer.observe(this.id(), val);
            return val;
        }

        public String toString() {
            return "EvalWatchAttr{" + this.attr + '}';
        }
    }

    public static final class EvalWatch
    implements Interpretable,
    Coster {
        private final Interpretable i;
        private final InterpretableDecorator.EvalObserver observer;

        public EvalWatch(Interpretable i, InterpretableDecorator.EvalObserver observer) {
            this.i = Objects.requireNonNull(i);
            this.observer = Objects.requireNonNull(observer);
        }

        @Override
        public long id() {
            return this.i.id();
        }

        @Override
        public Val eval(Activation ctx) {
            Val val = this.i.eval(ctx);
            this.observer.observe(this.id(), val);
            return val;
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.estimateCost(this.i);
        }

        public String toString() {
            return "EvalWatch{" + this.i + '}';
        }
    }

    public static final class EvalSetMembership
    extends AbstractEval
    implements Coster {
        private final Interpretable inst;
        private final Interpretable arg;
        private final String argTypeName;
        private final Set<Val> valueSet;

        EvalSetMembership(Interpretable inst, Interpretable arg, String argTypeName, Set<Val> valueSet) {
            super(inst.id());
            this.inst = inst;
            this.arg = arg;
            this.argTypeName = argTypeName;
            this.valueSet = valueSet;
        }

        @Override
        public Val eval(Activation ctx) {
            Val val = this.arg.eval(ctx);
            if (!val.type().typeName().equals(this.argTypeName)) {
                return Err.noSuchOverload(null, Operator.In.id, val);
            }
            return this.valueSet.contains(val) ? BoolT.True : BoolT.False;
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.estimateCost(this.arg);
        }

        @Override
        public String toString() {
            return "EvalSetMembership{id=" + this.id + ", inst=" + this.inst + ", arg=" + this.arg + ", argTypeName='" + this.argTypeName + '\'' + ", valueSet=" + this.valueSet + '}';
        }
    }

    public static final class EvalFold
    extends AbstractEval
    implements Coster {
        final String accuVar;
        final String iterVar;
        final Interpretable iterRange;
        final Interpretable accu;
        final Interpretable cond;
        final Interpretable step;
        final Interpretable result;

        EvalFold(long id, String accuVar, Interpretable accu, String iterVar, Interpretable iterRange, Interpretable cond, Interpretable step, Interpretable result) {
            super(id);
            this.accuVar = accuVar;
            this.iterVar = iterVar;
            this.iterRange = iterRange;
            this.accu = accu;
            this.cond = cond;
            this.step = step;
            this.result = result;
        }

        @Override
        public Val eval(Activation ctx) {
            Val foldRange = this.iterRange.eval(ctx);
            if (!foldRange.type().hasTrait(Trait.IterableType)) {
                return Err.valOrErr(foldRange, "got '%s', expected iterable type", foldRange.getClass().getName());
            }
            Activation.VarActivation accuCtx = new Activation.VarActivation();
            accuCtx.parent = ctx;
            accuCtx.name = this.accuVar;
            accuCtx.val = this.accu.eval(ctx);
            Activation.VarActivation iterCtx = new Activation.VarActivation();
            iterCtx.parent = accuCtx;
            iterCtx.name = this.iterVar;
            IteratorT it = ((IterableT)((Object)foldRange)).iterator();
            while (it.hasNext() == BoolT.True) {
                iterCtx.val = it.next();
                Val c = this.cond.eval(iterCtx);
                if (c == BoolT.False) break;
                accuCtx.val = this.step.eval(iterCtx);
            }
            return this.result.eval(accuCtx);
        }

        @Override
        public Coster.Cost cost() {
            Coster.Cost i = Coster.Cost.estimateCost(this.iterRange);
            Val foldRange = this.iterRange.eval(Activation.emptyActivation());
            if (!foldRange.type().hasTrait(Trait.IterableType)) {
                return Coster.Cost.Unknown;
            }
            long rangeCnt = 0L;
            IteratorT it = ((IterableT)((Object)foldRange)).iterator();
            while (it.hasNext() == BoolT.True) {
                it.next();
                ++rangeCnt;
            }
            Coster.Cost a = Coster.Cost.estimateCost(this.accu);
            Coster.Cost c = Coster.Cost.estimateCost(this.cond);
            Coster.Cost s2 = Coster.Cost.estimateCost(this.step);
            Coster.Cost r = Coster.Cost.estimateCost(this.result);
            return i.add(a).add(r).add(Coster.costOf(c.min, c.max * rangeCnt)).add(Coster.costOf(s2.min, s2.max * rangeCnt));
        }

        @Override
        public String toString() {
            return "EvalFold{id=" + this.id + ", accuVar='" + this.accuVar + '\'' + ", iterVar='" + this.iterVar + '\'' + ", iterRange=" + this.iterRange + ", accu=" + this.accu + ", cond=" + this.cond + ", step=" + this.step + ", result=" + this.result + '}';
        }
    }

    public static final class EvalObj
    extends AbstractEval
    implements Coster {
        private final String typeName;
        private final String[] fields;
        private final Interpretable[] vals;
        private final TypeProvider provider;

        EvalObj(long id, String typeName, String[] fields, Interpretable[] vals, TypeProvider provider) {
            super(id);
            this.typeName = Objects.requireNonNull(typeName);
            this.fields = Objects.requireNonNull(fields);
            this.vals = Objects.requireNonNull(vals);
            this.provider = Objects.requireNonNull(provider);
        }

        @Override
        public Val eval(Activation ctx) {
            HashMap<String, Val> fieldVals = new HashMap<String, Val>();
            for (int i = 0; i < this.fields.length; ++i) {
                String field = this.fields[i];
                Val val = this.vals[i].eval(ctx);
                if (Util.isUnknownOrError(val)) {
                    return val;
                }
                fieldVals.put(field, val);
            }
            return this.provider.newValue(this.typeName, fieldVals);
        }

        @Override
        public Coster.Cost cost() {
            return Interpretable.sumOfCost(this.vals);
        }

        @Override
        public String toString() {
            return "EvalObj{id=" + this.id + ", typeName='" + this.typeName + '\'' + ", fields=" + Arrays.toString(this.fields) + ", vals=" + Arrays.toString(this.vals) + ", provider=" + this.provider + '}';
        }
    }

    public static final class EvalMap
    extends AbstractEval
    implements Coster {
        final Interpretable[] keys;
        final Interpretable[] vals;
        private final TypeAdapter adapter;

        EvalMap(long id, Interpretable[] keys2, Interpretable[] vals, TypeAdapter adapter) {
            super(id);
            this.keys = keys2;
            this.vals = vals;
            this.adapter = adapter;
        }

        @Override
        public Val eval(Activation ctx) {
            HashMap<Val, Val> entries = new HashMap<Val, Val>();
            for (int i = 0; i < this.keys.length; ++i) {
                Interpretable key = this.keys[i];
                Val keyVal = key.eval(ctx);
                if (Util.isUnknownOrError(keyVal)) {
                    return keyVal;
                }
                if (keyVal.type().typeEnum() == TypeEnum.Null) {
                    return Err.newErr("unsupported key type", new Object[0]);
                }
                Val valVal = this.vals[i].eval(ctx);
                if (Util.isUnknownOrError(valVal)) {
                    return valVal;
                }
                if (entries.putIfAbsent(keyVal, valVal) == null) continue;
                return Err.newErr("Failed with repeated key", new Object[0]);
            }
            return this.adapter.nativeToValue(entries);
        }

        @Override
        public Coster.Cost cost() {
            Coster.Cost k = Interpretable.sumOfCost(this.keys);
            Coster.Cost v = Interpretable.sumOfCost(this.vals);
            return k.add(v);
        }

        @Override
        public String toString() {
            return "EvalMap{id=" + this.id + ", keys=" + Arrays.toString(this.keys) + ", vals=" + Arrays.toString(this.vals) + '}';
        }
    }

    public static final class EvalList
    extends AbstractEval
    implements Coster {
        final Interpretable[] elems;
        private final TypeAdapter adapter;

        EvalList(long id, Interpretable[] elems, TypeAdapter adapter) {
            super(id);
            this.elems = elems;
            this.adapter = adapter;
        }

        @Override
        public Val eval(Activation ctx) {
            Val[] elemVals = new Val[this.elems.length];
            for (int i = 0; i < this.elems.length; ++i) {
                Interpretable elem = this.elems[i];
                Val elemVal = elem.eval(ctx);
                if (Util.isUnknownOrError(elemVal)) {
                    return elemVal;
                }
                elemVals[i] = elemVal;
            }
            return this.adapter.nativeToValue(elemVals);
        }

        @Override
        public Coster.Cost cost() {
            return Interpretable.sumOfCost(this.elems);
        }

        @Override
        public String toString() {
            return "EvalList{id=" + this.id + ", elems=" + Arrays.toString(this.elems) + '}';
        }
    }

    public static final class EvalVarArgs
    extends AbstractEval
    implements Coster,
    InterpretableCall {
        private final String function;
        private final String overload;
        private final Interpretable[] args;
        private final Trait trait;
        private final FunctionOp impl;

        public EvalVarArgs(long id, String function, String overload, Interpretable[] args, Trait trait, FunctionOp impl) {
            super(id);
            this.function = Objects.requireNonNull(function);
            this.overload = Objects.requireNonNull(overload);
            this.args = Objects.requireNonNull(args);
            this.trait = trait;
            this.impl = impl;
        }

        @Override
        public Val eval(Activation ctx) {
            Val[] argVals = new Val[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                Interpretable arg = this.args[i];
                argVals[i] = arg.eval(ctx);
                if (!Util.isUnknownOrError(argVals[i])) continue;
                return argVals[i];
            }
            Val arg0 = argVals[0];
            if (this.impl != null && (this.trait == null || arg0.type().hasTrait(this.trait))) {
                return this.impl.invoke(argVals);
            }
            if (arg0.type().hasTrait(Trait.ReceiverType)) {
                return ((Receiver)((Object)arg0)).receive(this.function, this.overload, Arrays.copyOfRange(argVals, 1, argVals.length - 1));
            }
            return Err.noSuchOverload(arg0, this.function, this.overload, argVals);
        }

        @Override
        public Coster.Cost cost() {
            Coster.Cost c = Interpretable.sumOfCost(this.args);
            return c.add(Coster.Cost.OneOne);
        }

        @Override
        public String function() {
            return this.function;
        }

        @Override
        public String overloadID() {
            return this.overload;
        }

        @Override
        public Interpretable[] args() {
            return this.args;
        }

        @Override
        public String toString() {
            return "EvalVarArgs{id=" + this.id + ", function='" + this.function + '\'' + ", overload='" + this.overload + '\'' + ", args=" + Arrays.toString(this.args) + ", trait=" + (Object)((Object)this.trait) + ", impl=" + this.impl + '}';
        }
    }

    public static final class EvalBinary
    extends AbstractEvalLhsRhs
    implements InterpretableCall {
        private final String function;
        private final String overload;
        private final Trait trait;
        private final BinaryOp impl;

        EvalBinary(long id, String function, String overload, Interpretable lhs, Interpretable rhs, Trait trait, BinaryOp impl) {
            super(id, lhs, rhs);
            this.function = Objects.requireNonNull(function);
            this.overload = Objects.requireNonNull(overload);
            this.trait = trait;
            this.impl = impl;
        }

        @Override
        public Val eval(Activation ctx) {
            Val lVal = this.lhs.eval(ctx);
            Val rVal = this.rhs.eval(ctx);
            if (Util.isUnknownOrError(lVal)) {
                return lVal;
            }
            if (Util.isUnknownOrError(rVal)) {
                return rVal;
            }
            if (this.impl != null && (this.trait == null || lVal.type().hasTrait(this.trait))) {
                return this.impl.invoke(lVal, rVal);
            }
            if (lVal.type().hasTrait(Trait.ReceiverType)) {
                return ((Receiver)((Object)lVal)).receive(this.function, this.overload, rVal);
            }
            return Err.noSuchOverload(lVal, this.function, this.overload, new Val[]{rVal});
        }

        @Override
        public Coster.Cost cost() {
            return Interpretable.calExhaustiveBinaryOpsCost(this.lhs, this.rhs);
        }

        @Override
        public String function() {
            return this.function;
        }

        @Override
        public String overloadID() {
            return this.overload;
        }

        @Override
        public Interpretable[] args() {
            return new Interpretable[]{this.lhs, this.rhs};
        }

        @Override
        public String toString() {
            return "EvalBinary{id=" + this.id + ", lhs=" + this.lhs + ", rhs=" + this.rhs + ", function='" + this.function + '\'' + ", overload='" + this.overload + '\'' + ", trait=" + (Object)((Object)this.trait) + ", impl=" + this.impl + '}';
        }
    }

    public static final class EvalUnary
    extends AbstractEval
    implements InterpretableCall,
    Coster {
        private final String function;
        private final String overload;
        private final Interpretable arg;
        private final Trait trait;
        private final UnaryOp impl;

        EvalUnary(long id, String function, String overload, Interpretable arg, Trait trait, UnaryOp impl) {
            super(id);
            this.function = Objects.requireNonNull(function);
            this.overload = Objects.requireNonNull(overload);
            this.arg = Objects.requireNonNull(arg);
            this.trait = trait;
            this.impl = impl;
        }

        @Override
        public Val eval(Activation ctx) {
            Val argVal = this.arg.eval(ctx);
            if (Util.isUnknownOrError(argVal)) {
                return argVal;
            }
            if (this.impl != null && (this.trait == null || argVal.type().hasTrait(this.trait))) {
                return this.impl.invoke(argVal);
            }
            if (argVal.type().hasTrait(Trait.ReceiverType)) {
                return ((Receiver)((Object)argVal)).receive(this.function, this.overload, new Val[0]);
            }
            return Err.noSuchOverload(argVal, this.function, this.overload, new Val[0]);
        }

        @Override
        public Coster.Cost cost() {
            Coster.Cost c = Coster.Cost.estimateCost(this.arg);
            return Coster.Cost.OneOne.add(c);
        }

        @Override
        public String function() {
            return this.function;
        }

        @Override
        public String overloadID() {
            return this.overload;
        }

        @Override
        public Interpretable[] args() {
            return new Interpretable[]{this.arg};
        }

        @Override
        public String toString() {
            return "EvalUnary{id=" + this.id + ", function='" + this.function + '\'' + ", overload='" + this.overload + '\'' + ", arg=" + this.arg + ", trait=" + (Object)((Object)this.trait) + ", impl=" + this.impl + '}';
        }
    }

    public static final class EvalZeroArity
    extends AbstractEval
    implements InterpretableCall,
    Coster {
        private final String function;
        private final String overload;
        private final FunctionOp impl;

        EvalZeroArity(long id, String function, String overload, FunctionOp impl) {
            super(id);
            this.function = Objects.requireNonNull(function);
            this.overload = Objects.requireNonNull(overload);
            this.impl = impl;
        }

        @Override
        public Val eval(Activation activation) {
            return this.impl.invoke(new Val[0]);
        }

        @Override
        public Coster.Cost cost() {
            return Coster.Cost.OneOne;
        }

        @Override
        public String function() {
            return this.function;
        }

        @Override
        public String overloadID() {
            return this.overload;
        }

        @Override
        public Interpretable[] args() {
            return new Interpretable[0];
        }

        @Override
        public String toString() {
            return "EvalZeroArity{id=" + this.id + ", function='" + this.function + '\'' + ", overload='" + this.overload + '\'' + ", impl=" + this.impl + '}';
        }
    }

    public static final class EvalNe
    extends AbstractEvalLhsRhs
    implements InterpretableCall {
        EvalNe(long id, Interpretable lhs, Interpretable rhs) {
            super(id, lhs, rhs);
        }

        @Override
        public Val eval(Activation ctx) {
            Val lVal = this.lhs.eval(ctx);
            Val rVal = this.rhs.eval(ctx);
            Val eqVal = lVal.equal(rVal);
            switch (eqVal.type().typeEnum()) {
                case Err: {
                    return eqVal;
                }
                case Bool: {
                    return ((Negater)((Object)eqVal)).negate();
                }
            }
            return Err.noSuchOverload(lVal, Operator.NotEquals.id, rVal);
        }

        @Override
        public Coster.Cost cost() {
            return Interpretable.calExhaustiveBinaryOpsCost(this.lhs, this.rhs);
        }

        @Override
        public String function() {
            return Operator.NotEquals.id;
        }

        @Override
        public String overloadID() {
            return "not_equals";
        }

        @Override
        public Interpretable[] args() {
            return new Interpretable[]{this.lhs, this.rhs};
        }

        @Override
        public String toString() {
            return "EvalNe{id=" + this.id + ", lhs=" + this.lhs + ", rhs=" + this.rhs + '}';
        }
    }

    public static final class EvalEq
    extends AbstractEvalLhsRhs
    implements InterpretableCall {
        EvalEq(long id, Interpretable lhs, Interpretable rhs) {
            super(id, lhs, rhs);
        }

        @Override
        public Val eval(Activation ctx) {
            Val lVal = this.lhs.eval(ctx);
            Val rVal = this.rhs.eval(ctx);
            return lVal.equal(rVal);
        }

        @Override
        public Coster.Cost cost() {
            return Interpretable.calExhaustiveBinaryOpsCost(this.lhs, this.rhs);
        }

        @Override
        public String function() {
            return Operator.Equals.id;
        }

        @Override
        public String overloadID() {
            return "equals";
        }

        @Override
        public Interpretable[] args() {
            return new Interpretable[]{this.lhs, this.rhs};
        }

        @Override
        public String toString() {
            return "EvalEq{id=" + this.id + ", lhs=" + this.lhs + ", rhs=" + this.rhs + '}';
        }
    }

    public static final class EvalAnd
    extends AbstractEvalLhsRhs {
        EvalAnd(long id, Interpretable lhs, Interpretable rhs) {
            super(id, lhs, rhs);
        }

        @Override
        public Val eval(Activation ctx) {
            Val lVal = this.lhs.eval(ctx);
            if (lVal == BoolT.False) {
                return BoolT.False;
            }
            Val rVal = this.rhs.eval(ctx);
            if (rVal == BoolT.False) {
                return BoolT.False;
            }
            if (lVal == BoolT.True && rVal == BoolT.True) {
                return BoolT.True;
            }
            if (UnknownT.isUnknown(lVal)) {
                return lVal;
            }
            if (UnknownT.isUnknown(rVal)) {
                return rVal;
            }
            if (Err.isError(lVal)) {
                return lVal;
            }
            return Err.noSuchOverload(lVal, Operator.LogicalAnd.id, rVal);
        }

        @Override
        public Coster.Cost cost() {
            return Interpretable.calShortCircuitBinaryOpsCost(this.lhs, this.rhs);
        }

        @Override
        public String toString() {
            return "EvalAnd{id=" + this.id + ", lhs=" + this.lhs + ", rhs=" + this.rhs + '}';
        }
    }

    public static final class EvalOr
    extends AbstractEvalLhsRhs {
        EvalOr(long id, Interpretable lhs, Interpretable rhs) {
            super(id, lhs, rhs);
        }

        @Override
        public Val eval(Activation ctx) {
            Val lVal = this.lhs.eval(ctx);
            if (lVal == BoolT.True) {
                return BoolT.True;
            }
            Val rVal = this.rhs.eval(ctx);
            if (rVal == BoolT.True) {
                return BoolT.True;
            }
            if (lVal == BoolT.False && rVal == BoolT.False) {
                return BoolT.False;
            }
            if (UnknownT.isUnknown(lVal)) {
                return lVal;
            }
            if (UnknownT.isUnknown(rVal)) {
                return rVal;
            }
            if (Err.isError(lVal)) {
                return lVal;
            }
            return Err.noSuchOverload(lVal, Operator.LogicalOr.id, rVal);
        }

        @Override
        public Coster.Cost cost() {
            return Interpretable.calShortCircuitBinaryOpsCost(this.lhs, this.rhs);
        }

        @Override
        public String toString() {
            return "EvalOr{id=" + this.id + ", lhs=" + this.lhs + ", rhs=" + this.rhs + '}';
        }
    }

    public static abstract class AbstractEvalLhsRhs
    extends AbstractEval
    implements Coster {
        protected final Interpretable lhs;
        protected final Interpretable rhs;

        AbstractEvalLhsRhs(long id, Interpretable lhs, Interpretable rhs) {
            super(id);
            this.lhs = Objects.requireNonNull(lhs);
            this.rhs = Objects.requireNonNull(rhs);
        }

        @Override
        public String toString() {
            return "AbstractEvalLhsRhs{id=" + this.id + ", lhs=" + this.lhs + ", rhs=" + this.rhs + '}';
        }
    }

    public static abstract class AbstractEval
    implements Interpretable {
        protected final long id;

        AbstractEval(long id) {
            this.id = id;
        }

        @Override
        public long id() {
            return this.id;
        }

        public String toString() {
            return "id=" + this.id;
        }
    }

    public static final class EvalTestOnly
    implements Interpretable,
    Coster {
        private final long id;
        private final Interpretable op;
        private final StringT field;
        private final FieldType fieldType;

        EvalTestOnly(long id, Interpretable op, StringT field, FieldType fieldType) {
            this.id = id;
            this.op = Objects.requireNonNull(op);
            this.field = Objects.requireNonNull(field);
            this.fieldType = fieldType;
        }

        @Override
        public long id() {
            return this.id;
        }

        @Override
        public Val eval(Activation ctx) {
            if (this.fieldType != null && this.op instanceof InterpretableAttribute) {
                InterpretableAttribute opAttr = (InterpretableAttribute)this.op;
                Object opVal = opAttr.resolve(ctx);
                if (opVal instanceof Val) {
                    Val refVal = (Val)opVal;
                    opVal = refVal.value();
                }
                if (this.fieldType.isSet.isSet(opVal)) {
                    return BoolT.True;
                }
                return BoolT.False;
            }
            Val obj = this.op.eval(ctx);
            if (obj instanceof FieldTester) {
                return ((FieldTester)((Object)obj)).isSet(this.field);
            }
            if (obj instanceof Container) {
                return ((Container)((Object)obj)).contains(this.field);
            }
            return Err.valOrErr(obj, "invalid type for field selection.", new Object[0]);
        }

        @Override
        public Coster.Cost cost() {
            Coster.Cost c = Coster.Cost.estimateCost(this.op);
            return c.add(Coster.Cost.OneOne);
        }

        public String toString() {
            return "EvalTestOnly{id=" + this.id + ", field=" + this.field + '}';
        }
    }

    public static interface InterpretableCall
    extends Interpretable {
        public String function();

        public String overloadID();

        public Interpretable[] args();
    }

    public static interface InterpretableAttribute
    extends Interpretable,
    AttributeFactory.Qualifier,
    AttributeFactory.Attribute {
        public AttributeFactory.Attribute attr();

        public TypeAdapter adapter();

        @Override
        public AttributeFactory.Attribute addQualifier(AttributeFactory.Qualifier var1);

        @Override
        public Object qualify(Activation var1, Object var2);

        @Override
        public Object resolve(Activation var1);
    }

    public static interface InterpretableConst
    extends Interpretable {
        public Val value();
    }
}

