/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.cel.parser;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public final class Unescape {
    private static final ThreadLocal<CharsetEncoder> encoderThreadLocal = ThreadLocal.withInitial(StandardCharsets.UTF_8::newEncoder);
    private static final ThreadLocal<CharsetDecoder> utf8decoder = ThreadLocal.withInitial(StandardCharsets.UTF_8::newDecoder);

    public static ByteBuffer unescape(String value, boolean isBytes) {
        int n = (value = value.replaceAll("\r\n", "\n").replaceAll("\r", "\n")).length();
        if (n < 2) {
            return Unescape.wrapBlindly(value);
        }
        boolean isRawLiteral = false;
        if (value.charAt(0) == 'r' || value.charAt(0) == 'R') {
            value = value.substring(1);
            n = value.length();
            isRawLiteral = true;
        }
        if (value.charAt(0) != value.charAt(n - 1) || value.charAt(0) != '\"' && value.charAt(0) != '\'') {
            return Unescape.wrapBlindly(value);
        }
        if (n >= 6) {
            if (value.startsWith("'''")) {
                if (!value.endsWith("'''")) {
                    return Unescape.wrapBlindly(value);
                }
                value = "\"" + value.substring(3, n - 3) + "\"";
                n = value.length();
            } else if (value.startsWith("\"\"\"")) {
                if (!value.endsWith("\"\"\"")) {
                    return Unescape.wrapBlindly(value);
                }
                value = "\"" + value.substring(3, n - 3) + "\"";
                n = value.length();
            }
        }
        value = value.substring(1, n - 1);
        n -= 2;
        if (isRawLiteral || value.indexOf(92) == -1) {
            return Unescape.wrapBlindly(value);
        }
        CharsetEncoder enc = null;
        CharBuffer cb = null;
        char[] encBuf = new char[2];
        if (!isBytes) {
            cb = CharBuffer.wrap(encBuf);
            enc = encoderThreadLocal.get().reset().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        }
        ByteBuffer buf = ByteBuffer.allocate(value.length() * 3 / 2);
        block21: for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                if (++i == n) {
                    throw new IllegalArgumentException("unable to unescape string, found '\\' as last character");
                }
                c = value.charAt(i);
                switch (c) {
                    case 'a': {
                        buf.put((byte)7);
                        continue block21;
                    }
                    case 'b': {
                        buf.put((byte)8);
                        continue block21;
                    }
                    case 'f': {
                        buf.put((byte)12);
                        continue block21;
                    }
                    case 'n': {
                        buf.put((byte)10);
                        continue block21;
                    }
                    case 'r': {
                        buf.put((byte)13);
                        continue block21;
                    }
                    case 't': {
                        buf.put((byte)9);
                        continue block21;
                    }
                    case 'v': {
                        buf.put((byte)11);
                        continue block21;
                    }
                    case '\\': {
                        buf.put((byte)92);
                        continue block21;
                    }
                    case '\'': {
                        buf.put((byte)39);
                        continue block21;
                    }
                    case '\"': {
                        buf.put((byte)34);
                        continue block21;
                    }
                    case '`': {
                        buf.put((byte)96);
                        continue block21;
                    }
                    case '?': {
                        buf.put((byte)63);
                        continue block21;
                    }
                    case 'U': 
                    case 'X': 
                    case 'u': 
                    case 'x': {
                        int j;
                        int nHex = 0;
                        switch (c) {
                            case 'X': 
                            case 'x': {
                                nHex = 2;
                                break;
                            }
                            case 'u': {
                                nHex = 4;
                                if (!isBytes) break;
                                throw Unescape.unableToUnescapeString();
                            }
                            case 'U': {
                                nHex = 8;
                                if (!isBytes) break;
                                throw Unescape.unableToUnescapeString();
                            }
                        }
                        if (n - nHex < i) {
                            throw Unescape.unableToUnescapeString();
                        }
                        int v = 0;
                        for (j = 0; j < nHex; ++j) {
                            int nib;
                            if ((nib = Unescape.unhex(c = value.charAt(++i))) == -1) {
                                throw Unescape.unableToUnescapeString();
                            }
                            v = v << 4 | nib;
                        }
                        if (!isBytes) {
                            Unescape.encodeCodePoint(buf, v, cb, enc);
                            continue block21;
                        }
                        buf.put((byte)v);
                        continue block21;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        int j;
                        if (n - 3 < i) {
                            throw Unescape.unableToUnescapeOctalSequence();
                        }
                        int v = c - 48;
                        for (j = 0; j < 2; ++j) {
                            if ((c = value.charAt(++i)) < '0' || c > '7') {
                                throw Unescape.unableToUnescapeOctalSequence();
                            }
                            v = v << 3 | c - 48;
                        }
                        if (!isBytes) {
                            Unescape.encodeCodePoint(buf, v, cb, enc);
                            continue block21;
                        }
                        buf.put((byte)v);
                        continue block21;
                    }
                    default: {
                        throw Unescape.unableToUnescapeString();
                    }
                }
            }
            if (!isBytes) {
                Unescape.encodeCodePoint(buf, c, cb, enc);
                continue;
            }
            buf.put((byte)c);
        }
        buf.flip();
        return buf;
    }

    private static ByteBuffer wrapBlindly(String value) {
        return ByteBuffer.wrap(value.getBytes(StandardCharsets.UTF_8));
    }

    private static IllegalArgumentException unableToUnescapeOctalSequence() {
        return new IllegalArgumentException("unable to unescape octal sequence in string");
    }

    private static IllegalArgumentException unableToUnescapeString() {
        return new IllegalArgumentException("unable to unescape string");
    }

    private static void encodeCodePoint(ByteBuffer buf, int v, CharBuffer cb, CharsetEncoder enc) {
        int n = Character.toChars(v, cb.array(), 0);
        cb.clear();
        cb.position(0).limit(n);
        enc.encode(cb, buf, false);
    }

    static int unhex(char b) {
        if (b >= '0' && b <= '9') {
            return b - 48;
        }
        if (b >= 'a' && b <= 'f') {
            return b - 97 + 10;
        }
        if (b >= 'A' && b <= 'F') {
            return b - 65 + 10;
        }
        return -1;
    }

    public static String toUtf8(ByteBuffer buf) {
        CharsetDecoder dec = utf8decoder.get();
        try {
            dec.onMalformedInput(CodingErrorAction.REPORT);
            dec.onUnmappableCharacter(CodingErrorAction.REPORT);
            String string = dec.decode(buf).toString();
            return string;
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        finally {
            dec.reset();
        }
    }
}

