/*
 * Decompiled with CFR 0.152.
 */
package no.entur;

import java.io.File;
import no.entur.schema2proto.generateproto.Schema2Proto;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class GenerateProtoMojo
extends AbstractMojo {
    @Parameter(required=true)
    private File configFile;
    @Parameter(required=true)
    private File xsdFile;

    public void execute() throws MojoExecutionException {
        try {
            if (this.configFile == null || !this.configFile.exists()) {
                throw new MojoExecutionException("Config file not found");
            }
            if (this.xsdFile == null || !this.xsdFile.exists()) {
                throw new MojoExecutionException("XSD file not found");
            }
            this.getLog().info((CharSequence)String.format("Generating proto files from %s using config file %s. Output is defined in config file", this.xsdFile, this.configFile));
            Schema2Proto.main((String[])new String[]{"--configFile=" + this.configFile, "" + this.xsdFile});
        }
        catch (MojoExecutionException e) {
            throw new MojoExecutionException("Error generating proto files", (Exception)((Object)e));
        }
    }
}

