/*
 * Decompiled with CFR 0.152.
 */
package no.entur;

import java.io.File;
import java.io.IOException;
import no.entur.schema2proto.InvalidConfigurationException;
import no.entur.schema2proto.modifyproto.InvalidProtobufException;
import no.entur.schema2proto.modifyproto.ModifyProto;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="modify", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class ModifyProtoMojo
extends AbstractMojo {
    @Parameter(required=true)
    private File configFile;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        if (this.configFile == null || !this.configFile.exists()) {
            throw new MojoExecutionException("Config file not found");
        }
        this.getLog().info((CharSequence)String.format("Modifying proto files from using config file %s. Output is defined in config file", this.configFile));
        try {
            new ModifyProto().modifyProto(this.configFile, this.project.getBasedir());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error modifying proto files", (Exception)e);
        }
        catch (InvalidConfigurationException e) {
            throw new MojoExecutionException("Invalid modify configuration file", (Exception)((Object)e));
        }
        catch (InvalidProtobufException e) {
            throw new MojoExecutionException("Could not fully modify proto files", (Exception)((Object)e));
        }
    }
}

