/*
 * Decompiled with CFR 0.152.
 */
package no.entur;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import no.entur.schema2proto.InvalidConfigurationException;
import no.entur.schema2proto.generateproto.Schema2Proto;
import no.entur.schema2proto.generateproto.Schema2ProtoConfiguration;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class GenerateProtoMojo
extends AbstractMojo {
    @Parameter(required=true)
    private File configFile;
    @Parameter(required=true)
    private File xsdFile;
    @Parameter(property="failIfRemovedFields")
    private Boolean failIfRemovedFields;

    public void execute() throws MojoExecutionException {
        try {
            if (this.configFile == null || !this.configFile.exists()) {
                throw new MojoExecutionException("Config file not found");
            }
            if (this.xsdFile == null || !this.xsdFile.exists()) {
                throw new MojoExecutionException("XSD file not found");
            }
            this.getLog().info((CharSequence)String.format("Generating proto files from %s using config file %s. Output is defined in config file", this.xsdFile, this.configFile));
            Schema2ProtoConfiguration configuration = new Schema2ProtoConfiguration();
            configuration.xsdFile = this.xsdFile;
            Schema2Proto.parseConfigurationFileIntoConfiguration((Schema2ProtoConfiguration)configuration, (InputStream)new FileInputStream(this.configFile));
            if (this.failIfRemovedFields != null) {
                configuration.failIfRemovedFields = this.failIfRemovedFields;
            }
            Schema2Proto.parseAndSerialize((Schema2ProtoConfiguration)configuration);
        }
        catch (IOException | InvalidConfigurationException | MojoExecutionException e) {
            throw new MojoExecutionException("Error generating proto files", (Exception)e);
        }
    }
}

